/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.map;

import org.apache.mahout.math.Sorting;
import org.apache.mahout.math.Swapper;
import org.apache.mahout.math.function.DoubleFunction;
import org.apache.mahout.math.function.IntComparator;
import org.apache.mahout.math.function.ShortDoubleProcedure;
import org.apache.mahout.math.function.ShortProcedure;
import org.apache.mahout.math.list.DoubleArrayList;
import org.apache.mahout.math.list.ShortArrayList;
import org.apache.mahout.math.set.AbstractSet;

public abstract class AbstractShortDoubleMap
extends AbstractSet {
    public boolean containsKey(final short key) {
        return !this.forEachKey(new ShortProcedure(){

            public boolean apply(short iterKey) {
                return key != iterKey;
            }
        });
    }

    public boolean containsValue(final double value) {
        return !this.forEachPair(new ShortDoubleProcedure(){

            public boolean apply(short iterKey, double iterValue) {
                return value != iterValue;
            }
        });
    }

    public AbstractShortDoubleMap copy() {
        return (AbstractShortDoubleMap)this.clone();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof AbstractShortDoubleMap)) {
            return false;
        }
        final AbstractShortDoubleMap other = (AbstractShortDoubleMap)obj;
        if (other.size() != this.size()) {
            return false;
        }
        return this.forEachPair(new ShortDoubleProcedure(){

            public boolean apply(short key, double value) {
                return other.containsKey(key) && other.get(key) == value;
            }
        }) && other.forEachPair(new ShortDoubleProcedure(){

            public boolean apply(short key, double value) {
                return AbstractShortDoubleMap.this.containsKey(key) && AbstractShortDoubleMap.this.get(key) == value;
            }
        });
    }

    public abstract boolean forEachKey(ShortProcedure var1);

    public boolean forEachPair(final ShortDoubleProcedure procedure) {
        return this.forEachKey(new ShortProcedure(){

            public boolean apply(short key) {
                return procedure.apply(key, AbstractShortDoubleMap.this.get(key));
            }
        });
    }

    public abstract double get(short var1);

    public ShortArrayList keys() {
        ShortArrayList list = new ShortArrayList(this.size());
        this.keys(list);
        return list;
    }

    public void keys(final ShortArrayList list) {
        list.clear();
        this.forEachKey(new ShortProcedure(){

            public boolean apply(short key) {
                list.add(key);
                return true;
            }
        });
    }

    public void keysSortedByValue(ShortArrayList keyList) {
        this.pairsSortedByValue(keyList, new DoubleArrayList(this.size()));
    }

    public void pairsMatching(final ShortDoubleProcedure condition, final ShortArrayList keyList, final DoubleArrayList valueList) {
        keyList.clear();
        valueList.clear();
        this.forEachPair(new ShortDoubleProcedure(){

            public boolean apply(short key, double value) {
                if (condition.apply(key, value)) {
                    keyList.add(key);
                    valueList.add(value);
                }
                return true;
            }
        });
    }

    public void pairsSortedByKey(ShortArrayList keyList, DoubleArrayList valueList) {
        this.keys(keyList);
        keyList.sort();
        valueList.setSize(keyList.size());
        int i = keyList.size();
        while (--i >= 0) {
            valueList.setQuick(i, this.get(keyList.getQuick(i)));
        }
    }

    public void pairsSortedByValue(ShortArrayList keyList, DoubleArrayList valueList) {
        this.keys(keyList);
        this.values(valueList);
        final short[] k = keyList.elements();
        final double[] v = valueList.elements();
        Swapper swapper = new Swapper(){

            public void swap(int a, int b) {
                double t1 = v[a];
                v[a] = v[b];
                v[b] = t1;
                short t2 = k[a];
                k[a] = k[b];
                k[b] = t2;
            }
        };
        IntComparator comp = new IntComparator(){

            public int compare(int a, int b) {
                return v[a] < v[b] ? -1 : (v[a] > v[b] ? 1 : (k[a] < k[b] ? -1 : (k[a] == k[b] ? 0 : 1)));
            }
        };
        Sorting.quickSort(0, keyList.size(), comp, swapper);
    }

    public abstract boolean put(short var1, double var2);

    public abstract boolean removeKey(short var1);

    public String toString() {
        ShortArrayList theKeys = this.keys();
        StringBuilder buf = new StringBuilder();
        buf.append('[');
        int maxIndex = theKeys.size() - 1;
        for (int i = 0; i <= maxIndex; ++i) {
            short key = theKeys.get(i);
            buf.append(String.valueOf(key));
            buf.append("->");
            buf.append(String.valueOf(this.get(key)));
            if (i >= maxIndex) continue;
            buf.append(", ");
        }
        buf.append(']');
        return buf.toString();
    }

    public String toStringByValue() {
        ShortArrayList theKeys = new ShortArrayList();
        this.keysSortedByValue(theKeys);
        StringBuilder buf = new StringBuilder();
        buf.append('[');
        int maxIndex = theKeys.size() - 1;
        for (int i = 0; i <= maxIndex; ++i) {
            short key = theKeys.get(i);
            buf.append(String.valueOf(key));
            buf.append("->");
            buf.append(String.valueOf(this.get(key)));
            if (i >= maxIndex) continue;
            buf.append(", ");
        }
        buf.append(']');
        return buf.toString();
    }

    public DoubleArrayList values() {
        DoubleArrayList list = new DoubleArrayList(this.size());
        this.values(list);
        return list;
    }

    public void values(final DoubleArrayList list) {
        list.clear();
        this.forEachKey(new ShortProcedure(){

            public boolean apply(short key) {
                list.add(AbstractShortDoubleMap.this.get(key));
                return true;
            }
        });
    }

    public void assign(final DoubleFunction function) {
        this.copy().forEachPair(new ShortDoubleProcedure(){

            public boolean apply(short key, double value) {
                AbstractShortDoubleMap.this.put(key, function.apply(value));
                return true;
            }
        });
    }

    public void assign(AbstractShortDoubleMap other) {
        this.clear();
        other.forEachPair(new ShortDoubleProcedure(){

            public boolean apply(short key, double value) {
                AbstractShortDoubleMap.this.put(key, value);
                return true;
            }
        });
    }

    public double adjustOrPutValue(short key, double newValue, double incrValue) {
        boolean present = this.containsKey(key);
        if (present) {
            newValue = this.get(key) + incrValue;
            this.put(key, newValue);
        } else {
            this.put(key, newValue);
        }
        return newValue;
    }
}

