/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.text;

import java.io.Closeable;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;

public final class ChunkedWriter
implements Closeable {
    private final int maxChunkSizeInBytes;
    private final Path output;
    private SequenceFile.Writer writer;
    private int currentChunkID;
    private int currentChunkSize;
    private final FileSystem fs;
    private final Configuration conf;

    public ChunkedWriter(Configuration conf, int chunkSizeInMB, Path output) throws IOException {
        this.output = output;
        this.conf = conf;
        if (chunkSizeInMB > 1984) {
            chunkSizeInMB = 1984;
        }
        this.maxChunkSizeInBytes = chunkSizeInMB * 1024 * 1024;
        this.fs = FileSystem.get((Configuration)conf);
        this.currentChunkID = 0;
        this.writer = new SequenceFile.Writer(this.fs, conf, this.getPath(this.currentChunkID), Text.class, Text.class);
    }

    private Path getPath(int chunkID) {
        return new Path(this.output, "chunk-" + chunkID);
    }

    public void write(String key, String value) throws IOException {
        if (this.currentChunkSize > this.maxChunkSizeInBytes) {
            this.writer.close();
            this.writer = new SequenceFile.Writer(this.fs, this.conf, this.getPath(this.currentChunkID++), Text.class, Text.class);
            this.currentChunkSize = 0;
        }
        Text keyT = new Text(key);
        Text valueT = new Text(value);
        this.currentChunkSize += keyT.getBytes().length + valueT.getBytes().length;
        this.writer.append((Writable)keyT, (Writable)valueT);
    }

    @Override
    public void close() throws IOException {
        this.writer.close();
    }
}

