/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.text;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.mahout.common.iterator.FileLineIterable;
import org.apache.mahout.text.ChunkedWriter;
import org.apache.mahout.text.SequenceFilesFromDirectoryFilter;

public final class PrefixAdditionFilter
extends SequenceFilesFromDirectoryFilter {
    public PrefixAdditionFilter(Configuration conf, String keyPrefix, Map<String, String> options, ChunkedWriter writer) throws IOException {
        super(conf, keyPrefix, options, writer);
    }

    @Override
    protected void process(FileStatus fst, Path current) throws IOException {
        if (fst.isDir()) {
            this.fs.listStatus(fst.getPath(), (PathFilter)new PrefixAdditionFilter(this.conf, this.prefix + "/" + current.getName(), this.options, this.writer));
        } else {
            FSDataInputStream in = this.fs.open(fst.getPath());
            StringBuilder file = new StringBuilder();
            for (String aFit : new FileLineIterable((InputStream)in, this.charset, false)) {
                file.append(aFit).append('\n');
            }
            String name = current.getName().equals(fst.getPath().getName()) ? current.getName() : current.getName() + "/" + fst.getPath().getName();
            this.writer.write(this.prefix + "/" + name, file.toString());
        }
    }
}

