/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.utils;

import com.google.common.base.Charsets;
import com.google.common.io.Files;
import java.io.File;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import org.apache.commons.cli2.CommandLine;
import org.apache.commons.cli2.Group;
import org.apache.commons.cli2.Option;
import org.apache.commons.cli2.OptionException;
import org.apache.commons.cli2.builder.ArgumentBuilder;
import org.apache.commons.cli2.builder.DefaultOptionBuilder;
import org.apache.commons.cli2.builder.GroupBuilder;
import org.apache.commons.cli2.commandline.Parser;
import org.apache.commons.cli2.option.DefaultOption;
import org.apache.commons.cli2.util.HelpFormatter;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.mahout.common.Pair;
import org.apache.mahout.common.iterator.sequencefile.SequenceFileIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SequenceFileDumper {
    private static final Logger log = LoggerFactory.getLogger(SequenceFileDumper.class);

    private SequenceFileDumper() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        block11: {
            DefaultOptionBuilder obuilder = new DefaultOptionBuilder();
            ArgumentBuilder abuilder = new ArgumentBuilder();
            GroupBuilder gbuilder = new GroupBuilder();
            DefaultOption seqOpt = obuilder.withLongName("seqFile").withRequired(false).withArgument(abuilder.withName("seqFile").withMinimum(1).withMaximum(1).create()).withDescription("The Sequence File containing the Clusters").withShortName("s").create();
            DefaultOption outputOpt = obuilder.withLongName("output").withRequired(false).withArgument(abuilder.withName("output").withMinimum(1).withMaximum(1).create()).withDescription("The output file.  If not specified, dumps to the console").withShortName("o").create();
            DefaultOption substringOpt = obuilder.withLongName("substring").withRequired(false).withArgument(abuilder.withName("substring").withMinimum(1).withMaximum(1).create()).withDescription("The number of chars of the asFormatString() to print").withShortName("b").create();
            DefaultOption countOpt = obuilder.withLongName("count").withRequired(false).withDescription("Report the count only").withShortName("c").create();
            DefaultOption helpOpt = obuilder.withLongName("help").withDescription("Print out help").withShortName("h").create();
            Group group = gbuilder.withName("Options").withOption((Option)seqOpt).withOption((Option)outputOpt).withOption((Option)substringOpt).withOption((Option)countOpt).withOption((Option)helpOpt).create();
            try {
                Parser parser = new Parser();
                parser.setGroup(group);
                CommandLine cmdLine = parser.parse(args);
                if (cmdLine.hasOption((Option)helpOpt)) {
                    SequenceFileDumper.printHelp(group);
                    return;
                }
                if (!cmdLine.hasOption((Option)seqOpt)) break block11;
                Path path = new Path(cmdLine.getValue((Option)seqOpt).toString());
                Configuration conf = new Configuration();
                Writer writer = cmdLine.hasOption((Option)outputOpt) ? Files.newWriter((File)new File(cmdLine.getValue((Option)outputOpt).toString()), (Charset)Charsets.UTF_8) : new OutputStreamWriter(System.out);
                try {
                    writer.append("Input Path: ").append(String.valueOf(path)).append('\n');
                    int sub = Integer.MAX_VALUE;
                    if (cmdLine.hasOption((Option)substringOpt)) {
                        sub = Integer.parseInt(cmdLine.getValue((Option)substringOpt).toString());
                    }
                    boolean countOnly = cmdLine.hasOption((Option)countOpt);
                    SequenceFileIterator iterator = new SequenceFileIterator(path, true, conf);
                    writer.append("Key class: ").append(iterator.getKeyClass().toString());
                    writer.append(" Value Class: ").append(iterator.getValueClass().toString()).append('\n');
                    long count = 0L;
                    if (countOnly) {
                        while (iterator.hasNext()) {
                            iterator.next();
                            ++count;
                        }
                        writer.append("Count: ").append(String.valueOf(count)).append('\n');
                    } else {
                        while (iterator.hasNext()) {
                            Pair record = (Pair)iterator.next();
                            writer.append("Key: ").append(record.getFirst().toString());
                            String str = record.getSecond().toString();
                            writer.append(": Value: ").append(str.length() > sub ? str.substring(0, sub) : str);
                            writer.write(10);
                            ++count;
                        }
                        writer.append("Count: ").append(String.valueOf(count)).append('\n');
                    }
                }
                finally {
                    writer.close();
                }
            }
            catch (OptionException e) {
                log.error("Exception", (Throwable)e);
                SequenceFileDumper.printHelp(group);
            }
        }
    }

    private static void printHelp(Group group) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.setGroup(group);
        formatter.print();
    }
}

