/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.utils.vectors;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.mahout.common.AbstractJob;
import org.apache.mahout.common.Pair;
import org.apache.mahout.common.iterator.sequencefile.PathType;
import org.apache.mahout.common.iterator.sequencefile.SequenceFileDirIterable;
import org.apache.mahout.math.VectorWritable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RowIdJob
extends AbstractJob {
    private static final Logger log = LoggerFactory.getLogger(RowIdJob.class);

    public int run(String[] strings) throws Exception {
        Configuration conf = this.getConf();
        FileSystem fs = FileSystem.get((Configuration)conf);
        Path inputPath = fs.makeQualified(new Path(conf.get("mapred.input.dir")));
        Path outputPath = fs.makeQualified(new Path(conf.get("mapred.output.dir")));
        Path indexPath = new Path(outputPath, "docIndex");
        Path matrixPath = new Path(outputPath, "matrix");
        SequenceFile.Writer indexWriter = SequenceFile.createWriter((FileSystem)fs, (Configuration)conf, (Path)indexPath, IntWritable.class, Text.class);
        SequenceFile.Writer matrixWriter = SequenceFile.createWriter((FileSystem)fs, (Configuration)conf, (Path)matrixPath, IntWritable.class, VectorWritable.class);
        IntWritable docId = new IntWritable();
        int i = 0;
        int numCols = 0;
        for (Pair record : new SequenceFileDirIterable(inputPath, PathType.LIST, null, null, true, conf)) {
            VectorWritable value = (VectorWritable)record.getSecond();
            docId.set(i);
            indexWriter.append((Writable)docId, (Writable)record.getFirst());
            matrixWriter.append((Writable)docId, (Writable)value);
            ++i;
            numCols = value.get().size();
        }
        matrixWriter.close();
        indexWriter.close();
        log.info("Wrote out matrix with {} rows and {} columns to {}", new Object[]{i, numCols, matrixPath});
        return 0;
    }

    public static void main(String[] args) throws Exception {
        ToolRunner.run((Tool)new RowIdJob(), (String[])args);
    }
}

