/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.utils.vectors;

import com.google.common.base.Charsets;
import com.google.common.io.Files;
import java.io.File;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import org.apache.commons.cli2.CommandLine;
import org.apache.commons.cli2.Group;
import org.apache.commons.cli2.Option;
import org.apache.commons.cli2.OptionException;
import org.apache.commons.cli2.builder.ArgumentBuilder;
import org.apache.commons.cli2.builder.DefaultOptionBuilder;
import org.apache.commons.cli2.builder.GroupBuilder;
import org.apache.commons.cli2.commandline.Parser;
import org.apache.commons.cli2.option.DefaultOption;
import org.apache.commons.cli2.util.HelpFormatter;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Writable;
import org.apache.mahout.common.Pair;
import org.apache.mahout.common.iterator.sequencefile.SequenceFileIterable;
import org.apache.mahout.math.NamedVector;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.VectorWritable;
import org.apache.mahout.utils.vectors.VectorHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class VectorDumper {
    private static final Logger log = LoggerFactory.getLogger(VectorDumper.class);

    private VectorDumper() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        block19: {
            DefaultOptionBuilder obuilder = new DefaultOptionBuilder();
            ArgumentBuilder abuilder = new ArgumentBuilder();
            GroupBuilder gbuilder = new GroupBuilder();
            DefaultOption seqOpt = obuilder.withLongName("seqFile").withRequired(false).withArgument(abuilder.withName("seqFile").withMinimum(1).withMaximum(1).create()).withDescription("The Sequence File containing the Vectors").withShortName("s").create();
            DefaultOption vectorAsKeyOpt = obuilder.withLongName("useKey").withRequired(false).withDescription("If the Key is a vector, then dump that instead").withShortName("u").create();
            DefaultOption printKeyOpt = obuilder.withLongName("printKey").withRequired(false).withDescription("Print out the key as well, delimited by a tab (or the value if useKey is true)").withShortName("p").create();
            DefaultOption outputOpt = obuilder.withLongName("output").withRequired(false).withArgument(abuilder.withName("output").withMinimum(1).withMaximum(1).create()).withDescription("The output file.  If not specified, dumps to the console").withShortName("o").create();
            DefaultOption dictOpt = obuilder.withLongName("dictionary").withRequired(false).withArgument(abuilder.withName("dictionary").withMinimum(1).withMaximum(1).create()).withDescription("The dictionary file. ").withShortName("d").create();
            DefaultOption dictTypeOpt = obuilder.withLongName("dictionaryType").withRequired(false).withArgument(abuilder.withName("dictionaryType").withMinimum(1).withMaximum(1).create()).withDescription("The dictionary file type (text|sequencefile)").withShortName("dt").create();
            DefaultOption csvOpt = obuilder.withLongName("csv").withRequired(false).withDescription("Output the Vector as CSV.  Otherwise it substitutes in the terms for vector cell entries").withShortName("c").create();
            DefaultOption namesAsCommentsOpt = obuilder.withLongName("namesAsComments").withRequired(false).withDescription("If using CSV output, optionally add a comment line for each NamedVector (if the vector is one) printing out the name").withShortName("n").create();
            DefaultOption sizeOpt = obuilder.withLongName("sizeOnly").withRequired(false).withDescription("Dump only the size of the vector").withShortName("sz").create();
            DefaultOption helpOpt = obuilder.withLongName("help").withDescription("Print out help").withShortName("h").create();
            Group group = gbuilder.withName("Options").withOption((Option)seqOpt).withOption((Option)outputOpt).withOption((Option)dictTypeOpt).withOption((Option)dictOpt).withOption((Option)csvOpt).withOption((Option)vectorAsKeyOpt).withOption((Option)printKeyOpt).withOption((Option)sizeOpt).create();
            try {
                Parser parser = new Parser();
                parser.setGroup(group);
                CommandLine cmdLine = parser.parse(args);
                if (cmdLine.hasOption((Option)helpOpt)) {
                    VectorDumper.printHelp(group);
                    return;
                }
                if (!cmdLine.hasOption((Option)seqOpt)) break block19;
                Path path = new Path(cmdLine.getValue((Option)seqOpt).toString());
                Configuration conf = new Configuration();
                String dictionaryType = "text";
                if (cmdLine.hasOption((Option)dictTypeOpt)) {
                    dictionaryType = cmdLine.getValue((Option)dictTypeOpt).toString();
                }
                String[] dictionary = null;
                if (cmdLine.hasOption((Option)dictOpt)) {
                    if ("text".equals(dictionaryType)) {
                        dictionary = VectorHelper.loadTermDictionary(new File(cmdLine.getValue((Option)dictOpt).toString()));
                    } else if ("sequencefile".equals(dictionaryType)) {
                        dictionary = VectorHelper.loadTermDictionary(conf, cmdLine.getValue((Option)dictOpt).toString());
                    } else {
                        throw new OptionException((Option)dictTypeOpt);
                    }
                }
                boolean useCSV = cmdLine.hasOption((Option)csvOpt);
                boolean sizeOnly = cmdLine.hasOption((Option)sizeOpt);
                boolean namesAsComments = cmdLine.hasOption((Option)namesAsCommentsOpt);
                boolean transposeKeyValue = cmdLine.hasOption((Option)vectorAsKeyOpt);
                Writer writer = cmdLine.hasOption((Option)outputOpt) ? Files.newWriter((File)new File(cmdLine.getValue((Option)outputOpt).toString()), (Charset)Charsets.UTF_8) : new OutputStreamWriter(System.out);
                try {
                    boolean printKey = cmdLine.hasOption((Option)printKeyOpt);
                    if (useCSV && dictionary != null) {
                        writer.write("#");
                        for (int j = 0; j < dictionary.length; ++j) {
                            writer.write(dictionary[j]);
                            if (j >= dictionary.length - 1) continue;
                            writer.write(44);
                        }
                        writer.write(10);
                    }
                    long i = 0L;
                    for (Pair record : new SequenceFileIterable(path, true, conf)) {
                        Writable keyWritable = (Writable)record.getFirst();
                        Writable valueWritable = (Writable)record.getSecond();
                        if (printKey) {
                            Writable notTheVectorWritable = transposeKeyValue ? valueWritable : keyWritable;
                            writer.write(notTheVectorWritable.toString());
                            writer.write(9);
                        }
                        VectorWritable vectorWritable = (VectorWritable)(transposeKeyValue ? keyWritable : valueWritable);
                        Vector vector = vectorWritable.get();
                        if (sizeOnly) {
                            if (vector instanceof NamedVector) {
                                writer.write(((NamedVector)vector).getName());
                                writer.write(":");
                            } else {
                                writer.write(String.valueOf(i++));
                                writer.write(":");
                            }
                            writer.write(String.valueOf(vector.size()));
                            writer.write(10);
                            continue;
                        }
                        String fmtStr = useCSV ? VectorHelper.vectorToCSVString(vector, namesAsComments) : vector.asFormatString();
                        writer.write(fmtStr);
                        writer.write(10);
                    }
                }
                finally {
                    writer.close();
                }
            }
            catch (OptionException e) {
                log.error("Exception", (Throwable)e);
                VectorDumper.printHelp(group);
            }
        }
    }

    private static void printHelp(Group group) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.setGroup(group);
        formatter.print();
    }
}

