/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.utils.vectors;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.regex.Pattern;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Text;
import org.apache.mahout.common.Pair;
import org.apache.mahout.common.iterator.FileLineIterator;
import org.apache.mahout.common.iterator.sequencefile.PathType;
import org.apache.mahout.common.iterator.sequencefile.SequenceFileDirIterable;
import org.apache.mahout.math.NamedVector;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.map.OpenObjectIntHashMap;

public final class VectorHelper {
    private static final Pattern TAB_PATTERN = Pattern.compile("\t");

    private VectorHelper() {
    }

    public static String vectorToCSVString(Vector vector, boolean namesAsComments) throws IOException {
        StringBuilder bldr = new StringBuilder(2048);
        VectorHelper.vectorToCSVString(vector, namesAsComments, bldr);
        return ((Object)bldr).toString();
    }

    public static void vectorToCSVString(Vector vector, boolean namesAsComments, Appendable bldr) throws IOException {
        if (namesAsComments && vector instanceof NamedVector) {
            bldr.append('#').append(((NamedVector)vector).getName()).append('\n');
        }
        Iterator iter = vector.iterator();
        boolean first = true;
        while (iter.hasNext()) {
            if (first) {
                first = false;
            } else {
                bldr.append(',');
            }
            Vector.Element elt = (Vector.Element)iter.next();
            bldr.append(String.valueOf(elt.get()));
        }
        bldr.append('\n');
    }

    public static String[] loadTermDictionary(File dictFile) throws IOException {
        return VectorHelper.loadTermDictionary(new FileInputStream(dictFile));
    }

    public static String[] loadTermDictionary(Configuration conf, String filePattern) {
        OpenObjectIntHashMap dict = new OpenObjectIntHashMap();
        for (Pair record : new SequenceFileDirIterable(new Path(filePattern), PathType.GLOB, null, null, true, conf)) {
            dict.put((Object)((Text)record.getFirst()).toString(), ((IntWritable)record.getSecond()).get());
        }
        String[] dictionary = new String[dict.size()];
        Iterator i$ = dict.keys().iterator();
        while (i$.hasNext()) {
            String feature;
            dictionary[dict.get((Object)feature)] = feature = (String)i$.next();
        }
        return dictionary;
    }

    private static String[] loadTermDictionary(InputStream is) throws IOException {
        FileLineIterator it = new FileLineIterator(is);
        int numEntries = Integer.parseInt((String)it.next());
        String[] result = new String[numEntries];
        while (it.hasNext()) {
            String[] tokens;
            String line = (String)it.next();
            if (line.startsWith("#") || (tokens = TAB_PATTERN.split(line)).length < 3) continue;
            int index = Integer.parseInt(tokens[2]);
            result[index] = tokens[0];
        }
        return result;
    }
}

