/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PatternSet
implements Serializable,
Cloneable {
    private List<String> includes;
    private List<String> excludes;

    public void addExclude(String string) {
        this.getExcludes().add(string);
    }

    public void addInclude(String string) {
        this.getIncludes().add(string);
    }

    public PatternSet clone() {
        try {
            PatternSet copy = (PatternSet)super.clone();
            if (this.includes != null) {
                copy.includes = new ArrayList<String>();
                copy.includes.addAll(this.includes);
            }
            if (this.excludes != null) {
                copy.excludes = new ArrayList<String>();
                copy.excludes.addAll(this.excludes);
            }
            return copy;
        }
        catch (Exception ex) {
            throw (RuntimeException)new UnsupportedOperationException(this.getClass().getName() + " does not support clone()").initCause(ex);
        }
    }

    public List<String> getExcludes() {
        if (this.excludes == null) {
            this.excludes = new ArrayList<String>();
        }
        return this.excludes;
    }

    public List<String> getIncludes() {
        if (this.includes == null) {
            this.includes = new ArrayList<String>();
        }
        return this.includes;
    }

    public void removeExclude(String string) {
        this.getExcludes().remove(string);
    }

    public void removeInclude(String string) {
        this.getIncludes().remove(string);
    }

    public void setExcludes(List<String> excludes) {
        this.excludes = excludes;
    }

    public void setIncludes(List<String> includes) {
        this.includes = includes;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(128);
        sb.append("PatternSet [includes: {");
        for (String str : this.getIncludes()) {
            sb.append(str).append(", ");
        }
        if (sb.substring(sb.length() - 2).equals(", ")) {
            sb.delete(sb.length() - 2, sb.length());
        }
        sb.append("}, excludes: {");
        for (String str : this.getExcludes()) {
            sb.append(str).append(", ");
        }
        if (sb.substring(sb.length() - 2).equals(", ")) {
            sb.delete(sb.length() - 2, sb.length());
        }
        sb.append("}]");
        return sb.toString();
    }
}

