/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.tools.test;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.codehaus.plexus.util.ReflectionUtils;
import org.codehaus.plexus.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReflectiveSetter {
    private Map<String, Setter> cachedPropertySetters = new HashMap<String, Setter>();
    private final Class<?> targetClass;

    public ReflectiveSetter(Class<?> targetClass) {
        this.targetClass = targetClass;
    }

    public void setProperty(String propertyName, Object value, Object target) throws Throwable {
        String preferredMethodName = "set" + StringUtils.capitalizeFirstLetter((String)propertyName);
        Setter setter = null;
        Method method = ReflectionUtils.getSetter((String)preferredMethodName, this.targetClass);
        if (method != null) {
            setter = new MethodSetter(propertyName, method);
        } else {
            Field field = ReflectionUtils.getFieldByNameIncludingSuperclasses((String)propertyName, this.targetClass);
            setter = new FieldSetter(propertyName, field);
        }
        this.cachedPropertySetters.put(setter.getProperty(), setter);
        try {
            setter.set(value, target);
        }
        catch (InvocationTargetException e) {
            throw e.getTargetException();
        }
    }

    private static class FieldSetter
    implements Setter {
        private Field field;
        private String name;

        FieldSetter(String name, Field field) {
            this.name = name;
            this.field = field;
        }

        public String getProperty() {
            return this.name;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void set(Object value, Object target) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
            boolean wasAccessible = this.field.isAccessible();
            this.field.setAccessible(true);
            try {
                this.field.set(target, value);
            }
            finally {
                this.field.setAccessible(wasAccessible);
            }
        }
    }

    private static class MethodSetter
    implements Setter {
        private Method method;
        private String name;

        MethodSetter(String name, Method method) {
            this.name = name;
            this.method = method;
        }

        public String getProperty() {
            return this.name;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void set(Object value, Object target) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
            boolean wasAccessible = this.method.isAccessible();
            this.method.setAccessible(true);
            try {
                this.method.invoke(target, value);
            }
            finally {
                this.method.setAccessible(wasAccessible);
            }
        }
    }

    private static interface Setter {
        public void set(Object var1, Object var2) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException;

        public String getProperty();
    }
}

