/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.dependency.fromConfiguration;

import java.io.File;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.dependency.fromConfiguration.AbstractFromConfigurationMojo;
import org.apache.maven.plugin.dependency.fromConfiguration.ArtifactItem;
import org.apache.maven.plugin.dependency.utils.filters.ArtifactItemFilter;
import org.apache.maven.plugin.dependency.utils.filters.DestFileFilter;

public class CopyMojo
extends AbstractFromConfigurationMojo {
    private boolean stripVersion = false;

    public void execute() throws MojoExecutionException {
        if (this.isSkip()) {
            return;
        }
        List<ArtifactItem> theArtifactItems = this.getProcessedArtifactItems(this.stripVersion);
        for (ArtifactItem artifactItem : theArtifactItems) {
            if (artifactItem.isNeedsProcessing()) {
                this.copyArtifact(artifactItem);
                continue;
            }
            this.getLog().info((CharSequence)(artifactItem + " already exists in " + artifactItem.getOutputDirectory()));
        }
    }

    protected void copyArtifact(ArtifactItem artifactItem) throws MojoExecutionException {
        File destFile = new File(artifactItem.getOutputDirectory(), artifactItem.getDestFileName());
        this.copyFile(artifactItem.getArtifact().getFile(), destFile);
    }

    protected ArtifactItemFilter getMarkedArtifactFilter(ArtifactItem item) {
        DestFileFilter destinationNameOverrideFilter = new DestFileFilter(this.isOverWriteReleases(), this.isOverWriteSnapshots(), this.isOverWriteIfNewer(), false, false, false, false, this.stripVersion, item.getOutputDirectory());
        return destinationNameOverrideFilter;
    }

    public boolean isStripVersion() {
        return this.stripVersion;
    }

    public void setStripVersion(boolean stripVersion) {
        this.stripVersion = stripVersion;
    }
}

