/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.dependency.fromConfiguration;

import java.io.File;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.dependency.fromConfiguration.AbstractFromConfigurationMojo;
import org.apache.maven.plugin.dependency.fromConfiguration.ArtifactItem;
import org.apache.maven.plugin.dependency.fromConfiguration.ProcessArtifactItemsRequest;
import org.apache.maven.plugin.dependency.utils.filters.ArtifactItemFilter;
import org.apache.maven.plugin.dependency.utils.filters.DestFileFilter;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="copy", defaultPhase=LifecyclePhase.PROCESS_SOURCES, requiresProject=false, threadSafe=true)
public class CopyMojo
extends AbstractFromConfigurationMojo {
    @Parameter(property="mdep.stripVersion", defaultValue="false")
    private boolean stripVersion = false;
    @Parameter(property="mdep.prependGroupId", defaultValue="false")
    private boolean prependGroupId = false;
    @Parameter(property="mdep.useBaseVersion", defaultValue="false")
    private boolean useBaseVersion = false;
    @Parameter(property="artifact")
    private String artifact;

    protected void doExecute() throws MojoExecutionException, MojoFailureException {
        this.verifyRequirements();
        List<ArtifactItem> theArtifactItems = this.getProcessedArtifactItems(new ProcessArtifactItemsRequest(this.stripVersion, this.prependGroupId, this.useBaseVersion));
        for (ArtifactItem artifactItem : theArtifactItems) {
            if (artifactItem.isNeedsProcessing()) {
                this.copyArtifact(artifactItem);
                continue;
            }
            this.getLog().info((CharSequence)(artifactItem + " already exists in " + artifactItem.getOutputDirectory()));
        }
    }

    protected void copyArtifact(ArtifactItem artifactItem) throws MojoExecutionException {
        File destFile = new File(artifactItem.getOutputDirectory(), artifactItem.getDestFileName());
        this.copyFile(artifactItem.getArtifact().getFile(), destFile);
    }

    protected ArtifactItemFilter getMarkedArtifactFilter(ArtifactItem item) {
        DestFileFilter destinationNameOverrideFilter = new DestFileFilter(this.isOverWriteReleases(), this.isOverWriteSnapshots(), this.isOverWriteIfNewer(), false, false, false, false, this.stripVersion, item.getOutputDirectory());
        return destinationNameOverrideFilter;
    }

    public boolean isStripVersion() {
        return this.stripVersion;
    }

    public void setStripVersion(boolean stripVersion) {
        this.stripVersion = stripVersion;
    }

    public void setUseBaseVersion(boolean useBaseVersion) {
        this.useBaseVersion = useBaseVersion;
    }
}

