/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.source;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.maven.api.Artifact;
import org.apache.maven.api.Project;
import org.apache.maven.api.Session;
import org.apache.maven.api.di.Inject;
import org.apache.maven.api.model.Resource;
import org.apache.maven.api.plugin.Log;
import org.apache.maven.api.plugin.Mojo;
import org.apache.maven.api.plugin.MojoException;
import org.apache.maven.api.plugin.annotations.Parameter;
import org.apache.maven.api.services.ArtifactManager;
import org.apache.maven.api.services.ProjectManager;
import org.apache.maven.archiver.MavenArchiveConfiguration;
import org.apache.maven.archiver.MavenArchiver;
import org.codehaus.plexus.archiver.Archiver;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.FileSet;
import org.codehaus.plexus.archiver.jar.JarArchiver;
import org.codehaus.plexus.archiver.util.DefaultFileSet;
import org.codehaus.plexus.util.FileUtils;

public abstract class AbstractSourceJarMojo
implements Mojo {
    private static final String[] DEFAULT_INCLUDES = new String[]{"**/**"};
    private static final String[] DEFAULT_EXCLUDES = new String[0];
    @Parameter
    protected String[] includes;
    @Parameter
    protected String[] excludes;
    @Parameter(property="maven.source.useDefaultExcludes", defaultValue="true")
    protected boolean useDefaultExcludes;
    @Inject
    protected Project project;
    @Inject
    protected JarArchiver jarArchiver;
    @Parameter
    protected MavenArchiveConfiguration archive = new MavenArchiveConfiguration();
    @Parameter(defaultValue="${project.build.outputDirectory}/META-INF/MANIFEST.MF", readonly=false, required=true)
    protected Path defaultManifestFile;
    @Parameter(property="maven.source.useDefaultManifestFile", defaultValue="false")
    protected boolean useDefaultManifestFile;
    @Parameter(property="maven.source.attach", defaultValue="true")
    protected boolean attach;
    @Parameter(property="maven.source.excludeResources", defaultValue="false")
    protected boolean excludeResources;
    @Parameter(property="maven.source.includePom", defaultValue="false")
    protected boolean includePom;
    @Parameter(defaultValue="${project.build.directory}")
    protected Path outputDirectory;
    @Parameter(defaultValue="${project.build.finalName}")
    protected String finalName;
    @Parameter(defaultValue="${session.projects}", readonly=true)
    protected List<Project> reactorProjects;
    @Parameter(property="maven.source.forceCreation", defaultValue="false")
    protected boolean forceCreation;
    @Parameter(property="maven.source.skip", defaultValue="false")
    protected boolean skipSource;
    @Inject
    protected Session session;
    @Parameter(defaultValue="${project.build.outputTimestamp}")
    protected String outputTimestamp;
    @Inject
    protected Log log;
    protected ProjectManager projectManager;

    public Log getLog() {
        return this.log;
    }

    public void execute() throws MojoException {
        if (this.skipSource) {
            this.getLog().info((CharSequence)"Skipping source per configuration.");
            return;
        }
        this.projectManager = (ProjectManager)this.session.getService(ProjectManager.class);
        this.doExecute();
    }

    protected void doExecute() {
        this.packageSources(this.project);
    }

    protected abstract String getClassifier();

    protected abstract List<Path> getSources(Project var1) throws MojoException;

    protected abstract List<Resource> getResources(Project var1) throws MojoException;

    protected void packageSources(Project p) throws MojoException {
        String type = p.getPackaging().type().id();
        if (!"pom".equals(type) && !"bom".equals(type)) {
            this.packageSources(Collections.singletonList(p));
        }
    }

    protected void packageSources(List<Project> theProjects) throws MojoException {
        Artifact currentProjectArtifact = (Artifact)this.project.getMainArtifact().get();
        if (!currentProjectArtifact.getClassifier().isEmpty()) {
            this.getLog().warn((CharSequence)("NOT adding sources to artifacts with classifier as Maven only supports one classifier per artifact. Current artifact [" + currentProjectArtifact.key() + "] has a [" + currentProjectArtifact.getClassifier() + "] classifier."));
            return;
        }
        MavenArchiver archiver = this.createArchiver();
        for (Project pItem : theProjects) {
            Project subProject = this.getProject(pItem);
            String type = subProject.getPackaging().type().id();
            if ("pom".equals(type) || "bom".equals(type)) continue;
            this.archiveProjectContent(subProject, (Archiver)archiver.getArchiver());
        }
        if (archiver.getArchiver().getResources().hasNext() || this.forceCreation) {
            if (this.useDefaultManifestFile && Files.exists(this.defaultManifestFile, new LinkOption[0]) && this.archive.getManifestFile() == null) {
                this.getLog().info((CharSequence)("Adding existing MANIFEST to archive. Found under: " + String.valueOf(this.defaultManifestFile)));
                this.archive.setManifestFile(this.defaultManifestFile);
            }
            Path outputFile = this.outputDirectory.resolve(this.finalName + "-" + this.getClassifier() + this.getExtension());
            try {
                archiver.setOutputFile(outputFile.toFile());
                this.archive.setForced(this.forceCreation);
                this.getLog().debug((CharSequence)("create archive " + String.valueOf(outputFile)));
                archiver.createArchive(this.session, this.project, this.archive);
            }
            catch (ArchiverException e) {
                throw new MojoException("Error creating source archive: " + e.getMessage(), (Throwable)e);
            }
            if (this.attach) {
                Artifact artifact = this.session.createArtifact(this.project.getGroupId(), this.project.getArtifactId(), this.project.getVersion(), this.getClassifier(), null, this.getType());
                boolean requiresAttach = true;
                for (Artifact attachedArtifact : this.projectManager.getAttachedArtifacts(this.project)) {
                    if (!Objects.equals(artifact.key(), attachedArtifact.key())) continue;
                    Path attachedFile = ((ArtifactManager)this.session.getService(ArtifactManager.class)).getPath(attachedArtifact).orElse(null);
                    if (attachedFile != null && !outputFile.equals(attachedFile)) {
                        this.getLog().error((CharSequence)("Artifact " + attachedArtifact.key() + " already attached to a file " + this.relative(attachedFile) + ": attach to " + this.relative(outputFile) + " should be done with another classifier"));
                        throw new MojoException("Presumably you have configured maven-source-plugin to execute twice in your build to different output files. You have to configure a classifier for at least one of them.");
                    }
                    requiresAttach = false;
                    this.getLog().info((CharSequence)("Artifact " + attachedArtifact.key() + " already attached to " + this.relative(outputFile) + ": ignoring same re-attach (same artifact, same file)"));
                }
                if (requiresAttach) {
                    this.projectManager.attachArtifact(this.project, artifact, outputFile);
                }
            } else {
                this.getLog().info((CharSequence)"NOT adding java-sources to attached artifacts list.");
            }
        } else {
            this.getLog().info((CharSequence)"No sources in project. Archive not created.");
        }
    }

    private String relative(Path to) {
        Path basedir = this.project.getBasedir().toAbsolutePath();
        return basedir.relativize(to.toAbsolutePath()).toString();
    }

    private Artifact getPreviouslyAttached(Artifact artifact, Project checkProject, String classifier) {
        return artifact.getExtension().equals(this.getExtension()) && artifact.getGroupId().equals(checkProject.getGroupId()) && artifact.getArtifactId().equals(checkProject.getArtifactId()) && artifact.getVersion().toString().equals(checkProject.getVersion()) && Objects.equals(artifact.getClassifier(), classifier) ? artifact : null;
    }

    protected void archiveProjectContent(Project project, Archiver archiver) throws MojoException {
        if (this.includePom) {
            try {
                File pom = project.getPomPath().toFile();
                archiver.addFile(pom, pom.getName());
            }
            catch (ArchiverException e) {
                throw new MojoException("Error adding POM file to target jar file.", (Throwable)e);
            }
        }
        for (Path sourceDirectory : this.getSources(project)) {
            if (!Files.exists(sourceDirectory, new LinkOption[0])) continue;
            this.addDirectory(archiver, sourceDirectory, this.getCombinedIncludes(null), this.getCombinedExcludes(null));
        }
        for (Resource resource : this.getResources(project)) {
            Path sourceDirectory = Paths.get(resource.getDirectory(), new String[0]);
            if (!Files.exists(sourceDirectory, new LinkOption[0])) continue;
            List resourceIncludes = resource.getIncludes();
            String[] combinedIncludes = this.getCombinedIncludes(resourceIncludes);
            List resourceExcludes = resource.getExcludes();
            String[] combinedExcludes = this.getCombinedExcludes(resourceExcludes);
            Object targetPath = resource.getTargetPath();
            if (targetPath != null) {
                if (!((String)targetPath).trim().endsWith("/")) {
                    targetPath = (String)targetPath + "/";
                }
                this.addDirectory(archiver, sourceDirectory, (String)targetPath, combinedIncludes, combinedExcludes);
                continue;
            }
            this.addDirectory(archiver, sourceDirectory, combinedIncludes, combinedExcludes);
        }
    }

    protected MavenArchiver createArchiver() throws MojoException {
        MavenArchiver archiver = new MavenArchiver();
        archiver.setArchiver(this.jarArchiver);
        archiver.setCreatedBy("Maven Source Plugin", "org.apache.maven.plugins", "maven-source-plugin");
        archiver.setBuildJdkSpecDefaultEntry(false);
        archiver.configureReproducibleBuild(this.outputTimestamp);
        if (this.project.getBuild() != null) {
            List resources = this.project.getBuild().getResources();
            for (Resource r : resources) {
                if (!r.getDirectory().endsWith("maven-shared-archive-resources")) continue;
                this.addDirectory((Archiver)archiver.getArchiver(), Paths.get(r.getDirectory(), new String[0]), this.getCombinedIncludes(null), this.getCombinedExcludes(null));
            }
        }
        return archiver;
    }

    protected void addDirectory(Archiver archiver, Path sourceDirectory, String[] pIncludes, String[] pExcludes) throws MojoException {
        try {
            this.getLog().debug((CharSequence)("add directory " + String.valueOf(sourceDirectory) + " to archiver"));
            archiver.addFileSet((FileSet)DefaultFileSet.fileSet((File)sourceDirectory.toFile()).includeExclude(pIncludes, pExcludes));
        }
        catch (ArchiverException e) {
            throw new MojoException("Error adding directory to source archive.", (Throwable)e);
        }
    }

    protected void addDirectory(Archiver archiver, Path sourceDirectory, String prefix, String[] pIncludes, String[] pExcludes) throws MojoException {
        try {
            this.getLog().debug((CharSequence)("add directory " + String.valueOf(sourceDirectory) + " to archiver with prefix " + prefix));
            archiver.addFileSet((FileSet)((DefaultFileSet)DefaultFileSet.fileSet((File)sourceDirectory.toFile()).prefixed(prefix)).includeExclude(pIncludes, pExcludes));
        }
        catch (ArchiverException e) {
            throw new MojoException("Error adding directory to source archive.", (Throwable)e);
        }
    }

    protected String getExtension() {
        return ".jar";
    }

    protected Project getProject(Project p) {
        return this.projectManager.getExecutionProject(p).orElse(p);
    }

    protected String getType() {
        return "java-source";
    }

    private String[] getCombinedIncludes(List<String> additionalIncludes) {
        ArrayList<String> combinedIncludes = new ArrayList<String>();
        if (this.includes != null && this.includes.length > 0) {
            combinedIncludes.addAll(Arrays.asList(this.includes));
        }
        if (additionalIncludes != null && !additionalIncludes.isEmpty()) {
            combinedIncludes.addAll(additionalIncludes);
        }
        if (combinedIncludes.isEmpty()) {
            combinedIncludes.addAll(Arrays.asList(DEFAULT_INCLUDES));
        }
        return combinedIncludes.toArray(new String[0]);
    }

    private String[] getCombinedExcludes(List<String> additionalExcludes) {
        ArrayList<String> combinedExcludes = new ArrayList<String>();
        if (this.useDefaultExcludes) {
            combinedExcludes.addAll(FileUtils.getDefaultExcludesAsList());
        }
        if (this.excludes != null && this.excludes.length > 0) {
            combinedExcludes.addAll(Arrays.asList(this.excludes));
        }
        if (additionalExcludes != null && !additionalExcludes.isEmpty()) {
            combinedExcludes.addAll(additionalExcludes);
        }
        if (combinedExcludes.isEmpty()) {
            combinedExcludes.addAll(Arrays.asList(DEFAULT_EXCLUDES));
        }
        return combinedExcludes.toArray(new String[0]);
    }

    protected Project getProject() {
        return this.project;
    }

    protected void setProject(Project project) {
        this.project = project;
    }
}

