/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.release;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;

public class ReleaseResult {
    public static final int UNDEFINED = -1;
    public static final int SUCCESS = 0;
    public static final int ERROR = 1;
    private StringBuffer stdOut = new StringBuffer();
    private int resultCode = -1;
    private long startTime;
    private long endTime;
    private static final String LS = System.getProperty("line.separator");

    public void appendInfo(String message) {
        this.stdOut.append("[INFO] ").append(message).append(LS);
    }

    public void appendWarn(String message) {
        this.stdOut.append("[WARN] ").append(message).append(LS);
    }

    public void appendDebug(String message) {
        this.stdOut.append("[DEBUG] ").append(message).append(LS);
    }

    public void appendDebug(String message, Exception e) {
        this.appendDebug(message);
        this.stdOut.append(this.getStackTrace(e)).append(LS);
    }

    public void appendError(String message) {
        this.stdOut.append("[ERROR] ").append(message).append(LS);
        this.setResultCode(1);
    }

    public void appendError(Exception e) {
        this.appendError(this.getStackTrace(e));
    }

    public void appendError(String message, Exception e) {
        this.appendError(message);
        this.stdOut.append(this.getStackTrace(e)).append(LS);
    }

    public void appendOutput(String message) {
        this.stdOut.append(message);
    }

    public String getOutput() {
        return this.stdOut.toString();
    }

    public int getResultCode() {
        return this.resultCode;
    }

    public void setResultCode(int resultCode) {
        this.resultCode = resultCode;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public void setEndTime(long endTime) {
        this.endTime = endTime;
    }

    private String getStackTrace(Exception e) {
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        PrintStream stream = new PrintStream(byteStream);
        e.printStackTrace(stream);
        stream.flush();
        return byteStream.toString();
    }

    public StringBuffer getOutputBuffer() {
        return this.stdOut;
    }
}

