/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.release.phase;

import java.io.File;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.project.MavenProject;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmResult;
import org.apache.maven.scm.ScmTagParameters;
import org.apache.maven.scm.command.tag.TagScmResult;
import org.apache.maven.scm.manager.NoSuchScmProviderException;
import org.apache.maven.scm.provider.ScmProvider;
import org.apache.maven.scm.repository.ScmRepository;
import org.apache.maven.scm.repository.ScmRepositoryException;
import org.apache.maven.shared.release.ReleaseExecutionException;
import org.apache.maven.shared.release.ReleaseFailureException;
import org.apache.maven.shared.release.ReleaseResult;
import org.apache.maven.shared.release.config.ReleaseDescriptor;
import org.apache.maven.shared.release.env.ReleaseEnvironment;
import org.apache.maven.shared.release.phase.AbstractReleasePhase;
import org.apache.maven.shared.release.scm.ReleaseScmCommandException;
import org.apache.maven.shared.release.scm.ReleaseScmRepositoryException;
import org.apache.maven.shared.release.scm.ScmRepositoryConfigurator;
import org.apache.maven.shared.release.util.ReleaseUtil;

@Singleton
@Named(value="scm-tag")
public class ScmTagPhase
extends AbstractReleasePhase {
    private final ScmRepositoryConfigurator scmRepositoryConfigurator;

    @Inject
    public ScmTagPhase(ScmRepositoryConfigurator scmRepositoryConfigurator) {
        this.scmRepositoryConfigurator = scmRepositoryConfigurator;
    }

    public ReleaseResult execute(ReleaseDescriptor releaseDescriptor, ReleaseEnvironment releaseEnvironment, List<MavenProject> reactorProjects) throws ReleaseExecutionException, ReleaseFailureException {
        TagScmResult result;
        ScmProvider provider;
        ScmRepository repository;
        ReleaseResult relResult = new ReleaseResult();
        ScmTagPhase.validateConfiguration(releaseDescriptor);
        if (releaseDescriptor.getWaitBeforeTagging() > 0) {
            this.logInfo(relResult, "Waiting for " + releaseDescriptor.getWaitBeforeTagging() + " seconds before tagging the release.");
            try {
                Thread.sleep(1000L * (long)releaseDescriptor.getWaitBeforeTagging());
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.logInfo(relResult, "Tagging release with the label " + releaseDescriptor.getScmReleaseLabel() + "...");
        ReleaseDescriptor basedirAlignedReleaseDescriptor = ReleaseUtil.createBasedirAlignedReleaseDescriptor(releaseDescriptor, reactorProjects);
        try {
            repository = this.scmRepositoryConfigurator.getConfiguredRepository(basedirAlignedReleaseDescriptor.getScmSourceUrl(), releaseDescriptor, releaseEnvironment.getSettings());
            repository.getProviderRepository().setPushChanges(releaseDescriptor.isPushChanges());
            repository.getProviderRepository().setWorkItem(releaseDescriptor.getWorkItem());
            provider = this.scmRepositoryConfigurator.getRepositoryProvider(repository);
        }
        catch (ScmRepositoryException e) {
            throw new ReleaseScmRepositoryException(e.getMessage(), e.getValidationMessages());
        }
        catch (NoSuchScmProviderException e) {
            throw new ReleaseExecutionException("Unable to configure SCM repository: " + e.getMessage(), (Throwable)e);
        }
        try {
            ScmFileSet fileSet = new ScmFileSet(new File(basedirAlignedReleaseDescriptor.getWorkingDirectory()));
            String tagName = releaseDescriptor.getScmReleaseLabel();
            ScmTagParameters scmTagParameters = new ScmTagParameters(releaseDescriptor.getScmCommentPrefix() + "copy for tag " + tagName);
            scmTagParameters.setRemoteTagging(releaseDescriptor.isRemoteTagging());
            scmTagParameters.setSign(releaseDescriptor.isScmSignTags());
            scmTagParameters.setScmRevision(releaseDescriptor.getScmReleasedPomRevision());
            scmTagParameters.setPinExternals(releaseDescriptor.isPinExternals());
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("ScmTagPhase :: scmTagParameters remotingTag " + releaseDescriptor.isRemoteTagging());
                this.getLogger().debug("ScmTagPhase :: scmTagParameters scmRevision " + releaseDescriptor.getScmReleasedPomRevision());
                this.getLogger().debug("ScmTagPhase :: scmTagParameters pinExternals " + releaseDescriptor.isPinExternals());
                this.getLogger().debug("ScmTagPhase :: fileSet  " + fileSet);
            }
            result = provider.tag(repository, fileSet, tagName, scmTagParameters);
        }
        catch (ScmException e) {
            throw new ReleaseExecutionException("An error is occurred in the tag process: " + e.getMessage(), (Throwable)e);
        }
        if (!result.isSuccess()) {
            throw new ReleaseScmCommandException("Unable to tag SCM", (ScmResult)result);
        }
        relResult.setResultCode(0);
        return relResult;
    }

    public ReleaseResult simulate(ReleaseDescriptor releaseDescriptor, ReleaseEnvironment releaseEnvironment, List<MavenProject> reactorProjects) throws ReleaseExecutionException, ReleaseFailureException {
        ReleaseResult result = new ReleaseResult();
        ScmTagPhase.validateConfiguration(releaseDescriptor);
        ReleaseDescriptor basedirAlignedReleaseDescriptor = ReleaseUtil.createBasedirAlignedReleaseDescriptor(releaseDescriptor, reactorProjects);
        if (releaseDescriptor.isRemoteTagging()) {
            this.logInfo(result, "Full run would tag working copy '" + basedirAlignedReleaseDescriptor.getWorkingDirectory() + "'");
        } else {
            this.logInfo(result, "Full run would tag remotely '" + basedirAlignedReleaseDescriptor.getScmSourceUrl() + "'");
        }
        this.logInfo(result, "  with label '" + releaseDescriptor.getScmReleaseLabel() + "'");
        if (releaseDescriptor.isPinExternals()) {
            this.logInfo(result, "  and pinned externals");
        }
        result.setResultCode(0);
        return result;
    }

    private static void validateConfiguration(ReleaseDescriptor releaseDescriptor) throws ReleaseFailureException {
        if (releaseDescriptor.getScmReleaseLabel() == null) {
            throw new ReleaseFailureException("A release label is required for committing");
        }
    }
}

