/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.testng.conf;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.maven.surefire.testng.conf.AbstractDirectConfigurator;
import org.apache.maven.surefire.testng.conf.Configurator;
import org.apache.maven.surefire.testset.TestSetFailedException;
import org.testng.TestNG;

public class TestNGMapConfigurator
implements Configurator {
    public void configure(TestNG testng, Map options) throws TestSetFailedException {
        Map convertedOptions = this.getConvertedOptions(options);
        testng.configure(convertedOptions);
    }

    Map getConvertedOptions(Map options) throws TestSetFailedException {
        HashMap<String, Boolean> convertedOptions = new HashMap<String, Boolean>();
        convertedOptions.put("-mixed", Boolean.FALSE);
        for (Map.Entry entry : options.entrySet()) {
            String key = (String)entry.getKey();
            Object val = entry.getValue();
            if ("listener".equals(key)) {
                val = AbstractDirectConfigurator.loadListenerClasses((String)val);
            }
            if ("objectfactory".equals(key)) {
                val = AbstractDirectConfigurator.loadClass((String)val);
            }
            if ("reporter".equals(key)) {
                val = this.convertReporterConfig(val);
                key = "reporterslist";
            }
            if ("junit".equals(key)) {
                val = this.convert(val, Boolean.class);
            } else if ("skipfailedinvocationcounts".equals(key)) {
                val = this.convert(val, Boolean.class);
            } else if ("mixed".equals(key)) {
                val = this.convert(val, Boolean.class);
            } else if ("configfailurepolicy".equals(key)) {
                val = this.convert(val, String.class);
            } else if ("group-by-instances".equals(key)) {
                val = this.convert(val, Boolean.class);
            } else if ("threadcount".equals(key)) {
                val = this.convert(val, String.class);
            }
            if (key.startsWith("-")) {
                convertedOptions.put(key, (Boolean)val);
                continue;
            }
            convertedOptions.put("-" + key, (Boolean)val);
        }
        return convertedOptions;
    }

    private Object convertReporterConfig(Object val) {
        String reporterConfigClassName = "org.testng.ReporterConfig";
        try {
            Class<?> reporterConfig = Class.forName("org.testng.ReporterConfig");
            Method deserialize = reporterConfig.getMethod("deserialize", String.class);
            Object rc = deserialize.invoke(null, val);
            ArrayList<Object> reportersList = new ArrayList<Object>();
            reportersList.add(rc);
            return reportersList;
        }
        catch (Exception e) {
            return val;
        }
    }

    protected Object convert(Object val, Class type) {
        if (val == null) {
            return null;
        }
        if (type.isAssignableFrom(val.getClass())) {
            return val;
        }
        if ((Boolean.class.equals((Object)type) || Boolean.TYPE.equals(type)) && String.class.equals(val.getClass())) {
            return Boolean.valueOf((String)val);
        }
        if (String.class.equals((Object)type)) {
            return val.toString();
        }
        return val;
    }
}

