/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fontbox.afm;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.apache.fontbox.afm.CharMetric;
import org.apache.fontbox.afm.Composite;
import org.apache.fontbox.afm.CompositePart;
import org.apache.fontbox.afm.FontMetrics;
import org.apache.fontbox.afm.KernPair;
import org.apache.fontbox.afm.Ligature;
import org.apache.fontbox.afm.TrackKern;
import org.apache.fontbox.util.BoundingBox;
import org.apache.fontbox.util.Charsets;

public class AFMParser {
    public static final String COMMENT = "Comment";
    public static final String START_FONT_METRICS = "StartFontMetrics";
    public static final String END_FONT_METRICS = "EndFontMetrics";
    public static final String FONT_NAME = "FontName";
    public static final String FULL_NAME = "FullName";
    public static final String FAMILY_NAME = "FamilyName";
    public static final String WEIGHT = "Weight";
    public static final String FONT_BBOX = "FontBBox";
    public static final String VERSION = "Version";
    public static final String NOTICE = "Notice";
    public static final String ENCODING_SCHEME = "EncodingScheme";
    public static final String MAPPING_SCHEME = "MappingScheme";
    public static final String ESC_CHAR = "EscChar";
    public static final String CHARACTER_SET = "CharacterSet";
    public static final String CHARACTERS = "Characters";
    public static final String IS_BASE_FONT = "IsBaseFont";
    public static final String V_VECTOR = "VVector";
    public static final String IS_FIXED_V = "IsFixedV";
    public static final String CAP_HEIGHT = "CapHeight";
    public static final String X_HEIGHT = "XHeight";
    public static final String ASCENDER = "Ascender";
    public static final String DESCENDER = "Descender";
    public static final String UNDERLINE_POSITION = "UnderlinePosition";
    public static final String UNDERLINE_THICKNESS = "UnderlineThickness";
    public static final String ITALIC_ANGLE = "ItalicAngle";
    public static final String CHAR_WIDTH = "CharWidth";
    public static final String IS_FIXED_PITCH = "IsFixedPitch";
    public static final String START_CHAR_METRICS = "StartCharMetrics";
    public static final String END_CHAR_METRICS = "EndCharMetrics";
    public static final String CHARMETRICS_C = "C";
    public static final String CHARMETRICS_CH = "CH";
    public static final String CHARMETRICS_WX = "WX";
    public static final String CHARMETRICS_W0X = "W0X";
    public static final String CHARMETRICS_W1X = "W1X";
    public static final String CHARMETRICS_WY = "WY";
    public static final String CHARMETRICS_W0Y = "W0Y";
    public static final String CHARMETRICS_W1Y = "W1Y";
    public static final String CHARMETRICS_W = "W";
    public static final String CHARMETRICS_W0 = "W0";
    public static final String CHARMETRICS_W1 = "W1";
    public static final String CHARMETRICS_VV = "VV";
    public static final String CHARMETRICS_N = "N";
    public static final String CHARMETRICS_B = "B";
    public static final String CHARMETRICS_L = "L";
    public static final String STD_HW = "StdHW";
    public static final String STD_VW = "StdVW";
    public static final String START_TRACK_KERN = "StartTrackKern";
    public static final String END_TRACK_KERN = "EndTrackKern";
    public static final String START_KERN_DATA = "StartKernData";
    public static final String END_KERN_DATA = "EndKernData";
    public static final String START_KERN_PAIRS = "StartKernPairs";
    public static final String END_KERN_PAIRS = "EndKernPairs";
    public static final String START_KERN_PAIRS0 = "StartKernPairs0";
    public static final String START_KERN_PAIRS1 = "StartKernPairs1";
    public static final String START_COMPOSITES = "StartComposites";
    public static final String END_COMPOSITES = "EndComposites";
    public static final String CC = "CC";
    public static final String PCC = "PCC";
    public static final String KERN_PAIR_KP = "KP";
    public static final String KERN_PAIR_KPH = "KPH";
    public static final String KERN_PAIR_KPX = "KPX";
    public static final String KERN_PAIR_KPY = "KPY";
    private static final int BITS_IN_HEX = 16;
    private final InputStream input;

    public AFMParser(InputStream in) {
        this.input = in;
    }

    public FontMetrics parse() throws IOException {
        return this.parseFontMetric(false);
    }

    public FontMetrics parse(boolean reducedDataset) throws IOException {
        return this.parseFontMetric(reducedDataset);
    }

    private FontMetrics parseFontMetric(boolean reducedDataset) throws IOException {
        String nextCommand;
        FontMetrics fontMetrics = new FontMetrics();
        String startFontMetrics = this.readString();
        if (!START_FONT_METRICS.equals(startFontMetrics)) {
            throw new IOException("Error: The AFM file should start with StartFontMetrics and not '" + startFontMetrics + "'");
        }
        fontMetrics.setAFMVersion(this.readFloat());
        boolean charMetricsRead = false;
        block64: while (!END_FONT_METRICS.equals(nextCommand = this.readString())) {
            switch (nextCommand) {
                case "FontName": {
                    fontMetrics.setFontName(this.readLine());
                    break;
                }
                case "FullName": {
                    fontMetrics.setFullName(this.readLine());
                    break;
                }
                case "FamilyName": {
                    fontMetrics.setFamilyName(this.readLine());
                    break;
                }
                case "Weight": {
                    fontMetrics.setWeight(this.readLine());
                    break;
                }
                case "FontBBox": {
                    BoundingBox bBox = new BoundingBox();
                    bBox.setLowerLeftX(this.readFloat());
                    bBox.setLowerLeftY(this.readFloat());
                    bBox.setUpperRightX(this.readFloat());
                    bBox.setUpperRightY(this.readFloat());
                    fontMetrics.setFontBBox(bBox);
                    break;
                }
                case "Version": {
                    fontMetrics.setFontVersion(this.readLine());
                    break;
                }
                case "Notice": {
                    fontMetrics.setNotice(this.readLine());
                    break;
                }
                case "EncodingScheme": {
                    fontMetrics.setEncodingScheme(this.readLine());
                    break;
                }
                case "MappingScheme": {
                    fontMetrics.setMappingScheme(this.readInt());
                    break;
                }
                case "EscChar": {
                    fontMetrics.setEscChar(this.readInt());
                    break;
                }
                case "CharacterSet": {
                    fontMetrics.setCharacterSet(this.readLine());
                    break;
                }
                case "Characters": {
                    fontMetrics.setCharacters(this.readInt());
                    break;
                }
                case "IsBaseFont": {
                    fontMetrics.setIsBaseFont(this.readBoolean());
                    break;
                }
                case "VVector": {
                    float[] vector = new float[]{this.readFloat(), this.readFloat()};
                    fontMetrics.setVVector(vector);
                    break;
                }
                case "IsFixedV": {
                    fontMetrics.setIsFixedV(this.readBoolean());
                    break;
                }
                case "CapHeight": {
                    fontMetrics.setCapHeight(this.readFloat());
                    break;
                }
                case "XHeight": {
                    fontMetrics.setXHeight(this.readFloat());
                    break;
                }
                case "Ascender": {
                    fontMetrics.setAscender(this.readFloat());
                    break;
                }
                case "Descender": {
                    fontMetrics.setDescender(this.readFloat());
                    break;
                }
                case "StdHW": {
                    fontMetrics.setStandardHorizontalWidth(this.readFloat());
                    break;
                }
                case "StdVW": {
                    fontMetrics.setStandardVerticalWidth(this.readFloat());
                    break;
                }
                case "Comment": {
                    fontMetrics.addComment(this.readLine());
                    break;
                }
                case "UnderlinePosition": {
                    fontMetrics.setUnderlinePosition(this.readFloat());
                    break;
                }
                case "UnderlineThickness": {
                    fontMetrics.setUnderlineThickness(this.readFloat());
                    break;
                }
                case "ItalicAngle": {
                    fontMetrics.setItalicAngle(this.readFloat());
                    break;
                }
                case "CharWidth": {
                    float[] widths = new float[]{this.readFloat(), this.readFloat()};
                    fontMetrics.setCharWidth(widths);
                    break;
                }
                case "IsFixedPitch": {
                    fontMetrics.setFixedPitch(this.readBoolean());
                    break;
                }
                case "StartCharMetrics": {
                    int countMetrics = this.readInt();
                    ArrayList<CharMetric> charMetrics = new ArrayList<CharMetric>(countMetrics);
                    for (int i = 0; i < countMetrics; ++i) {
                        CharMetric charMetric = this.parseCharMetric();
                        charMetrics.add(charMetric);
                    }
                    String endCharMetrics = this.readString();
                    if (!endCharMetrics.equals(END_CHAR_METRICS)) {
                        throw new IOException("Error: Expected 'EndCharMetrics' actual '" + endCharMetrics + "'");
                    }
                    charMetricsRead = true;
                    fontMetrics.setCharMetrics(charMetrics);
                    break;
                }
                case "StartComposites": {
                    if (reducedDataset) continue block64;
                    int countComposites = this.readInt();
                    for (int i = 0; i < countComposites; ++i) {
                        Composite part = this.parseComposite();
                        fontMetrics.addComposite(part);
                    }
                    String endComposites = this.readString();
                    if (endComposites.equals(END_COMPOSITES)) continue block64;
                    throw new IOException("Error: Expected 'EndComposites' actual '" + endComposites + "'");
                }
                case "StartKernData": {
                    if (reducedDataset) continue block64;
                    this.parseKernData(fontMetrics);
                    break;
                }
                default: {
                    if (reducedDataset && charMetricsRead) break;
                    throw new IOException("Unknown AFM key '" + nextCommand + "'");
                }
            }
        }
        return fontMetrics;
    }

    private void parseKernData(FontMetrics fontMetrics) throws IOException {
        String nextCommand;
        block12: while (!(nextCommand = this.readString()).equals(END_KERN_DATA)) {
            switch (nextCommand) {
                case "StartTrackKern": {
                    int countTrackKern = this.readInt();
                    for (int i = 0; i < countTrackKern; ++i) {
                        TrackKern kern = new TrackKern();
                        kern.setDegree(this.readInt());
                        kern.setMinPointSize(this.readFloat());
                        kern.setMinKern(this.readFloat());
                        kern.setMaxPointSize(this.readFloat());
                        kern.setMaxKern(this.readFloat());
                        fontMetrics.addTrackKern(kern);
                    }
                    String endTrackKern = this.readString();
                    if (endTrackKern.equals(END_TRACK_KERN)) continue block12;
                    throw new IOException("Error: Expected 'EndTrackKern' actual '" + endTrackKern + "'");
                }
                case "StartKernPairs": {
                    int countKernPairs = this.readInt();
                    for (int i = 0; i < countKernPairs; ++i) {
                        KernPair pair = this.parseKernPair();
                        fontMetrics.addKernPair(pair);
                    }
                    String endKernPairs = this.readString();
                    if (endKernPairs.equals(END_KERN_PAIRS)) continue block12;
                    throw new IOException("Error: Expected 'EndKernPairs' actual '" + endKernPairs + "'");
                }
                case "StartKernPairs0": {
                    int countKernPairs0 = this.readInt();
                    for (int i = 0; i < countKernPairs0; ++i) {
                        KernPair pair = this.parseKernPair();
                        fontMetrics.addKernPair0(pair);
                    }
                    String endKernPairs0 = this.readString();
                    if (endKernPairs0.equals(END_KERN_PAIRS)) continue block12;
                    throw new IOException("Error: Expected 'EndKernPairs' actual '" + endKernPairs0 + "'");
                }
                case "StartKernPairs1": {
                    int countKernPairs1 = this.readInt();
                    for (int i = 0; i < countKernPairs1; ++i) {
                        KernPair pair = this.parseKernPair();
                        fontMetrics.addKernPair1(pair);
                    }
                    String endKernPairs1 = this.readString();
                    if (endKernPairs1.equals(END_KERN_PAIRS)) continue block12;
                    throw new IOException("Error: Expected 'EndKernPairs' actual '" + endKernPairs1 + "'");
                }
            }
            throw new IOException("Unknown kerning data type '" + nextCommand + "'");
        }
    }

    private KernPair parseKernPair() throws IOException {
        String cmd;
        KernPair kernPair = new KernPair();
        switch (cmd = this.readString()) {
            case "KP": {
                kernPair.setFirstKernCharacter(this.readString());
                kernPair.setSecondKernCharacter(this.readString());
                kernPair.setX(this.readFloat());
                kernPair.setY(this.readFloat());
                break;
            }
            case "KPH": {
                kernPair.setFirstKernCharacter(this.hexToString(this.readString()));
                kernPair.setSecondKernCharacter(this.hexToString(this.readString()));
                kernPair.setX(this.readFloat());
                kernPair.setY(this.readFloat());
                break;
            }
            case "KPX": {
                kernPair.setFirstKernCharacter(this.readString());
                kernPair.setSecondKernCharacter(this.readString());
                kernPair.setX(this.readFloat());
                kernPair.setY(0.0f);
                break;
            }
            case "KPY": {
                kernPair.setFirstKernCharacter(this.readString());
                kernPair.setSecondKernCharacter(this.readString());
                kernPair.setX(0.0f);
                kernPair.setY(this.readFloat());
                break;
            }
            default: {
                throw new IOException("Error expected kern pair command actual='" + cmd + "'");
            }
        }
        return kernPair;
    }

    private String hexToString(String hexString) throws IOException {
        if (hexString.length() < 2) {
            throw new IOException("Error: Expected hex string of length >= 2 not='" + hexString);
        }
        if (hexString.charAt(0) != '<' || hexString.charAt(hexString.length() - 1) != '>') {
            throw new IOException("String should be enclosed by angle brackets '" + hexString + "'");
        }
        hexString = hexString.substring(1, hexString.length() - 1);
        byte[] data = new byte[hexString.length() / 2];
        for (int i = 0; i < hexString.length(); i += 2) {
            String hex = Character.toString(hexString.charAt(i)) + hexString.charAt(i + 1);
            try {
                data[i / 2] = (byte)Integer.parseInt(hex, 16);
                continue;
            }
            catch (NumberFormatException e) {
                throw new IOException("Error parsing AFM file:" + e);
            }
        }
        return new String(data, Charsets.ISO_8859_1);
    }

    private Composite parseComposite() throws IOException {
        int partCount;
        Composite composite = new Composite();
        String partData = this.readLine();
        StringTokenizer tokenizer = new StringTokenizer(partData, " ;");
        String cc = tokenizer.nextToken();
        if (!cc.equals(CC)) {
            throw new IOException("Expected 'CC' actual='" + cc + "'");
        }
        String name = tokenizer.nextToken();
        composite.setName(name);
        try {
            partCount = Integer.parseInt(tokenizer.nextToken());
        }
        catch (NumberFormatException e) {
            throw new IOException("Error parsing AFM document:" + e);
        }
        for (int i = 0; i < partCount; ++i) {
            CompositePart part = new CompositePart();
            String pcc = tokenizer.nextToken();
            if (!pcc.equals(PCC)) {
                throw new IOException("Expected 'PCC' actual='" + pcc + "'");
            }
            String partName = tokenizer.nextToken();
            try {
                int x = Integer.parseInt(tokenizer.nextToken());
                int y = Integer.parseInt(tokenizer.nextToken());
                part.setName(partName);
                part.setXDisplacement(x);
                part.setYDisplacement(y);
                composite.addPart(part);
                continue;
            }
            catch (NumberFormatException e) {
                throw new IOException("Error parsing AFM document:" + e);
            }
        }
        return composite;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private CharMetric parseCharMetric() throws IOException {
        CharMetric charMetric = new CharMetric();
        String metrics = this.readLine();
        StringTokenizer metricsTokenizer = new StringTokenizer(metrics);
        try {
            String nextCommand;
            block36: while (metricsTokenizer.hasMoreTokens()) {
                switch (nextCommand = metricsTokenizer.nextToken()) {
                    case "C": {
                        String charCodeC = metricsTokenizer.nextToken();
                        charMetric.setCharacterCode(Integer.parseInt(charCodeC));
                        this.verifySemicolon(metricsTokenizer);
                        continue block36;
                    }
                    case "CH": {
                        String charCodeCH = metricsTokenizer.nextToken();
                        charMetric.setCharacterCode(Integer.parseInt(charCodeCH, 16));
                        this.verifySemicolon(metricsTokenizer);
                        continue block36;
                    }
                    case "WX": {
                        charMetric.setWx(Float.parseFloat(metricsTokenizer.nextToken()));
                        this.verifySemicolon(metricsTokenizer);
                        continue block36;
                    }
                    case "W0X": {
                        charMetric.setW0x(Float.parseFloat(metricsTokenizer.nextToken()));
                        this.verifySemicolon(metricsTokenizer);
                        continue block36;
                    }
                    case "W1X": {
                        charMetric.setW1x(Float.parseFloat(metricsTokenizer.nextToken()));
                        this.verifySemicolon(metricsTokenizer);
                        continue block36;
                    }
                    case "WY": {
                        charMetric.setWy(Float.parseFloat(metricsTokenizer.nextToken()));
                        this.verifySemicolon(metricsTokenizer);
                        continue block36;
                    }
                    case "W0Y": {
                        charMetric.setW0y(Float.parseFloat(metricsTokenizer.nextToken()));
                        this.verifySemicolon(metricsTokenizer);
                        continue block36;
                    }
                    case "W1Y": {
                        charMetric.setW1y(Float.parseFloat(metricsTokenizer.nextToken()));
                        this.verifySemicolon(metricsTokenizer);
                        continue block36;
                    }
                    case "W": {
                        float[] w = new float[]{Float.parseFloat(metricsTokenizer.nextToken()), Float.parseFloat(metricsTokenizer.nextToken())};
                        charMetric.setW(w);
                        this.verifySemicolon(metricsTokenizer);
                        continue block36;
                    }
                    case "W0": {
                        float[] w0 = new float[]{Float.parseFloat(metricsTokenizer.nextToken()), Float.parseFloat(metricsTokenizer.nextToken())};
                        charMetric.setW0(w0);
                        this.verifySemicolon(metricsTokenizer);
                        continue block36;
                    }
                    case "W1": {
                        float[] w1 = new float[]{Float.parseFloat(metricsTokenizer.nextToken()), Float.parseFloat(metricsTokenizer.nextToken())};
                        charMetric.setW1(w1);
                        this.verifySemicolon(metricsTokenizer);
                        continue block36;
                    }
                    case "VV": {
                        float[] vv = new float[]{Float.parseFloat(metricsTokenizer.nextToken()), Float.parseFloat(metricsTokenizer.nextToken())};
                        charMetric.setVv(vv);
                        this.verifySemicolon(metricsTokenizer);
                        continue block36;
                    }
                    case "N": {
                        charMetric.setName(metricsTokenizer.nextToken());
                        this.verifySemicolon(metricsTokenizer);
                        continue block36;
                    }
                    case "B": {
                        BoundingBox box = new BoundingBox();
                        box.setLowerLeftX(Float.parseFloat(metricsTokenizer.nextToken()));
                        box.setLowerLeftY(Float.parseFloat(metricsTokenizer.nextToken()));
                        box.setUpperRightX(Float.parseFloat(metricsTokenizer.nextToken()));
                        box.setUpperRightY(Float.parseFloat(metricsTokenizer.nextToken()));
                        charMetric.setBoundingBox(box);
                        this.verifySemicolon(metricsTokenizer);
                        continue block36;
                    }
                    case "L": {
                        Ligature lig = new Ligature();
                        lig.setSuccessor(metricsTokenizer.nextToken());
                        lig.setLigature(metricsTokenizer.nextToken());
                        charMetric.addLigature(lig);
                        this.verifySemicolon(metricsTokenizer);
                        continue block36;
                    }
                }
            }
            return charMetric;
            throw new IOException("Unknown CharMetrics command '" + nextCommand + "'");
        }
        catch (NumberFormatException e) {
            throw new IOException("Error: Corrupt AFM document:" + e);
        }
    }

    private void verifySemicolon(StringTokenizer tokenizer) throws IOException {
        if (tokenizer.hasMoreTokens()) {
            String semicolon = tokenizer.nextToken();
            if (!";".equals(semicolon)) {
                throw new IOException("Error: Expected semicolon in stream actual='" + semicolon + "'");
            }
        } else {
            throw new IOException("CharMetrics is missing a semicolon after a command");
        }
    }

    private boolean readBoolean() throws IOException {
        String theBoolean = this.readString();
        return Boolean.valueOf(theBoolean);
    }

    private int readInt() throws IOException {
        String theInt = this.readString();
        try {
            return Integer.parseInt(theInt);
        }
        catch (NumberFormatException e) {
            throw new IOException("Error parsing AFM document:" + e);
        }
    }

    private float readFloat() throws IOException {
        String theFloat = this.readString();
        return Float.parseFloat(theFloat);
    }

    private String readLine() throws IOException {
        StringBuilder buf = new StringBuilder(60);
        int nextByte = this.input.read();
        while (this.isWhitespace(nextByte)) {
            nextByte = this.input.read();
        }
        buf.append((char)nextByte);
        nextByte = this.input.read();
        while (nextByte != -1 && !this.isEOL(nextByte)) {
            buf.append((char)nextByte);
            nextByte = this.input.read();
        }
        return buf.toString();
    }

    private String readString() throws IOException {
        StringBuilder buf = new StringBuilder(24);
        int nextByte = this.input.read();
        while (this.isWhitespace(nextByte)) {
            nextByte = this.input.read();
        }
        buf.append((char)nextByte);
        nextByte = this.input.read();
        while (nextByte != -1 && !this.isWhitespace(nextByte)) {
            buf.append((char)nextByte);
            nextByte = this.input.read();
        }
        return buf.toString();
    }

    private boolean isEOL(int character) {
        return character == 13 || character == 10;
    }

    private boolean isWhitespace(int character) {
        return character == 32 || character == 9 || character == 13 || character == 10;
    }
}

