/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fontbox.ttf.gsub;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.fontbox.ttf.gsub.CompoundCharacterTokenizer;
import org.apache.fontbox.ttf.gsub.GlyphArraySplitter;

public class GlyphArraySplitterRegexImpl
implements GlyphArraySplitter {
    private static final String GLYPH_ID_SEPARATOR = "_";
    private final CompoundCharacterTokenizer compoundCharacterTokenizer;

    public GlyphArraySplitterRegexImpl(Set<List<Integer>> matchers) {
        this.compoundCharacterTokenizer = new CompoundCharacterTokenizer(this.getMatchersAsStrings(matchers));
    }

    @Override
    public List<List<Integer>> split(List<Integer> glyphIds) {
        String originalGlyphsAsText = this.convertGlyphIdsToString(glyphIds);
        List<String> tokens = this.compoundCharacterTokenizer.tokenize(originalGlyphsAsText);
        ArrayList<List<Integer>> modifiedGlyphs = new ArrayList<List<Integer>>();
        for (String token : tokens) {
            modifiedGlyphs.add(this.convertGlyphIdsToList(token));
        }
        return modifiedGlyphs;
    }

    private Set<String> getMatchersAsStrings(Set<List<Integer>> matchers) {
        HashSet<String> stringMatchers = new HashSet<String>(matchers.size());
        for (List<Integer> glyphIds : matchers) {
            stringMatchers.add(this.convertGlyphIdsToString(glyphIds));
        }
        return stringMatchers;
    }

    private String convertGlyphIdsToString(List<Integer> glyphIds) {
        StringBuilder sb = new StringBuilder(20);
        sb.append(GLYPH_ID_SEPARATOR);
        for (Integer glyphId : glyphIds) {
            sb.append(glyphId).append(GLYPH_ID_SEPARATOR);
        }
        return sb.toString();
    }

    private List<Integer> convertGlyphIdsToList(String glyphIdsAsString) {
        ArrayList<Integer> gsubProcessedGlyphsIds = new ArrayList<Integer>();
        for (String glyphId : glyphIdsAsString.split(GLYPH_ID_SEPARATOR)) {
            if (glyphId.trim().length() == 0) continue;
            gsubProcessedGlyphsIds.add(Integer.valueOf(glyphId));
        }
        return gsubProcessedGlyphsIds;
    }
}

