/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fontbox.ttf.table.common;

import java.util.ArrayList;
import org.apache.fontbox.ttf.table.common.CoverageTableFormat1;
import org.apache.fontbox.ttf.table.common.RangeRecord;

public class CoverageTableFormat2
extends CoverageTableFormat1 {
    private final RangeRecord[] rangeRecords;

    public CoverageTableFormat2(int coverageFormat, RangeRecord[] rangeRecords) {
        super(coverageFormat, CoverageTableFormat2.getRangeRecordsAsArray(rangeRecords));
        this.rangeRecords = rangeRecords;
    }

    public RangeRecord[] getRangeRecords() {
        return this.rangeRecords;
    }

    private static int[] getRangeRecordsAsArray(RangeRecord[] rangeRecords) {
        ArrayList<Integer> glyphIds = new ArrayList<Integer>();
        for (int i = 0; i < rangeRecords.length; ++i) {
            for (int glyphId = rangeRecords[i].getStartGlyphID(); glyphId <= rangeRecords[i].getEndGlyphID(); ++glyphId) {
                glyphIds.add(glyphId);
            }
        }
        int[] glyphArray = new int[glyphIds.size()];
        for (int i = 0; i < glyphArray.length; ++i) {
            glyphArray[i] = (Integer)glyphIds.get(i);
        }
        return glyphArray;
    }

    @Override
    public String toString() {
        return String.format("CoverageTableFormat2[coverageFormat=%d]", this.getCoverageFormat());
    }
}

