/*
 * Decompiled with CFR 0.152.
 */
package org.openxml4j.document.wordprocessing.model.table;

import org.dom4j.Element;
import org.dom4j.QName;
import org.openxml4j.document.wordprocessing.WordDocument;
import org.openxml4j.exceptions.OpenXML4JException;

public class CellWidth {
    private int nbCellHorizontallyMerged;

    public CellWidth() {
        this.nbCellHorizontallyMerged = 1;
    }

    public CellWidth(int nbCellHorizontallyMerged) throws OpenXML4JException {
        if (nbCellHorizontallyMerged < 1) {
            throw new OpenXML4JException("Cell merge should be >= 1");
        }
        this.nbCellHorizontallyMerged = nbCellHorizontallyMerged;
    }

    public int getNbCellHorizontallyMerged() {
        return this.nbCellHorizontallyMerged;
    }

    public void setNbCellHorizontallyMerged(int nbCellHorizontallyMerged) {
        this.nbCellHorizontallyMerged = nbCellHorizontallyMerged;
    }

    private boolean isCellMergedHorizontally() {
        return this.nbCellHorizontallyMerged > 1;
    }

    public void build(Element cellProperties) {
        if (this.isCellMergedHorizontally()) {
            Element cellWidth = cellProperties.addElement(new QName("gridSpan", WordDocument.namespaceWord));
            cellWidth.addAttribute(new QName("val", WordDocument.namespaceWord), new Integer(this.nbCellHorizontallyMerged).toString());
        }
    }
}

