/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.config;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.samza.config.Config;

public class MapConfig
extends Config {
    private final Map<String, String> map;

    public MapConfig() {
        this.map = Collections.emptyMap();
    }

    public MapConfig(Map<String, String> map) {
        this(Collections.singletonList(map));
    }

    public MapConfig(List<Map<String, String>> maps) {
        this.map = new HashMap<String, String>();
        for (Map<String, String> m : maps) {
            this.map.putAll(m);
        }
    }

    @Override
    public String get(Object k) {
        return this.map.get(k);
    }

    @Override
    public boolean containsKey(Object k) {
        return this.map.containsKey(k);
    }

    @Override
    public Set<Map.Entry<String, String>> entrySet() {
        return this.map.entrySet();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public Set<String> keySet() {
        return this.map.keySet();
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public Collection<String> values() {
        return this.map.values();
    }

    @Override
    public boolean containsValue(Object v) {
        return this.map.containsKey(v);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.map == null ? 0 : this.map.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MapConfig other = (MapConfig)obj;
        return !(this.map == null ? other.map != null : !this.map.equals(other.map));
    }

    public String toString() {
        return this.map.toString();
    }
}

