/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.metrics;

import java.util.concurrent.atomic.AtomicLong;
import org.apache.samza.metrics.Metric;
import org.apache.samza.metrics.MetricsVisitor;

public class Counter
implements Metric {
    private final String name;
    private final AtomicLong count;

    public Counter(String name) {
        this.name = name;
        this.count = new AtomicLong(0L);
    }

    public long inc() {
        return this.inc(1L);
    }

    public long inc(long n) {
        return this.count.addAndGet(n);
    }

    public long dec() {
        return this.dec(1L);
    }

    public long dec(long n) {
        return this.count.addAndGet(0L - n);
    }

    public void set(long n) {
        this.count.set(n);
    }

    public void clear() {
        this.count.set(0L);
    }

    public long getCount() {
        return this.count.get();
    }

    public String getName() {
        return this.name;
    }

    @Override
    public void visit(MetricsVisitor visitor) {
        visitor.counter(this);
    }

    public String toString() {
        return this.count.toString();
    }
}

