/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.system;

import java.util.Collections;
import java.util.Map;
import org.apache.samza.Partition;
import org.apache.samza.SamzaException;

public class SystemStreamMetadata {
    private final String streamName;
    private final Map<Partition, SystemStreamPartitionMetadata> partitionMetadata;

    public SystemStreamMetadata(String streamName, Map<Partition, SystemStreamPartitionMetadata> partitionMetadata) {
        this.streamName = streamName;
        this.partitionMetadata = partitionMetadata;
    }

    public String getStreamName() {
        return this.streamName;
    }

    public Map<Partition, SystemStreamPartitionMetadata> getSystemStreamPartitionMetadata() {
        return Collections.unmodifiableMap(this.partitionMetadata);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.partitionMetadata == null ? 0 : this.partitionMetadata.hashCode());
        result = 31 * result + (this.streamName == null ? 0 : this.streamName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SystemStreamMetadata other = (SystemStreamMetadata)obj;
        if (this.partitionMetadata == null ? other.partitionMetadata != null : !this.partitionMetadata.equals(other.partitionMetadata)) {
            return false;
        }
        return !(this.streamName == null ? other.streamName != null : !this.streamName.equals(other.streamName));
    }

    public String toString() {
        return "SystemStreamMetadata [streamName=" + this.streamName + ", partitionMetadata=" + this.partitionMetadata + "]";
    }

    public static enum OffsetType {
        OLDEST("oldest"),
        NEWEST("newest"),
        UPCOMING("upcoming");

        private final String offsetType;

        private OffsetType(String offsetType) {
            this.offsetType = offsetType;
        }
    }

    public static class SystemStreamPartitionMetadata {
        private final String oldestOffset;
        private final String newestOffset;
        private final String upcomingOffset;

        public SystemStreamPartitionMetadata(String oldestOffset, String newestOffset, String upcomingOffset) {
            this.oldestOffset = oldestOffset;
            this.newestOffset = newestOffset;
            this.upcomingOffset = upcomingOffset;
        }

        public String getOldestOffset() {
            return this.oldestOffset;
        }

        public String getNewestOffset() {
            return this.newestOffset;
        }

        public String getUpcomingOffset() {
            return this.upcomingOffset;
        }

        public String getOffset(OffsetType offsetType) {
            if (offsetType.equals((Object)OffsetType.OLDEST)) {
                return this.getOldestOffset();
            }
            if (offsetType.equals((Object)OffsetType.NEWEST)) {
                return this.getNewestOffset();
            }
            if (offsetType.equals((Object)OffsetType.UPCOMING)) {
                return this.getUpcomingOffset();
            }
            throw new SamzaException("Invalid offset type defined " + (Object)((Object)offsetType) + ".");
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.newestOffset == null ? 0 : this.newestOffset.hashCode());
            result = 31 * result + (this.oldestOffset == null ? 0 : this.oldestOffset.hashCode());
            result = 31 * result + (this.upcomingOffset == null ? 0 : this.upcomingOffset.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SystemStreamPartitionMetadata other = (SystemStreamPartitionMetadata)obj;
            if (this.newestOffset == null ? other.newestOffset != null : !this.newestOffset.equals(other.newestOffset)) {
                return false;
            }
            if (this.oldestOffset == null ? other.oldestOffset != null : !this.oldestOffset.equals(other.oldestOffset)) {
                return false;
            }
            return !(this.upcomingOffset == null ? other.upcomingOffset != null : !this.upcomingOffset.equals(other.upcomingOffset));
        }

        public String toString() {
            return "SystemStreamPartitionMetadata [oldestOffset=" + this.oldestOffset + ", newestOffset=" + this.newestOffset + ", upcomingOffset=" + this.upcomingOffset + "]";
        }
    }
}

