/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.system;

import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Queue;
import org.apache.samza.SamzaException;
import org.apache.samza.system.IncomingMessageEnvelope;
import org.apache.samza.system.SystemConsumer;
import org.apache.samza.system.SystemStreamPartition;

public class SystemStreamPartitionIterator
implements Iterator<IncomingMessageEnvelope> {
    private final SystemConsumer systemConsumer;
    private final Map<SystemStreamPartition, Integer> fetchMap;
    private Queue<IncomingMessageEnvelope> peeks;

    public SystemStreamPartitionIterator(SystemConsumer systemConsumer, SystemStreamPartition systemStreamPartition) {
        this(systemConsumer, systemStreamPartition, 1000);
    }

    public SystemStreamPartitionIterator(SystemConsumer systemConsumer, SystemStreamPartition systemStreamPartition, int fetchSize) {
        this.systemConsumer = systemConsumer;
        this.fetchMap = new HashMap<SystemStreamPartition, Integer>();
        this.fetchMap.put(systemStreamPartition, fetchSize);
        this.peeks = new ArrayDeque<IncomingMessageEnvelope>();
    }

    @Override
    public boolean hasNext() {
        this.refresh();
        return this.peeks.size() > 0;
    }

    @Override
    public IncomingMessageEnvelope next() {
        this.refresh();
        if (this.peeks.size() == 0) {
            throw new NoSuchElementException();
        }
        return this.peeks.poll();
    }

    @Override
    public void remove() {
    }

    private void refresh() {
        if (this.peeks.size() == 0) {
            try {
                List<IncomingMessageEnvelope> envelopes = this.systemConsumer.poll(this.fetchMap, -1L);
                if (envelopes != null && envelopes.size() > 0) {
                    this.peeks.addAll(envelopes);
                }
            }
            catch (InterruptedException e) {
                throw new SamzaException(e);
            }
        }
    }
}

