/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.system.kafka;

import kafka.consumer.ConsumerConfig;
import kafka.producer.Producer;
import kafka.producer.ProducerConfig;
import org.apache.samza.SamzaException;
import org.apache.samza.config.Config;
import org.apache.samza.config.KafkaConfig;
import org.apache.samza.config.KafkaConfig$;
import org.apache.samza.metrics.MetricsRegistry;
import org.apache.samza.system.SystemFactory;
import org.apache.samza.system.kafka.GetOffset;
import org.apache.samza.system.kafka.KafkaSystemAdmin;
import org.apache.samza.system.kafka.KafkaSystemConsumer;
import org.apache.samza.system.kafka.KafkaSystemConsumer$;
import org.apache.samza.system.kafka.KafkaSystemConsumerMetrics;
import org.apache.samza.system.kafka.KafkaSystemProducer;
import org.apache.samza.system.kafka.KafkaSystemProducerMetrics;
import org.apache.samza.util.ClientUtilTopicMetadataStore;
import org.apache.samza.util.ExponentialSleepStrategy;
import org.apache.samza.util.ExponentialSleepStrategy$;
import org.apache.samza.util.KafkaUtil$;
import scala.Function0;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

@ScalaSignature(bytes="\u0006\u0001E3A!\u0001\u0002\u0001\u001b\t\u00112*\u00194lCNK8\u000f^3n\r\u0006\u001cGo\u001c:z\u0015\t\u0019A!A\u0003lC\u001a\\\u0017M\u0003\u0002\u0006\r\u000511/_:uK6T!a\u0002\u0005\u0002\u000bM\fWN_1\u000b\u0005%Q\u0011AB1qC\u000eDWMC\u0001\f\u0003\ry'oZ\u0002\u0001'\r\u0001aB\u0006\t\u0003\u001fQi\u0011\u0001\u0005\u0006\u0003#I\tA\u0001\\1oO*\t1#\u0001\u0003kCZ\f\u0017BA\u000b\u0011\u0005\u0019y%M[3diB\u0011q\u0003G\u0007\u0002\t%\u0011\u0011\u0004\u0002\u0002\u000e'f\u001cH/Z7GC\u000e$xN]=\t\u000bm\u0001A\u0011\u0001\u000f\u0002\rqJg.\u001b;?)\u0005i\u0002C\u0001\u0010\u0001\u001b\u0005\u0011\u0001\"\u0002\u0011\u0001\t\u0003\t\u0013aC4fi\u000e{gn];nKJ$BAI\u00132qA\u0011adI\u0005\u0003I\t\u00111cS1gW\u0006\u001c\u0016p\u001d;f[\u000e{gn];nKJDQAJ\u0010A\u0002\u001d\n!b]=ti\u0016lg*Y7f!\tAcF\u0004\u0002*Y5\t!FC\u0001,\u0003\u0015\u00198-\u00197b\u0013\ti#&\u0001\u0004Qe\u0016$WMZ\u0005\u0003_A\u0012aa\u0015;sS:<'BA\u0017+\u0011\u0015\u0011t\u00041\u00014\u0003\u0019\u0019wN\u001c4jOB\u0011AGN\u0007\u0002k)\u0011!GB\u0005\u0003oU\u0012aaQ8oM&<\u0007\"B\u001d \u0001\u0004Q\u0014\u0001\u0003:fO&\u001cHO]=\u0011\u0005mrT\"\u0001\u001f\u000b\u0005u2\u0011aB7fiJL7m]\u0005\u0003\u007fq\u0012q\"T3ue&\u001c7OU3hSN$(/\u001f\u0005\u0006\u0003\u0002!\tAQ\u0001\fO\u0016$\bK]8ek\u000e,'\u000f\u0006\u0003D\r\u001eC\u0005C\u0001\u0010E\u0013\t)%AA\nLC\u001a\\\u0017mU=ti\u0016l\u0007K]8ek\u000e,'\u000fC\u0003'\u0001\u0002\u0007q\u0005C\u00033\u0001\u0002\u00071\u0007C\u0003:\u0001\u0002\u0007!\bC\u0003K\u0001\u0011\u00051*\u0001\u0005hKR\fE-\\5o)\rau\n\u0015\t\u0003=5K!A\u0014\u0002\u0003!-\u000bgm[1TsN$X-\\!e[&t\u0007\"\u0002\u0014J\u0001\u00049\u0003\"\u0002\u001aJ\u0001\u0004\u0019\u0004")
public class KafkaSystemFactory
implements SystemFactory {
    public KafkaSystemConsumer getConsumer(String systemName, Config config, MetricsRegistry registry) {
        String clientId = KafkaUtil$.MODULE$.getClientId("samza-consumer", config);
        KafkaSystemConsumerMetrics metrics = new KafkaSystemConsumerMetrics(systemName, registry);
        KafkaConfig qual$1 = KafkaConfig$.MODULE$.Config2Kafka(config);
        String x$1 = systemName;
        String x$2 = clientId;
        Map<String, String> x$3 = qual$1.getKafkaSystemProducerConfig$default$3();
        ProducerConfig producerConfig = qual$1.getKafkaSystemProducerConfig(x$1, x$2, x$3);
        String brokerListString = (String)Option$.MODULE$.apply((Object)producerConfig.brokerList()).getOrElse((Function0)new Serializable(this, systemName){
            public static final long serialVersionUID = 0L;
            private final String systemName$1;

            public final Nothing$ apply() {
                throw new SamzaException(new StringOps(Predef$.MODULE$.augmentString("No broker list defined in config for %s.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.systemName$1})));
            }
            {
                this.systemName$1 = systemName$1;
            }
        });
        KafkaConfig qual$2 = KafkaConfig$.MODULE$.Config2Kafka(config);
        String x$4 = systemName;
        String x$5 = clientId;
        String x$6 = qual$2.getKafkaSystemConsumerConfig$default$3();
        Map<String, String> x$7 = qual$2.getKafkaSystemConsumerConfig$default$4();
        ConsumerConfig consumerConfig = qual$2.getKafkaSystemConsumerConfig(x$4, x$5, x$6, x$7);
        int timeout = consumerConfig.socketTimeoutMs();
        int bufferSize = consumerConfig.socketReceiveBufferBytes();
        int fetchSize = consumerConfig.fetchMessageMaxBytes();
        int consumerMinSize = consumerConfig.fetchMinBytes();
        int consumerMaxWait = consumerConfig.fetchWaitMaxMs();
        String autoOffsetResetDefault = consumerConfig.autoOffsetReset();
        Map<String, String> autoOffsetResetTopics = KafkaConfig$.MODULE$.Config2Kafka(config).getAutoOffsetResetTopics(systemName);
        int fetchThreshold = new StringOps(Predef$.MODULE$.augmentString((String)KafkaConfig$.MODULE$.Config2Kafka(config).getConsumerFetchThreshold(systemName).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "50000";
            }
        }))).toInt();
        GetOffset offsetGetter = new GetOffset(autoOffsetResetDefault, autoOffsetResetTopics);
        ClientUtilTopicMetadataStore metadataStore = new ClientUtilTopicMetadataStore(brokerListString, clientId, timeout);
        return new KafkaSystemConsumer(systemName, brokerListString, metrics, metadataStore, clientId, timeout, bufferSize, fetchSize, consumerMinSize, consumerMaxWait, fetchThreshold, offsetGetter, KafkaSystemConsumer$.MODULE$.$lessinit$greater$default$13(), KafkaSystemConsumer$.MODULE$.$lessinit$greater$default$14(), KafkaSystemConsumer$.MODULE$.$lessinit$greater$default$15(), KafkaSystemConsumer$.MODULE$.$lessinit$greater$default$16());
    }

    public KafkaSystemProducer getProducer(String systemName, Config config, MetricsRegistry registry) {
        String clientId = KafkaUtil$.MODULE$.getClientId("samza-producer", config);
        KafkaConfig qual$3 = KafkaConfig$.MODULE$.Config2Kafka(config);
        String x$8 = systemName;
        String x$9 = clientId;
        Map<String, String> x$10 = qual$3.getKafkaSystemProducerConfig$default$3();
        ProducerConfig producerConfig = qual$3.getKafkaSystemProducerConfig(x$8, x$9, x$10);
        int batchSize = BoxesRunTime.unboxToInt((Object)Option$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)producerConfig.batchNumMessages())).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply() {
                return this.apply$mcI$sp();
            }

            public int apply$mcI$sp() {
                return 1000;
            }
        }));
        int reconnectIntervalMs = BoxesRunTime.unboxToInt((Object)Option$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)producerConfig.retryBackoffMs())).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply() {
                return this.apply$mcI$sp();
            }

            public int apply$mcI$sp() {
                return 1000;
            }
        }));
        Serializable getProducer = new Serializable(this, producerConfig){
            public static final long serialVersionUID = 0L;
            private final ProducerConfig producerConfig$1;

            public final Producer<Object, Object> apply() {
                return new Producer(this.producerConfig$1);
            }
            {
                this.producerConfig$1 = producerConfig$1;
            }
        };
        KafkaSystemProducerMetrics metrics = new KafkaSystemProducerMetrics(systemName, registry);
        long x$11 = reconnectIntervalMs;
        double x$12 = ExponentialSleepStrategy$.MODULE$.$lessinit$greater$default$1();
        long x$13 = ExponentialSleepStrategy$.MODULE$.$lessinit$greater$default$3();
        return new KafkaSystemProducer(systemName, batchSize, new ExponentialSleepStrategy(x$12, x$11, x$13), (Function0<Producer<Object, Object>>)getProducer, metrics);
    }

    public KafkaSystemAdmin getAdmin(String systemName, Config config) {
        String clientId = KafkaUtil$.MODULE$.getClientId("samza-admin", config);
        KafkaConfig qual$4 = KafkaConfig$.MODULE$.Config2Kafka(config);
        String x$14 = systemName;
        String x$15 = clientId;
        Map<String, String> x$16 = qual$4.getKafkaSystemProducerConfig$default$3();
        ProducerConfig producerConfig = qual$4.getKafkaSystemProducerConfig(x$14, x$15, x$16);
        String brokerListString = (String)Option$.MODULE$.apply((Object)producerConfig.brokerList()).getOrElse((Function0)new Serializable(this, systemName){
            public static final long serialVersionUID = 0L;
            private final String systemName$2;

            public final Nothing$ apply() {
                throw new SamzaException(new StringOps(Predef$.MODULE$.augmentString("No broker list defined in config for %s.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.systemName$2})));
            }
            {
                this.systemName$2 = systemName$2;
            }
        });
        KafkaConfig qual$5 = KafkaConfig$.MODULE$.Config2Kafka(config);
        String x$17 = systemName;
        String x$18 = clientId;
        String x$19 = qual$5.getKafkaSystemConsumerConfig$default$3();
        Map<String, String> x$20 = qual$5.getKafkaSystemConsumerConfig$default$4();
        ConsumerConfig consumerConfig = qual$5.getKafkaSystemConsumerConfig(x$17, x$18, x$19, x$20);
        int timeout = consumerConfig.socketTimeoutMs();
        int bufferSize = consumerConfig.socketReceiveBufferBytes();
        return new KafkaSystemAdmin(systemName, brokerListString, timeout, bufferSize, clientId);
    }
}

