/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.stream;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import java.util.Set;
import org.apache.solr.client.solrj.io.Tuple;
import org.apache.solr.client.solrj.io.comp.FieldComparator;
import org.apache.solr.client.solrj.io.comp.StreamComparator;
import org.apache.solr.client.solrj.io.stream.CloudSolrStream;
import org.apache.solr.client.solrj.io.stream.SolrStream;
import org.apache.solr.client.solrj.io.stream.StreamContext;
import org.apache.solr.client.solrj.io.stream.TupleStream;
import org.apache.solr.client.solrj.io.stream.expr.Expressible;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionNamedParameter;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionParameter;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionValue;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.cloud.ZkCoreNodeProps;
import org.apache.solr.common.cloud.ZkStateReader;

public class ParallelStream
extends CloudSolrStream
implements Expressible {
    private TupleStream tupleStream;
    private int workers;
    private transient StreamFactory streamFactory;

    public ParallelStream(String zkHost, String collection, TupleStream tupleStream, int workers, StreamComparator comp) throws IOException {
        this.init(zkHost, collection, tupleStream, workers, comp);
    }

    public ParallelStream(String zkHost, String collection, String expressionString, int workers, StreamComparator comp) throws IOException {
        TupleStream tStream = this.streamFactory.constructStream(expressionString);
        this.init(zkHost, collection, tStream, workers, comp);
    }

    public void setStreamFactory(StreamFactory streamFactory) {
        this.streamFactory = streamFactory;
    }

    public ParallelStream(StreamExpression expression, StreamFactory factory) throws IOException {
        String collectionName = factory.getValueOperand(expression, 0);
        StreamExpressionNamedParameter workersParam = factory.getNamedOperand(expression, "workers");
        List<StreamExpression> streamExpressions = factory.getExpressionOperandsRepresentingTypes(expression, Expressible.class, TupleStream.class);
        StreamExpressionNamedParameter sortExpression = factory.getNamedOperand(expression, "sort");
        StreamExpressionNamedParameter zkHostExpression = factory.getNamedOperand(expression, "zkHost");
        if (expression.getParameters().size() != streamExpressions.size() + 3 + (null != zkHostExpression ? 1 : 0)) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - unknown operands found", expression));
        }
        if (null == collectionName) {
            throw new IOException(String.format(Locale.ROOT, "invalid expression %s - collectionName expected as first operand", expression));
        }
        if (null == workersParam || null == workersParam.getParameter() || !(workersParam.getParameter() instanceof StreamExpressionValue)) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - expecting a single 'workersParam' parameter of type positive integer but didn't find one", expression));
        }
        String workersStr = ((StreamExpressionValue)workersParam.getParameter()).getValue();
        int workersInt = 0;
        try {
            workersInt = Integer.parseInt(workersStr);
            if (workersInt <= 0) {
                throw new IOException(String.format(Locale.ROOT, "invalid expression %s - workers '%s' must be greater than 0.", expression, workersStr));
            }
        }
        catch (NumberFormatException e) {
            throw new IOException(String.format(Locale.ROOT, "invalid expression %s - workers '%s' is not a valid integer.", expression, workersStr));
        }
        if (1 != streamExpressions.size()) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - expecting a single stream but found %d", expression, streamExpressions.size()));
        }
        if (null == sortExpression || !(sortExpression.getParameter() instanceof StreamExpressionValue)) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - expecting single 'sort' parameter telling us how to join the parallel streams but didn't find one", expression));
        }
        String zkHost = null;
        if (null == zkHostExpression) {
            zkHost = factory.getCollectionZkHost(collectionName);
            if (zkHost == null) {
                zkHost = factory.getDefaultZkHost();
            }
        } else if (zkHostExpression.getParameter() instanceof StreamExpressionValue) {
            zkHost = ((StreamExpressionValue)zkHostExpression.getParameter()).getValue();
        }
        if (null == zkHost) {
            throw new IOException(String.format(Locale.ROOT, "invalid expression %s - zkHost not found for collection '%s'", expression, collectionName));
        }
        TupleStream stream = factory.constructStream(streamExpressions.get(0));
        StreamComparator comp = factory.constructComparator(((StreamExpressionValue)sortExpression.getParameter()).getValue(), FieldComparator.class);
        this.streamFactory = factory;
        this.init(zkHost, collectionName, stream, workersInt, comp);
    }

    private void init(String zkHost, String collection, TupleStream tupleStream, int workers, StreamComparator comp) throws IOException {
        this.zkHost = zkHost;
        this.collection = collection;
        this.workers = workers;
        this.comp = comp;
        this.tupleStream = tupleStream;
        if (!(tupleStream instanceof Expressible)) {
            throw new IOException("Unable to create ParallelStream with a non-expressible TupleStream.");
        }
    }

    @Override
    public StreamExpression toExpression(StreamFactory factory) throws IOException {
        StreamExpression expression = new StreamExpression(factory.getFunctionName(this.getClass()));
        expression.addParameter(this.collection);
        expression.addParameter(new StreamExpressionNamedParameter("workers", Integer.toString(this.workers)));
        if (!(this.tupleStream instanceof Expressible)) {
            throw new IOException("This ParallelStream contains a non-expressible TupleStream - it cannot be converted to an expression");
        }
        expression.addParameter(((Expressible)((Object)this.tupleStream)).toExpression(factory));
        expression.addParameter(new StreamExpressionNamedParameter("sort", this.comp.toExpression(factory)));
        expression.addParameter(new StreamExpressionNamedParameter("zkHost", this.zkHost));
        return expression;
    }

    @Override
    public List<TupleStream> children() {
        ArrayList<TupleStream> l = new ArrayList<TupleStream>();
        l.add(this.tupleStream);
        return l;
    }

    @Override
    public Tuple read() throws IOException {
        Tuple tuple = this._read();
        if (tuple.EOF) {
            HashMap<String, Boolean> m = new HashMap<String, Boolean>();
            m.put("EOF", true);
            Tuple t = new Tuple(m);
            return t;
        }
        return tuple;
    }

    @Override
    public void setStreamContext(StreamContext streamContext) {
        this.streamContext = streamContext;
        if (this.streamFactory == null) {
            this.streamFactory = streamContext.getStreamFactory();
        }
        this.tupleStream.setStreamContext(streamContext);
    }

    @Override
    protected void constructStreams() throws IOException {
        try {
            StreamExpressionParameter pushStream = ((Expressible)((Object)this.tupleStream)).toExpression(this.streamFactory);
            ZkStateReader zkStateReader = this.cloudSolrClient.getZkStateReader();
            ClusterState clusterState = zkStateReader.getClusterState();
            Set<String> liveNodes = clusterState.getLiveNodes();
            Collection<Slice> slices = clusterState.getActiveSlices(this.collection);
            ArrayList<Replica> shuffler = new ArrayList<Replica>();
            for (Slice slice : slices) {
                Collection<Replica> replicas = slice.getReplicas();
                for (Replica replica : replicas) {
                    if (replica.getState() != Replica.State.ACTIVE || !liveNodes.contains(replica.getNodeName())) continue;
                    shuffler.add(replica);
                }
            }
            if (this.workers > shuffler.size()) {
                throw new IOException("Number of workers exceeds nodes in the worker collection");
            }
            Collections.shuffle(shuffler, new Random());
            for (int w = 0; w < this.workers; ++w) {
                HashMap<String, Object> params = new HashMap<String, Object>();
                params.put("distrib", "false");
                params.put("numWorkers", this.workers);
                params.put("workerID", w);
                params.put("expr", pushStream);
                params.put("qt", "/stream");
                Replica rep = (Replica)shuffler.get(w);
                ZkCoreNodeProps zkProps = new ZkCoreNodeProps(rep);
                String url = zkProps.getCoreUrl();
                SolrStream solrStream = new SolrStream(url, params);
                this.solrStreams.add(solrStream);
            }
            assert (this.solrStreams.size() == this.workers);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }
}

