/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.IOException;
import org.apache.spark.memory.MemoryConsumer;
import org.apache.spark.memory.TaskMemoryManager;
import org.apache.spark.sql.catalyst.expressions.FixedLengthRowBasedKeyValueBatch;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.catalyst.expressions.VariableLengthRowBasedKeyValueBatch;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.unsafe.KVIterator;
import org.apache.spark.unsafe.memory.MemoryBlock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RowBasedKeyValueBatch
extends MemoryConsumer {
    protected final Logger logger = LoggerFactory.getLogger(RowBasedKeyValueBatch.class);
    private static final int DEFAULT_CAPACITY = 65536;
    protected final StructType keySchema;
    protected final StructType valueSchema;
    protected final int capacity;
    protected int numRows = 0;
    protected int keyRowId = -1;
    protected final UnsafeRow keyRow;
    protected final UnsafeRow valueRow;
    protected MemoryBlock page = null;
    protected Object base = null;
    protected final long recordStartOffset;
    protected long pageCursor = 0L;

    public static RowBasedKeyValueBatch allocate(StructType keySchema, StructType valueSchema, TaskMemoryManager manager) {
        return RowBasedKeyValueBatch.allocate(keySchema, valueSchema, manager, 65536);
    }

    public static RowBasedKeyValueBatch allocate(StructType keySchema, StructType valueSchema, TaskMemoryManager manager, int maxRows2) {
        boolean allFixedLength = true;
        for (String name2 : keySchema.fieldNames()) {
            allFixedLength = allFixedLength && UnsafeRow.isFixedLength(keySchema.apply(name2).dataType());
        }
        for (String name2 : valueSchema.fieldNames()) {
            allFixedLength = allFixedLength && UnsafeRow.isFixedLength(valueSchema.apply(name2).dataType());
        }
        if (allFixedLength) {
            return new FixedLengthRowBasedKeyValueBatch(keySchema, valueSchema, maxRows2, manager);
        }
        return new VariableLengthRowBasedKeyValueBatch(keySchema, valueSchema, maxRows2, manager);
    }

    protected RowBasedKeyValueBatch(StructType keySchema, StructType valueSchema, int maxRows2, TaskMemoryManager manager) {
        super(manager, manager.pageSizeBytes(), manager.getTungstenMemoryMode());
        this.keySchema = keySchema;
        this.valueSchema = valueSchema;
        this.capacity = maxRows2;
        this.keyRow = new UnsafeRow(keySchema.length());
        this.valueRow = new UnsafeRow(valueSchema.length());
        if (!this.acquirePage(manager.pageSizeBytes())) {
            this.page = null;
            this.recordStartOffset = 0L;
        } else {
            this.base = this.page.getBaseObject();
            this.recordStartOffset = this.page.getBaseOffset();
        }
    }

    public final int numRows() {
        return this.numRows;
    }

    public final void close() {
        if (this.page != null) {
            this.freePage(this.page);
            this.page = null;
        }
    }

    private boolean acquirePage(long requiredSize) {
        try {
            this.page = this.allocatePage(requiredSize);
        }
        catch (OutOfMemoryError e) {
            this.logger.warn("Failed to allocate page ({} bytes).", (Object)requiredSize);
            return false;
        }
        this.base = this.page.getBaseObject();
        this.pageCursor = 0L;
        return true;
    }

    public abstract UnsafeRow appendRow(Object var1, long var2, int var4, Object var5, long var6, int var8);

    public abstract UnsafeRow getKeyRow(int var1);

    public final UnsafeRow getValueRow(int rowId) {
        return this.getValueFromKey(rowId);
    }

    protected abstract UnsafeRow getValueFromKey(int var1);

    public final long spill(long size, MemoryConsumer trigger) throws IOException {
        this.logger.warn("Calling spill() on RowBasedKeyValueBatch. Will not spill but return 0.");
        return 0L;
    }

    public abstract KVIterator<UnsafeRow, UnsafeRow> rowIterator();
}

