/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions.aggregate;

import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.dsl.package$expressions$;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.If;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.aggregate.CovPopulation;
import org.apache.spark.sql.catalyst.expressions.aggregate.DeclarativeAggregate;
import org.apache.spark.sql.catalyst.expressions.aggregate.RegrIntercept$;
import org.apache.spark.sql.catalyst.expressions.aggregate.VariancePop;
import org.apache.spark.sql.catalyst.trees.BinaryLike;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType;
import org.apache.spark.sql.types.DoubleType$;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="_FUNC_(y, x) - Returns the intercept of the univariate linear regression line for non-null pairs in a group, where `y` is the dependent variable and `x` is the independent variable.", examples="\n    Examples:\n      > SELECT _FUNC_(y, x) FROM VALUES (1,1), (2,2), (3,3) AS tab(y, x);\n       0.0\n      > SELECT _FUNC_(y, x) FROM VALUES (1, null) AS tab(y, x);\n       NULL\n      > SELECT _FUNC_(y, x) FROM VALUES (null, 1) AS tab(y, x);\n       NULL\n  ", group="agg_funcs", since="3.4.0")
@ScalaSignature(bytes="\u0006\u0005\tma\u0001\u0002\u0014(\u0001ZB\u0001B\u0017\u0001\u0003\u0016\u0004%\ta\u0017\u0005\t9\u0002\u0011\t\u0012)A\u0005\u000b\"AQ\f\u0001BK\u0002\u0013\u00051\f\u0003\u0005_\u0001\tE\t\u0015!\u0003F\u0011\u0015y\u0006\u0001\"\u0001a\u0011\u001d!\u0007A1A\u0005\n\u0015Da!\u001b\u0001!\u0002\u00131\u0007b\u00026\u0001\u0005\u0004%Ia\u001b\u0005\u0007_\u0002\u0001\u000b\u0011\u00027\t\u000bA\u0004A\u0011I9\t\u000bU\u0004A\u0011\t<\t\u000bu\u0004A\u0011\t@\t\u0015\u0005-\u0001\u0001#b\u0001\n\u0003\ni\u0001\u0003\u0006\u0002\u0018\u0001A)\u0019!C!\u00033A!\"!\b\u0001\u0011\u000b\u0007I\u0011IA\r\u0011)\ty\u0002\u0001EC\u0002\u0013\u0005\u0013\u0011\u0004\u0005\n\u0003C\u0001\u0001R1A\u0005BmC!\"a\t\u0001\u0011\u000b\u0007I\u0011IA\u0007\u0011\u001d\t)\u0003\u0001C!\u0003OAq!!\u000f\u0001\t#\nY\u0004C\u0005\u0002F\u0001\t\t\u0011\"\u0001\u0002H!I\u0011Q\n\u0001\u0012\u0002\u0013\u0005\u0011q\n\u0005\n\u0003K\u0002\u0011\u0013!C\u0001\u0003\u001fB\u0011\"a\u001a\u0001\u0003\u0003%\t%!\u001b\t\u0013\u0005e\u0004!!A\u0005\u0002\u0005m\u0004\"CAB\u0001\u0005\u0005I\u0011AAC\u0011%\t\t\nAA\u0001\n\u0003\n\u0019\nC\u0005\u0002\"\u0002\t\t\u0011\"\u0001\u0002$\"I\u0011q\u0015\u0001\u0002\u0002\u0013\u0005\u0013\u0011\u0016\u0005\n\u0003[\u0003\u0011\u0011!C!\u0003_;\u0011\"a5(\u0003\u0003E\t!!6\u0007\u0011\u0019:\u0013\u0011!E\u0001\u0003/Daa\u0018\u0011\u0005\u0002\u0005=\b\"CAyA\u0005\u0005IQIAz\u0011%\t)\u0010IA\u0001\n\u0003\u000b9\u0010C\u0005\u0002~\u0002\n\t\u0011\"!\u0002\u0000\"I!\u0011\u0003\u0011\u0002\u0002\u0013%!1\u0003\u0002\u000e%\u0016<'/\u00138uKJ\u001cW\r\u001d;\u000b\u0005!J\u0013!C1hOJ,w-\u0019;f\u0015\tQ3&A\u0006fqB\u0014Xm]:j_:\u001c(B\u0001\u0017.\u0003!\u0019\u0017\r^1msN$(B\u0001\u00180\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003aE\nQa\u001d9be.T!AM\u001a\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005!\u0014aA8sO\u000e\u00011C\u0002\u00018w}Be\n\u0005\u00029s5\tq%\u0003\u0002;O\t!B)Z2mCJ\fG/\u001b<f\u0003\u001e<'/Z4bi\u0016\u0004\"\u0001P\u001f\u000e\u0003%J!AP\u0015\u0003-%k\u0007\u000f\\5dSR\u001c\u0015m\u001d;J]B,H\u000fV=qKN\u00042\u0001Q\"F\u001b\u0005\t%B\u0001\",\u0003\u0015!(/Z3t\u0013\t!\u0015I\u0001\u0006CS:\f'/\u001f'jW\u0016\u0004\"\u0001\u0010$\n\u0005\u001dK#AC#yaJ,7o]5p]B\u0011\u0011\nT\u0007\u0002\u0015*\t1*A\u0003tG\u0006d\u0017-\u0003\u0002N\u0015\n9\u0001K]8ek\u000e$\bCA(X\u001d\t\u0001VK\u0004\u0002R)6\t!K\u0003\u0002Tk\u00051AH]8pizJ\u0011aS\u0005\u0003-*\u000bq\u0001]1dW\u0006<W-\u0003\u0002Y3\na1+\u001a:jC2L'0\u00192mK*\u0011aKS\u0001\u0005Y\u00164G/F\u0001F\u0003\u0015aWM\u001a;!\u0003\u0015\u0011\u0018n\u001a5u\u0003\u0019\u0011\u0018n\u001a5uA\u00051A(\u001b8jiz\"2!\u00192d!\tA\u0004\u0001C\u0003[\u000b\u0001\u0007Q\tC\u0003^\u000b\u0001\u0007Q)\u0001\u0005d_Z\f'\u000fU8q+\u00051\u0007C\u0001\u001dh\u0013\tAwEA\u0007D_Z\u0004v\u000e];mCRLwN\\\u0001\nG>4\u0018M\u001d)pa\u0002\naA^1s!>\u0004X#\u00017\u0011\u0005aj\u0017B\u00018(\u0005-1\u0016M]5b]\u000e,\u0007k\u001c9\u0002\u000fY\f'\u000fU8qA\u0005Aa.\u001e7mC\ndW-F\u0001s!\tI5/\u0003\u0002u\u0015\n9!i\\8mK\u0006t\u0017\u0001\u00033bi\u0006$\u0016\u0010]3\u0016\u0003]\u0004\"\u0001_>\u000e\u0003eT!A_\u0017\u0002\u000bQL\b/Z:\n\u0005qL(\u0001\u0003#bi\u0006$\u0016\u0010]3\u0002\u0015%t\u0007/\u001e;UsB,7/F\u0001\u0000!\u0015y\u0015\u0011AA\u0003\u0013\r\t\u0019!\u0017\u0002\u0004'\u0016\f\bc\u0001=\u0002\b%\u0019\u0011\u0011B=\u0003\u0015\u0011{WO\u00197f)f\u0004X-A\nbO\u001e\u0014UO\u001a4fe\u0006#HO]5ckR,7/\u0006\u0002\u0002\u0010A)q*!\u0001\u0002\u0012A\u0019A(a\u0005\n\u0007\u0005U\u0011F\u0001\nBiR\u0014\u0018NY;uKJ+g-\u001a:f]\u000e,\u0017!D5oSRL\u0017\r\u001c,bYV,7/\u0006\u0002\u0002\u001cA!q*!\u0001F\u0003E)\b\u000fZ1uK\u0016C\bO]3tg&|gn]\u0001\u0011[\u0016\u0014x-Z#yaJ,7o]5p]N\f!#\u001a<bYV\fG/Z#yaJ,7o]5p]\u0006A\u0012N\u001c9vi\u0006;wMQ;gM\u0016\u0014\u0018\t\u001e;sS\n,H/Z:\u0002\u0015A\u0014X\r\u001e;z\u001d\u0006lW-\u0006\u0002\u0002*A!\u00111FA\u001a\u001d\u0011\ti#a\f\u0011\u0005ES\u0015bAA\u0019\u0015\u00061\u0001K]3eK\u001aLA!!\u000e\u00028\t11\u000b\u001e:j]\u001eT1!!\rK\u0003]9\u0018\u000e\u001e5OK^\u001c\u0005.\u001b7ee\u0016t\u0017J\u001c;fe:\fG\u000eF\u0003b\u0003{\t\t\u0005\u0003\u0004\u0002@Q\u0001\r!R\u0001\b]\u0016<H*\u001a4u\u0011\u0019\t\u0019\u0005\u0006a\u0001\u000b\u0006Aa.Z<SS\u001eDG/\u0001\u0003d_BLH#B1\u0002J\u0005-\u0003b\u0002.\u0016!\u0003\u0005\r!\u0012\u0005\b;V\u0001\n\u00111\u0001F\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"!!\u0015+\u0007\u0015\u000b\u0019f\u000b\u0002\u0002VA!\u0011qKA1\u001b\t\tIF\u0003\u0003\u0002\\\u0005u\u0013!C;oG\",7m[3e\u0015\r\tyFS\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA2\u00033\u0012\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII\nQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXCAA6!\u0011\ti'a\u001e\u000e\u0005\u0005=$\u0002BA9\u0003g\nA\u0001\\1oO*\u0011\u0011QO\u0001\u0005U\u00064\u0018-\u0003\u0003\u00026\u0005=\u0014\u0001\u00049s_\u0012,8\r^!sSRLXCAA?!\rI\u0015qP\u0005\u0004\u0003\u0003S%aA%oi\u0006q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003BAD\u0003\u001b\u00032!SAE\u0013\r\tYI\u0013\u0002\u0004\u0003:L\b\"CAH5\u0005\u0005\t\u0019AA?\u0003\rAH%M\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011\u0011Q\u0013\t\u0007\u0003/\u000bi*a\"\u000e\u0005\u0005e%bAAN\u0015\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005}\u0015\u0011\u0014\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000eF\u0002s\u0003KC\u0011\"a$\u001d\u0003\u0003\u0005\r!a\"\u0002%A\u0014x\u000eZ;di\u0016cW-\\3oi:\u000bW.\u001a\u000b\u0005\u0003W\nY\u000bC\u0005\u0002\u0010v\t\t\u00111\u0001\u0002~\u00051Q-];bYN$2A]AY\u0011%\tyIHA\u0001\u0002\u0004\t9\tK\n\u0001\u0003k\u000bY,!0\u0002B\u0006\r\u0017qYAe\u0003\u001b\fy\rE\u0002=\u0003oK1!!/*\u0005U)\u0005\u0010\u001d:fgNLwN\u001c#fg\u000e\u0014\u0018\u000e\u001d;j_:\fQ!^:bO\u0016\f#!a0\u0002\u0003Wzf)\u0016(D?\"JH\u0006\t=*A5\u0002#+\u001a;ve:\u001c\b\u0005\u001e5fA%tG/\u001a:dKB$\be\u001c4!i\",\u0007%\u001e8jm\u0006\u0014\u0018.\u0019;fA1Lg.Z1sAI,wM]3tg&|g\u000e\t7j]\u0016\u0004cm\u001c:!]>tWF\\;mY\u0002\u0002\u0018-\u001b:tA%t\u0007%\u0019\u0011he>,\b\u000f\f\u0011xQ\u0016\u0014X\r\t1zA\u0002J7\u000f\t;iK\u0002\"W\r]3oI\u0016tG\u000f\t<be&\f'\r\\3!C:$\u0007\u0005\u0019=aA%\u001c\b\u0005\u001e5fA%tG-\u001a9f]\u0012,g\u000e\u001e\u0011wCJL\u0017M\u00197f]\u0005AQ\r_1na2,7/\t\u0002\u0002F\u0006\tiP\u0003\u0011!A\u0001*\u00050Y7qY\u0016\u001c(H\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u0015zY\u0001B\u0018\u0006\t$S\u001f6\u0003c+\u0011'V\u000bN\u0003\u0003&\r\u00172S1\u0002\u0003F\r\u00173S1\u0002\u0003f\r\u00174S\u0001\n5\u000b\t;bE\"JH\u0006\t=*w)\u0001\u0003\u0005\t\u0011!A\u0001\u0002d\u0006\r\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)s2\u0002\u00030\u000b\u0011G%>k\u0005EV!M+\u0016\u001b\u0006\u0005K\u0019-A9,H\u000e\\\u0015!\u0003N\u0003C/\u00192)s2\u0002\u00030K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!\u001dVcEJ\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u0015zY\u0001B\u0018\u0006\t$S\u001f6\u0003c+\u0011'V\u000bN\u0003\u0003F\\;mY2\u0002\u0013'\u000b\u0011B'\u0002\"\u0018M\u0019\u0015zY\u0001B\u0018f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0011O+2c%\u0002\t\u0011\u0002\u000b\u001d\u0014x.\u001e9\"\u0005\u0005-\u0017!C1hO~3WO\\2t\u0003\u0015\u0019\u0018N\\2fC\t\t\t.A\u00034]Qr\u0003'A\u0007SK\u001e\u0014\u0018J\u001c;fe\u000e,\u0007\u000f\u001e\t\u0003q\u0001\u001aR\u0001IAm\u0003K\u0004r!a7\u0002b\u0016+\u0015-\u0004\u0002\u0002^*\u0019\u0011q\u001c&\u0002\u000fI,h\u000e^5nK&!\u00111]Ao\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|gN\r\t\u0005\u0003O\fi/\u0004\u0002\u0002j*!\u00111^A:\u0003\tIw.C\u0002Y\u0003S$\"!!6\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!a\u001b\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u000b\u0005\fI0a?\t\u000bi\u001b\u0003\u0019A#\t\u000bu\u001b\u0003\u0019A#\u0002\u000fUt\u0017\r\u001d9msR!!\u0011\u0001B\u0007!\u0015I%1\u0001B\u0004\u0013\r\u0011)A\u0013\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u000b%\u0013I!R#\n\u0007\t-!J\u0001\u0004UkBdWM\r\u0005\t\u0005\u001f!\u0013\u0011!a\u0001C\u0006\u0019\u0001\u0010\n\u0019\u0002\u0019]\u0014\u0018\u000e^3SKBd\u0017mY3\u0015\u0005\tU\u0001\u0003BA7\u0005/IAA!\u0007\u0002p\t1qJ\u00196fGR\u0004")
public class RegrIntercept
extends DeclarativeAggregate
implements ImplicitCastInputTypes,
BinaryLike<Expression> {
    private Seq<AttributeReference> aggBufferAttributes;
    private Seq<Expression> initialValues;
    private Seq<Expression> updateExpressions;
    private Seq<Expression> mergeExpressions;
    private Expression evaluateExpression;
    private Seq<AttributeReference> inputAggBufferAttributes;
    private final Expression left;
    private final Expression right;
    private final CovPopulation covarPop;
    private final VariancePop varPop;
    private transient Seq<Expression> children;
    private volatile transient boolean bitmap$trans$0;
    private volatile byte bitmap$0;

    public static Option<Tuple2<Expression, Expression>> unapply(RegrIntercept x$0) {
        return RegrIntercept$.MODULE$.unapply(x$0);
    }

    public static Function1<Tuple2<Expression, Expression>, RegrIntercept> tupled() {
        return RegrIntercept$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, RegrIntercept>> curried() {
        return RegrIntercept$.MODULE$.curried();
    }

    @Override
    public final TreeNode mapChildren(Function1 f) {
        return BinaryLike.mapChildren$(this, f);
    }

    @Override
    public final TreeNode withNewChildrenInternal(IndexedSeq newChildren) {
        return BinaryLike.withNewChildrenInternal$(this, newChildren);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    private Seq<Expression> children$lzycompute() {
        RegrIntercept regrIntercept = this;
        synchronized (regrIntercept) {
            if (!this.bitmap$trans$0) {
                this.children = BinaryLike.children$(this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.children;
    }

    @Override
    public final Seq<Expression> children() {
        return !this.bitmap$trans$0 ? this.children$lzycompute() : this.children;
    }

    @Override
    public Expression left() {
        return this.left;
    }

    @Override
    public Expression right() {
        return this.right;
    }

    private CovPopulation covarPop() {
        return this.covarPop;
    }

    private VariancePop varPop() {
        return this.varPop;
    }

    @Override
    public boolean nullable() {
        return true;
    }

    @Override
    public DataType dataType() {
        return DoubleType$.MODULE$;
    }

    public Seq<DoubleType> inputTypes() {
        return (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new DoubleType$[]{DoubleType$.MODULE$, DoubleType$.MODULE$}));
    }

    private Seq<AttributeReference> aggBufferAttributes$lzycompute() {
        RegrIntercept regrIntercept = this;
        synchronized (regrIntercept) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.aggBufferAttributes = (Seq)this.covarPop().aggBufferAttributes().$plus$plus(this.varPop().aggBufferAttributes());
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.aggBufferAttributes;
    }

    @Override
    public Seq<AttributeReference> aggBufferAttributes() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.aggBufferAttributes$lzycompute() : this.aggBufferAttributes;
    }

    private Seq<Expression> initialValues$lzycompute() {
        RegrIntercept regrIntercept = this;
        synchronized (regrIntercept) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.initialValues = (Seq)this.covarPop().initialValues().$plus$plus(this.varPop().initialValues());
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.initialValues;
    }

    @Override
    public Seq<Expression> initialValues() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.initialValues$lzycompute() : this.initialValues;
    }

    private Seq<Expression> updateExpressions$lzycompute() {
        RegrIntercept regrIntercept = this;
        synchronized (regrIntercept) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.updateExpressions = (Seq)this.covarPop().updateExpressions().$plus$plus(this.varPop().updateExpressions());
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.updateExpressions;
    }

    @Override
    public Seq<Expression> updateExpressions() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.updateExpressions$lzycompute() : this.updateExpressions;
    }

    private Seq<Expression> mergeExpressions$lzycompute() {
        RegrIntercept regrIntercept = this;
        synchronized (regrIntercept) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                this.mergeExpressions = (Seq)this.covarPop().mergeExpressions().$plus$plus(this.varPop().mergeExpressions());
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
        }
        return this.mergeExpressions;
    }

    @Override
    public Seq<Expression> mergeExpressions() {
        return (byte)(this.bitmap$0 & 8) == 0 ? this.mergeExpressions$lzycompute() : this.mergeExpressions;
    }

    private Expression evaluateExpression$lzycompute() {
        RegrIntercept regrIntercept = this;
        synchronized (regrIntercept) {
            if ((byte)(this.bitmap$0 & 0x10) == 0) {
                this.evaluateExpression = new If((Expression)((Object)package$expressions$.MODULE$.DslExpression(this.varPop().m2()).$eq$eq$eq(package$expressions$.MODULE$.doubleToLiteral(0.0))), Literal$.MODULE$.create(null, (DataType)DoubleType$.MODULE$), package$expressions$.MODULE$.DslExpression(this.covarPop().yAvg()).$minus(package$expressions$.MODULE$.DslExpression(package$expressions$.MODULE$.DslExpression(this.covarPop().ck()).$div(this.varPop().m2())).$times(this.covarPop().xAvg())));
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x10);
            }
        }
        return this.evaluateExpression;
    }

    @Override
    public Expression evaluateExpression() {
        return (byte)(this.bitmap$0 & 0x10) == 0 ? this.evaluateExpression$lzycompute() : this.evaluateExpression;
    }

    private Seq<AttributeReference> inputAggBufferAttributes$lzycompute() {
        RegrIntercept regrIntercept = this;
        synchronized (regrIntercept) {
            if ((byte)(this.bitmap$0 & 0x20) == 0) {
                this.inputAggBufferAttributes = (Seq)this.covarPop().inputAggBufferAttributes().$plus$plus(this.varPop().inputAggBufferAttributes());
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x20);
            }
        }
        return this.inputAggBufferAttributes;
    }

    @Override
    public Seq<AttributeReference> inputAggBufferAttributes() {
        return (byte)(this.bitmap$0 & 0x20) == 0 ? this.inputAggBufferAttributes$lzycompute() : this.inputAggBufferAttributes;
    }

    @Override
    public String prettyName() {
        return "regr_intercept";
    }

    @Override
    public RegrIntercept withNewChildrenInternal(Expression newLeft, Expression newRight) {
        return this.copy(newLeft, newRight);
    }

    public RegrIntercept copy(Expression left, Expression right) {
        return new RegrIntercept(left, right);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    @Override
    public String productPrefix() {
        return "RegrIntercept";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.left();
                break;
            }
            case 1: {
                object = this.right();
                break;
            }
            default: {
                object = Statics.ioobe((int)x$1);
                break;
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof RegrIntercept;
    }

    @Override
    public String productElementName(int x$1) {
        String string;
        int n = x$1;
        switch (n) {
            case 0: {
                string = "left";
                break;
            }
            case 1: {
                string = "right";
                break;
            }
            default: {
                string = (String)Statics.ioobe((int)x$1);
                break;
            }
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof RegrIntercept)) return false;
        boolean bl = true;
        if (!bl) return false;
        RegrIntercept regrIntercept = (RegrIntercept)x$1;
        Expression expression = this.left();
        Expression expression2 = regrIntercept.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = regrIntercept.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!regrIntercept.canEqual(this)) return false;
        return true;
    }

    public RegrIntercept(Expression left, Expression right) {
        this.left = left;
        this.right = right;
        ExpectsInputTypes.$init$(this);
        BinaryLike.$init$(this);
        this.covarPop = new CovPopulation(right, left);
        this.varPop = new VariancePop(right);
    }
}

