/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions.aggregate;

import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.dsl.package$expressions$;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.If;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.aggregate.CovPopulation;
import org.apache.spark.sql.catalyst.expressions.aggregate.DeclarativeAggregate;
import org.apache.spark.sql.catalyst.expressions.aggregate.RegrSlope$;
import org.apache.spark.sql.catalyst.expressions.aggregate.VariancePop;
import org.apache.spark.sql.catalyst.trees.BinaryLike;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType;
import org.apache.spark.sql.types.DoubleType$;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="_FUNC_(y, x) - Returns the slope of the linear regression line for non-null pairs in a group, where `y` is the dependent variable and `x` is the independent variable.", examples="\n    Examples:\n      > SELECT _FUNC_(y, x) FROM VALUES (1,1), (2,2), (3,3) AS tab(y, x);\n       1.0\n      > SELECT _FUNC_(y, x) FROM VALUES (1, null) AS tab(y, x);\n       NULL\n      > SELECT _FUNC_(y, x) FROM VALUES (null, 1) AS tab(y, x);\n       NULL\n  ", group="agg_funcs", since="3.4.0")
@ScalaSignature(bytes="\u0006\u0005\tma\u0001\u0002\u0014(\u0001ZB\u0001B\u0017\u0001\u0003\u0016\u0004%\ta\u0017\u0005\t9\u0002\u0011\t\u0012)A\u0005\u000b\"AQ\f\u0001BK\u0002\u0013\u00051\f\u0003\u0005_\u0001\tE\t\u0015!\u0003F\u0011\u0015y\u0006\u0001\"\u0001a\u0011\u001d!\u0007A1A\u0005\n\u0015Da!\u001b\u0001!\u0002\u00131\u0007b\u00026\u0001\u0005\u0004%Ia\u001b\u0005\u0007_\u0002\u0001\u000b\u0011\u00027\t\u000bA\u0004A\u0011I9\t\u000bU\u0004A\u0011\t<\t\u000bu\u0004A\u0011\t@\t\u0015\u0005-\u0001\u0001#b\u0001\n\u0003\ni\u0001\u0003\u0006\u0002\u0018\u0001A)\u0019!C!\u00033A!\"!\b\u0001\u0011\u000b\u0007I\u0011IA\r\u0011)\ty\u0002\u0001EC\u0002\u0013\u0005\u0013\u0011\u0004\u0005\n\u0003C\u0001\u0001R1A\u0005BmC!\"a\t\u0001\u0011\u000b\u0007I\u0011IA\u0007\u0011\u001d\t)\u0003\u0001C!\u0003OAq!!\u000f\u0001\t#\nY\u0004C\u0005\u0002F\u0001\t\t\u0011\"\u0001\u0002H!I\u0011Q\n\u0001\u0012\u0002\u0013\u0005\u0011q\n\u0005\n\u0003K\u0002\u0011\u0013!C\u0001\u0003\u001fB\u0011\"a\u001a\u0001\u0003\u0003%\t%!\u001b\t\u0013\u0005e\u0004!!A\u0005\u0002\u0005m\u0004\"CAB\u0001\u0005\u0005I\u0011AAC\u0011%\t\t\nAA\u0001\n\u0003\n\u0019\nC\u0005\u0002\"\u0002\t\t\u0011\"\u0001\u0002$\"I\u0011q\u0015\u0001\u0002\u0002\u0013\u0005\u0013\u0011\u0016\u0005\n\u0003[\u0003\u0011\u0011!C!\u0003_;\u0011\"a5(\u0003\u0003E\t!!6\u0007\u0011\u0019:\u0013\u0011!E\u0001\u0003/Daa\u0018\u0011\u0005\u0002\u0005=\b\"CAyA\u0005\u0005IQIAz\u0011%\t)\u0010IA\u0001\n\u0003\u000b9\u0010C\u0005\u0002~\u0002\n\t\u0011\"!\u0002\u0000\"I!\u0011\u0003\u0011\u0002\u0002\u0013%!1\u0003\u0002\n%\u0016<'o\u00157pa\u0016T!\u0001K\u0015\u0002\u0013\u0005<wM]3hCR,'B\u0001\u0016,\u0003-)\u0007\u0010\u001d:fgNLwN\\:\u000b\u00051j\u0013\u0001C2bi\u0006d\u0017p\u001d;\u000b\u00059z\u0013aA:rY*\u0011\u0001'M\u0001\u0006gB\f'o\u001b\u0006\u0003eM\na!\u00199bG\",'\"\u0001\u001b\u0002\u0007=\u0014xm\u0001\u0001\u0014\r\u000194h\u0010%O!\tA\u0014(D\u0001(\u0013\tQtE\u0001\u000bEK\u000ed\u0017M]1uSZ,\u0017iZ4sK\u001e\fG/\u001a\t\u0003yuj\u0011!K\u0005\u0003}%\u0012a#S7qY&\u001c\u0017\u000e^\"bgRLe\u000e];u)f\u0004Xm\u001d\t\u0004\u0001\u000e+U\"A!\u000b\u0005\t[\u0013!\u0002;sK\u0016\u001c\u0018B\u0001#B\u0005)\u0011\u0015N\\1ss2K7.\u001a\t\u0003y\u0019K!aR\u0015\u0003\u0015\u0015C\bO]3tg&|g\u000e\u0005\u0002J\u00196\t!JC\u0001L\u0003\u0015\u00198-\u00197b\u0013\ti%JA\u0004Qe>$Wo\u0019;\u0011\u0005=;fB\u0001)V\u001d\t\tF+D\u0001S\u0015\t\u0019V'\u0001\u0004=e>|GOP\u0005\u0002\u0017&\u0011aKS\u0001\ba\u0006\u001c7.Y4f\u0013\tA\u0016L\u0001\u0007TKJL\u0017\r\\5{C\ndWM\u0003\u0002W\u0015\u0006!A.\u001a4u+\u0005)\u0015!\u00027fMR\u0004\u0013!\u0002:jO\"$\u0018A\u0002:jO\"$\b%\u0001\u0004=S:LGO\u0010\u000b\u0004C\n\u001c\u0007C\u0001\u001d\u0001\u0011\u0015QV\u00011\u0001F\u0011\u0015iV\u00011\u0001F\u0003!\u0019wN^1s!>\u0004X#\u00014\u0011\u0005a:\u0017B\u00015(\u00055\u0019uN\u001e)paVd\u0017\r^5p]\u0006I1m\u001c<beB{\u0007\u000fI\u0001\u0007m\u0006\u0014\bk\u001c9\u0016\u00031\u0004\"\u0001O7\n\u00059<#a\u0003,be&\fgnY3Q_B\fqA^1s!>\u0004\b%\u0001\u0005ok2d\u0017M\u00197f+\u0005\u0011\bCA%t\u0013\t!(JA\u0004C_>dW-\u00198\u0002\u0011\u0011\fG/\u0019+za\u0016,\u0012a\u001e\t\u0003qnl\u0011!\u001f\u0006\u0003u6\nQ\u0001^=qKNL!\u0001`=\u0003\u0011\u0011\u000bG/\u0019+za\u0016\f!\"\u001b8qkR$\u0016\u0010]3t+\u0005y\b#B(\u0002\u0002\u0005\u0015\u0011bAA\u00023\n\u00191+Z9\u0011\u0007a\f9!C\u0002\u0002\ne\u0014!\u0002R8vE2,G+\u001f9f\u0003M\twm\u001a\"vM\u001a,'/\u0011;ue&\u0014W\u000f^3t+\t\ty\u0001E\u0003P\u0003\u0003\t\t\u0002E\u0002=\u0003'I1!!\u0006*\u0005I\tE\u000f\u001e:jEV$XMU3gKJ,gnY3\u0002\u001b%t\u0017\u000e^5bYZ\u000bG.^3t+\t\tY\u0002\u0005\u0003P\u0003\u0003)\u0015!E;qI\u0006$X-\u0012=qe\u0016\u001c8/[8og\u0006\u0001R.\u001a:hK\u0016C\bO]3tg&|gn]\u0001\u0013KZ\fG.^1uK\u0016C\bO]3tg&|g.\u0001\rj]B,H/Q4h\u0005V4g-\u001a:BiR\u0014\u0018NY;uKN\f!\u0002\u001d:fiRLh*Y7f+\t\tI\u0003\u0005\u0003\u0002,\u0005Mb\u0002BA\u0017\u0003_\u0001\"!\u0015&\n\u0007\u0005E\"*\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003k\t9D\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003cQ\u0015aF<ji\"tUm^\"iS2$'/\u001a8J]R,'O\\1m)\u0015\t\u0017QHA!\u0011\u0019\ty\u0004\u0006a\u0001\u000b\u00069a.Z<MK\u001a$\bBBA\")\u0001\u0007Q)\u0001\u0005oK^\u0014\u0016n\u001a5u\u0003\u0011\u0019w\u000e]=\u0015\u000b\u0005\fI%a\u0013\t\u000fi+\u0002\u0013!a\u0001\u000b\"9Q,\u0006I\u0001\u0002\u0004)\u0015AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0003#R3!RA*W\t\t)\u0006\u0005\u0003\u0002X\u0005\u0005TBAA-\u0015\u0011\tY&!\u0018\u0002\u0013Ut7\r[3dW\u0016$'bAA0\u0015\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005\r\u0014\u0011\f\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AD2paf$C-\u001a4bk2$HEM\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\u0005-\u0004\u0003BA7\u0003oj!!a\u001c\u000b\t\u0005E\u00141O\u0001\u0005Y\u0006twM\u0003\u0002\u0002v\u0005!!.\u0019<b\u0013\u0011\t)$a\u001c\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0005\u0005u\u0004cA%\u0002\u0000%\u0019\u0011\u0011\u0011&\u0003\u0007%sG/\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\u0005\u001d\u0015Q\u0012\t\u0004\u0013\u0006%\u0015bAAF\u0015\n\u0019\u0011I\\=\t\u0013\u0005=%$!AA\u0002\u0005u\u0014a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0002\u0016B1\u0011qSAO\u0003\u000fk!!!'\u000b\u0007\u0005m%*\u0001\u0006d_2dWm\u0019;j_:LA!a(\u0002\u001a\nA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\r\u0011\u0018Q\u0015\u0005\n\u0003\u001fc\u0012\u0011!a\u0001\u0003\u000f\u000b!\u0003\u001d:pIV\u001cG/\u00127f[\u0016tGOT1nKR!\u00111NAV\u0011%\ty)HA\u0001\u0002\u0004\ti(\u0001\u0004fcV\fGn\u001d\u000b\u0004e\u0006E\u0006\"CAH=\u0005\u0005\t\u0019AADQM\u0001\u0011QWA^\u0003{\u000b\t-a1\u0002H\u0006%\u0017QZAh!\ra\u0014qW\u0005\u0004\u0003sK#!F#yaJ,7o]5p]\u0012+7o\u0019:jaRLwN\\\u0001\u0006kN\fw-Z\u0011\u0003\u0003\u007f\u000b\u0011QJ0G+:\u001bu\fK=-AaL\u0003%\f\u0011SKR,(O\\:!i\",\u0007e\u001d7pa\u0016\u0004sN\u001a\u0011uQ\u0016\u0004C.\u001b8fCJ\u0004#/Z4sKN\u001c\u0018n\u001c8!Y&tW\r\t4pe\u0002rwN\\\u0017ok2d\u0007\u0005]1jeN\u0004\u0013N\u001c\u0011bA\u001d\u0014x.\u001e9-A]DWM]3!Af\u0004\u0007%[:!i\",\u0007\u0005Z3qK:$WM\u001c;!m\u0006\u0014\u0018.\u00192mK\u0002\ng\u000e\u001a\u0011aq\u0002\u0004\u0013n\u001d\u0011uQ\u0016\u0004\u0013N\u001c3fa\u0016tG-\u001a8uAY\f'/[1cY\u0016t\u0013\u0001C3yC6\u0004H.Z:\"\u0005\u0005\u0015\u0017!!@\u000bA\u0001\u0002\u0003%\u0012=b[BdWm\u001d\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`Qed\u0003\u0005_\u0015!\rJ{U\n\t,B\u0019V+5\u000b\t\u00152YEJC\u0006\t\u00153YIJC\u0006\t\u00154YMJ\u0003%Q*!i\u0006\u0014\u0007&\u001f\u0017!q&Z$\u0002\t\u0011!A\u0001\u0002\u0003%\r\u00181\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\"JH\u0006\t=*A\u0019\u0013v*\u0014\u0011W\u00032+Vi\u0015\u0011)c1\u0002c.\u001e7mS\u0001\n5\u000b\t;bE\"JH\u0006\t=*w)\u0001\u0003\u0005\t\u0011!A\u0001rU\u000b\u0014'\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`Qed\u0003\u0005_\u0015!\rJ{U\n\t,B\u0019V+5\u000b\t\u0015ok2dG\u0006I\u0019*A\u0005\u001b\u0006\u0005^1cQed\u0003\u0005_\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!A9+F\n\u0014\u0006!A\u0005)qM]8va\u0006\u0012\u00111Z\u0001\nC\u001e<wLZ;oGN\fQa]5oG\u0016\f#!!5\u0002\u000bMrCG\f\u0019\u0002\u0013I+wM]*m_B,\u0007C\u0001\u001d!'\u0015\u0001\u0013\u0011\\As!\u001d\tY.!9F\u000b\u0006l!!!8\u000b\u0007\u0005}'*A\u0004sk:$\u0018.\\3\n\t\u0005\r\u0018Q\u001c\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:\u0014\u0004\u0003BAt\u0003[l!!!;\u000b\t\u0005-\u00181O\u0001\u0003S>L1\u0001WAu)\t\t).\u0001\u0005u_N#(/\u001b8h)\t\tY'A\u0003baBd\u0017\u0010F\u0003b\u0003s\fY\u0010C\u0003[G\u0001\u0007Q\tC\u0003^G\u0001\u0007Q)A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\t\u0005!Q\u0002\t\u0006\u0013\n\r!qA\u0005\u0004\u0005\u000bQ%AB(qi&|g\u000eE\u0003J\u0005\u0013)U)C\u0002\u0003\f)\u0013a\u0001V;qY\u0016\u0014\u0004\u0002\u0003B\bI\u0005\u0005\t\u0019A1\u0002\u0007a$\u0003'\u0001\u0007xe&$XMU3qY\u0006\u001cW\r\u0006\u0002\u0003\u0016A!\u0011Q\u000eB\f\u0013\u0011\u0011I\"a\u001c\u0003\r=\u0013'.Z2u\u0001")
public class RegrSlope
extends DeclarativeAggregate
implements ImplicitCastInputTypes,
BinaryLike<Expression> {
    private Seq<AttributeReference> aggBufferAttributes;
    private Seq<Expression> initialValues;
    private Seq<Expression> updateExpressions;
    private Seq<Expression> mergeExpressions;
    private Expression evaluateExpression;
    private Seq<AttributeReference> inputAggBufferAttributes;
    private final Expression left;
    private final Expression right;
    private final CovPopulation covarPop;
    private final VariancePop varPop;
    private transient Seq<Expression> children;
    private volatile transient boolean bitmap$trans$0;
    private volatile byte bitmap$0;

    public static Option<Tuple2<Expression, Expression>> unapply(RegrSlope x$0) {
        return RegrSlope$.MODULE$.unapply(x$0);
    }

    public static Function1<Tuple2<Expression, Expression>, RegrSlope> tupled() {
        return RegrSlope$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, RegrSlope>> curried() {
        return RegrSlope$.MODULE$.curried();
    }

    @Override
    public final TreeNode mapChildren(Function1 f) {
        return BinaryLike.mapChildren$(this, f);
    }

    @Override
    public final TreeNode withNewChildrenInternal(IndexedSeq newChildren) {
        return BinaryLike.withNewChildrenInternal$(this, newChildren);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    private Seq<Expression> children$lzycompute() {
        RegrSlope regrSlope = this;
        synchronized (regrSlope) {
            if (!this.bitmap$trans$0) {
                this.children = BinaryLike.children$(this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.children;
    }

    @Override
    public final Seq<Expression> children() {
        return !this.bitmap$trans$0 ? this.children$lzycompute() : this.children;
    }

    @Override
    public Expression left() {
        return this.left;
    }

    @Override
    public Expression right() {
        return this.right;
    }

    private CovPopulation covarPop() {
        return this.covarPop;
    }

    private VariancePop varPop() {
        return this.varPop;
    }

    @Override
    public boolean nullable() {
        return true;
    }

    @Override
    public DataType dataType() {
        return DoubleType$.MODULE$;
    }

    public Seq<DoubleType> inputTypes() {
        return (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new DoubleType$[]{DoubleType$.MODULE$, DoubleType$.MODULE$}));
    }

    private Seq<AttributeReference> aggBufferAttributes$lzycompute() {
        RegrSlope regrSlope = this;
        synchronized (regrSlope) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.aggBufferAttributes = (Seq)this.covarPop().aggBufferAttributes().$plus$plus(this.varPop().aggBufferAttributes());
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.aggBufferAttributes;
    }

    @Override
    public Seq<AttributeReference> aggBufferAttributes() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.aggBufferAttributes$lzycompute() : this.aggBufferAttributes;
    }

    private Seq<Expression> initialValues$lzycompute() {
        RegrSlope regrSlope = this;
        synchronized (regrSlope) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.initialValues = (Seq)this.covarPop().initialValues().$plus$plus(this.varPop().initialValues());
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.initialValues;
    }

    @Override
    public Seq<Expression> initialValues() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.initialValues$lzycompute() : this.initialValues;
    }

    private Seq<Expression> updateExpressions$lzycompute() {
        RegrSlope regrSlope = this;
        synchronized (regrSlope) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.updateExpressions = (Seq)this.covarPop().updateExpressions().$plus$plus(this.varPop().updateExpressions());
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.updateExpressions;
    }

    @Override
    public Seq<Expression> updateExpressions() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.updateExpressions$lzycompute() : this.updateExpressions;
    }

    private Seq<Expression> mergeExpressions$lzycompute() {
        RegrSlope regrSlope = this;
        synchronized (regrSlope) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                this.mergeExpressions = (Seq)this.covarPop().mergeExpressions().$plus$plus(this.varPop().mergeExpressions());
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
        }
        return this.mergeExpressions;
    }

    @Override
    public Seq<Expression> mergeExpressions() {
        return (byte)(this.bitmap$0 & 8) == 0 ? this.mergeExpressions$lzycompute() : this.mergeExpressions;
    }

    private Expression evaluateExpression$lzycompute() {
        RegrSlope regrSlope = this;
        synchronized (regrSlope) {
            if ((byte)(this.bitmap$0 & 0x10) == 0) {
                this.evaluateExpression = new If((Expression)((Object)package$expressions$.MODULE$.DslExpression(this.varPop().m2()).$eq$eq$eq(package$expressions$.MODULE$.doubleToLiteral(0.0))), Literal$.MODULE$.create(null, (DataType)DoubleType$.MODULE$), package$expressions$.MODULE$.DslExpression(this.covarPop().ck()).$div(this.varPop().m2()));
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x10);
            }
        }
        return this.evaluateExpression;
    }

    @Override
    public Expression evaluateExpression() {
        return (byte)(this.bitmap$0 & 0x10) == 0 ? this.evaluateExpression$lzycompute() : this.evaluateExpression;
    }

    private Seq<AttributeReference> inputAggBufferAttributes$lzycompute() {
        RegrSlope regrSlope = this;
        synchronized (regrSlope) {
            if ((byte)(this.bitmap$0 & 0x20) == 0) {
                this.inputAggBufferAttributes = (Seq)this.covarPop().inputAggBufferAttributes().$plus$plus(this.varPop().inputAggBufferAttributes());
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x20);
            }
        }
        return this.inputAggBufferAttributes;
    }

    @Override
    public Seq<AttributeReference> inputAggBufferAttributes() {
        return (byte)(this.bitmap$0 & 0x20) == 0 ? this.inputAggBufferAttributes$lzycompute() : this.inputAggBufferAttributes;
    }

    @Override
    public String prettyName() {
        return "regr_slope";
    }

    @Override
    public RegrSlope withNewChildrenInternal(Expression newLeft, Expression newRight) {
        return this.copy(newLeft, newRight);
    }

    public RegrSlope copy(Expression left, Expression right) {
        return new RegrSlope(left, right);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    @Override
    public String productPrefix() {
        return "RegrSlope";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.left();
                break;
            }
            case 1: {
                object = this.right();
                break;
            }
            default: {
                object = Statics.ioobe((int)x$1);
                break;
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof RegrSlope;
    }

    @Override
    public String productElementName(int x$1) {
        String string;
        int n = x$1;
        switch (n) {
            case 0: {
                string = "left";
                break;
            }
            case 1: {
                string = "right";
                break;
            }
            default: {
                string = (String)Statics.ioobe((int)x$1);
                break;
            }
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof RegrSlope)) return false;
        boolean bl = true;
        if (!bl) return false;
        RegrSlope regrSlope = (RegrSlope)x$1;
        Expression expression = this.left();
        Expression expression2 = regrSlope.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = regrSlope.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!regrSlope.canEqual(this)) return false;
        return true;
    }

    public RegrSlope(Expression left, Expression right) {
        this.left = left;
        this.right = right;
        ExpectsInputTypes.$init$(this);
        BinaryLike.$init$(this);
        this.covarPop = new CovPopulation(right, left);
        this.varPop = new VariancePop(right);
    }
}

