/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.regression;

import breeze.linalg.DenseVector;
import breeze.linalg.DenseVector$;
import breeze.math.Field;
import breeze.math.MutableInnerProductModule;
import breeze.optimize.CachedDiffFunction;
import breeze.optimize.DiffFunction;
import breeze.optimize.FirstOrderMinimizer;
import breeze.optimize.LBFGS;
import breeze.optimize.StochasticDiffFunction;
import java.io.IOException;
import org.apache.spark.SparkException;
import org.apache.spark.annotation.Experimental;
import org.apache.spark.ml.Estimator;
import org.apache.spark.ml.param.BooleanParam;
import org.apache.spark.ml.param.DoubleArrayParam;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.IntParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.ParamPair;
import org.apache.spark.ml.param.shared.HasFeaturesCol$class;
import org.apache.spark.ml.param.shared.HasFitIntercept$class;
import org.apache.spark.ml.param.shared.HasLabelCol$class;
import org.apache.spark.ml.param.shared.HasMaxIter$class;
import org.apache.spark.ml.param.shared.HasPredictionCol$class;
import org.apache.spark.ml.param.shared.HasTol$class;
import org.apache.spark.ml.regression.AFTCostFun;
import org.apache.spark.ml.regression.AFTPoint;
import org.apache.spark.ml.regression.AFTSurvivalRegression$;
import org.apache.spark.ml.regression.AFTSurvivalRegressionModel;
import org.apache.spark.ml.regression.AFTSurvivalRegressionParams;
import org.apache.spark.ml.regression.AFTSurvivalRegressionParams$class;
import org.apache.spark.ml.util.DefaultParamsWritable;
import org.apache.spark.ml.util.DefaultParamsWritable$class;
import org.apache.spark.ml.util.Identifiable$;
import org.apache.spark.ml.util.MLReader;
import org.apache.spark.ml.util.MLWritable$class;
import org.apache.spark.ml.util.MLWriter;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.DataFrame;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.storage.StorageLevel$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.mutable.ArrayBuilder;
import scala.collection.mutable.ArrayBuilder$;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@Experimental
@ScalaSignature(bytes="\u0006\u0001\u0005Uf\u0001B\u0001\u0003\u00015\u0011Q#\u0011$U'V\u0014h/\u001b<bYJ+wM]3tg&|gN\u0003\u0002\u0004\t\u0005Q!/Z4sKN\u001c\u0018n\u001c8\u000b\u0005\u00151\u0011AA7m\u0015\t9\u0001\"A\u0003ta\u0006\u00148N\u0003\u0002\n\u0015\u00051\u0011\r]1dQ\u0016T\u0011aC\u0001\u0004_J<7\u0001A\n\u0006\u000191\u0012d\b\t\u0004\u001fA\u0011R\"\u0001\u0003\n\u0005E!!!C#ti&l\u0017\r^8s!\t\u0019B#D\u0001\u0003\u0013\t)\"A\u0001\u000eB\rR\u001bVO\u001d<jm\u0006d'+Z4sKN\u001c\u0018n\u001c8N_\u0012,G\u000e\u0005\u0002\u0014/%\u0011\u0001D\u0001\u0002\u001c\u0003\u001a#6+\u001e:wSZ\fGNU3he\u0016\u001c8/[8o!\u0006\u0014\u0018-\\:\u0011\u0005iiR\"A\u000e\u000b\u0005q!\u0011\u0001B;uS2L!AH\u000e\u0003+\u0011+g-Y;miB\u000b'/Y7t/JLG/\u00192mKB\u0011\u0001%I\u0007\u0002\r%\u0011!E\u0002\u0002\b\u0019><w-\u001b8h\u0011!!\u0003A!b\u0001\n\u0003*\u0013aA;jIV\ta\u0005\u0005\u0002([9\u0011\u0001fK\u0007\u0002S)\t!&A\u0003tG\u0006d\u0017-\u0003\u0002-S\u00051\u0001K]3eK\u001aL!AL\u0018\u0003\rM#(/\u001b8h\u0015\ta\u0013\u0006K\u0002$c]\u0002\"AM\u001b\u000e\u0003MR!\u0001\u000e\u0004\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u00027g\t)1+\u001b8dK\u0006\n\u0001(A\u00032]Yr\u0003\u0007\u0003\u0005;\u0001\t\u0005\t\u0015!\u0003'\u0003\u0011)\u0018\u000e\u001a\u0011)\u0007e\nt\u0007C\u0003>\u0001\u0011\u0005a(\u0001\u0004=S:LGO\u0010\u000b\u0003\u007f\u0001\u0003\"a\u0005\u0001\t\u000b\u0011b\u0004\u0019\u0001\u0014)\u0007\u0001\u000bt\u0007K\u0002=c]BQ!\u0010\u0001\u0005\u0002\u0011#\u0012a\u0010\u0015\u0004\u0007F:\u0004\"B$\u0001\t\u0003A\u0015AD:fi\u001a+\u0017\r^;sKN\u001cu\u000e\u001c\u000b\u0003\u0013*k\u0011\u0001\u0001\u0005\u0006\u0017\u001a\u0003\rAJ\u0001\u0006m\u0006dW/\u001a\u0015\u0004\rF:\u0004\"\u0002(\u0001\t\u0003y\u0015aC:fi2\u000b'-\u001a7D_2$\"!\u0013)\t\u000b-k\u0005\u0019\u0001\u0014)\u00075\u000bt\u0007C\u0003T\u0001\u0011\u0005A+\u0001\u0007tKR\u001cUM\\:pe\u000e{G\u000e\u0006\u0002J+\")1J\u0015a\u0001M!\u001a!+M\u001c\t\u000ba\u0003A\u0011A-\u0002!M,G\u000f\u0015:fI&\u001cG/[8o\u0007>dGCA%[\u0011\u0015Yu\u000b1\u0001'Q\r9\u0016g\u000e\u0005\u0006;\u0002!\tAX\u0001\u0019g\u0016$\u0018+^1oi&dW\r\u0015:pE\u0006\u0014\u0017\u000e\\5uS\u0016\u001cHCA%`\u0011\u0015YE\f1\u0001a!\rA\u0013mY\u0005\u0003E&\u0012Q!\u0011:sCf\u0004\"\u0001\u000b3\n\u0005\u0015L#A\u0002#pk\ndW\rK\u0002]c]BQ\u0001\u001b\u0001\u0005\u0002%\fqb]3u#V\fg\u000e^5mKN\u001cu\u000e\u001c\u000b\u0003\u0013*DQaS4A\u0002\u0019B3aZ\u00198\u0011\u0015i\u0007\u0001\"\u0001o\u0003=\u0019X\r\u001e$ji&sG/\u001a:dKB$HCA%p\u0011\u0015YE\u000e1\u0001q!\tA\u0013/\u0003\u0002sS\t9!i\\8mK\u0006t\u0007f\u000172o!)Q\u000f\u0001C\u0001m\u0006Q1/\u001a;NCbLE/\u001a:\u0015\u0005%;\b\"B&u\u0001\u0004A\bC\u0001\u0015z\u0013\tQ\u0018FA\u0002J]RD3\u0001^\u00198\u0011\u0015i\b\u0001\"\u0001\u007f\u0003\u0019\u0019X\r\u001e+pYR\u0011\u0011j \u0005\u0006\u0017r\u0004\ra\u0019\u0015\u0004yF:\u0004\u0002CA\u0003\u0001\u0011EA!a\u0002\u0002!\u0015DHO]1di\u00063E\u000bU8j]R\u001cH\u0003BA\u0005\u00037\u0001b!a\u0003\u0002\u0012\u0005UQBAA\u0007\u0015\r\tyAB\u0001\u0004e\u0012$\u0017\u0002BA\n\u0003\u001b\u00111A\u0015#E!\r\u0019\u0012qC\u0005\u0004\u00033\u0011!\u0001C!G)B{\u0017N\u001c;\t\u0011\u0005u\u00111\u0001a\u0001\u0003?\tq\u0001Z1uCN,G\u000f\u0005\u0003\u0002\"\u0005\u001dRBAA\u0012\u0015\r\t)CB\u0001\u0004gFd\u0017\u0002BA\u0015\u0003G\u0011\u0011\u0002R1uC\u001a\u0013\u0018-\\3\t\u000f\u00055\u0002\u0001\"\u0011\u00020\u0005\u0019a-\u001b;\u0015\u0007I\t\t\u0004\u0003\u0005\u0002\u001e\u0005-\u0002\u0019AA\u0010Q\u0011\tY#M\u001c\t\u000f\u0005]\u0002\u0001\"\u0011\u0002:\u0005yAO]1og\u001a|'/\\*dQ\u0016l\u0017\r\u0006\u0003\u0002<\u0005\u001d\u0003\u0003BA\u001f\u0003\u0007j!!a\u0010\u000b\t\u0005\u0005\u00131E\u0001\u0006if\u0004Xm]\u0005\u0005\u0003\u000b\nyD\u0001\u0006TiJ,8\r\u001e+za\u0016D\u0001\"!\u0013\u00026\u0001\u0007\u00111H\u0001\u0007g\u000eDW-\\1)\t\u0005U\u0012g\u000e\u0005\b\u0003\u001f\u0002A\u0011IA)\u0003\u0011\u0019w\u000e]=\u0015\u0007}\n\u0019\u0006\u0003\u0005\u0002V\u00055\u0003\u0019AA,\u0003\u0015)\u0007\u0010\u001e:b!\u0011\tI&a\u0018\u000e\u0005\u0005m#bAA/\t\u0005)\u0001/\u0019:b[&!\u0011\u0011MA.\u0005!\u0001\u0016M]1n\u001b\u0006\u0004\b\u0006BA'c]B3\u0001A\u00198Q\r\u0001\u0011\u0011\u000e\t\u0004e\u0005-\u0014bAA7g\taQ\t\u001f9fe&lWM\u001c;bY\u001e9\u0011\u0011\u000f\u0002\t\u0002\u0005M\u0014!F!G)N+(O^5wC2\u0014Vm\u001a:fgNLwN\u001c\t\u0004'\u0005UdAB\u0001\u0003\u0011\u0003\t9h\u0005\u0005\u0002v\u0005e\u0014qPAC!\rA\u00131P\u0005\u0004\u0003{J#AB!osJ+g\r\u0005\u0003\u001b\u0003\u0003{\u0014bAAB7\t)B)\u001a4bk2$\b+\u0019:b[N\u0014V-\u00193bE2,\u0007c\u0001\u0015\u0002\b&\u0019\u0011\u0011R\u0015\u0003\u0019M+'/[1mSj\f'\r\\3\t\u000fu\n)\b\"\u0001\u0002\u000eR\u0011\u00111\u000f\u0005\t\u0003#\u000b)\b\"\u0011\u0002\u0014\u0006!An\\1e)\ry\u0014Q\u0013\u0005\b\u0003/\u000by\t1\u0001'\u0003\u0011\u0001\u0018\r\u001e5)\t\u0005=\u0015g\u000e\u0005\u000b\u0003;\u000b)(!A\u0005\n\u0005}\u0015a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"!!)\u0011\t\u0005\r\u0016QV\u0007\u0003\u0003KSA!a*\u0002*\u0006!A.\u00198h\u0015\t\tY+\u0001\u0003kCZ\f\u0017\u0002BAX\u0003K\u0013aa\u00142kK\u000e$\b\u0006BA;c]BC!a\u001c2o\u0001")
public class AFTSurvivalRegression
extends Estimator<AFTSurvivalRegressionModel>
implements AFTSurvivalRegressionParams,
DefaultParamsWritable {
    private final String uid;
    private final Param<String> censorCol;
    private final DoubleArrayParam quantileProbabilities;
    private final Param<String> quantilesCol;
    private final BooleanParam fitIntercept;
    private final DoubleParam tol;
    private final IntParam maxIter;
    private final Param<String> predictionCol;
    private final Param<String> labelCol;
    private final Param<String> featuresCol;

    public static MLReader<AFTSurvivalRegression> read() {
        return AFTSurvivalRegression$.MODULE$.read();
    }

    public static AFTSurvivalRegression load(String string) {
        return AFTSurvivalRegression$.MODULE$.load(string);
    }

    @Override
    public MLWriter write() {
        return DefaultParamsWritable$class.write(this);
    }

    @Override
    public void save(String path) throws IOException {
        MLWritable$class.save(this, path);
    }

    @Override
    public final Param<String> censorCol() {
        return this.censorCol;
    }

    @Override
    public final DoubleArrayParam quantileProbabilities() {
        return this.quantileProbabilities;
    }

    @Override
    public final Param<String> quantilesCol() {
        return this.quantilesCol;
    }

    @Override
    public final void org$apache$spark$ml$regression$AFTSurvivalRegressionParams$_setter_$censorCol_$eq(Param x$1) {
        this.censorCol = x$1;
    }

    @Override
    public final void org$apache$spark$ml$regression$AFTSurvivalRegressionParams$_setter_$quantileProbabilities_$eq(DoubleArrayParam x$1) {
        this.quantileProbabilities = x$1;
    }

    @Override
    public final void org$apache$spark$ml$regression$AFTSurvivalRegressionParams$_setter_$quantilesCol_$eq(Param x$1) {
        this.quantilesCol = x$1;
    }

    @Override
    public String getCensorCol() {
        return AFTSurvivalRegressionParams$class.getCensorCol(this);
    }

    @Override
    public double[] getQuantileProbabilities() {
        return AFTSurvivalRegressionParams$class.getQuantileProbabilities(this);
    }

    @Override
    public String getQuantilesCol() {
        return AFTSurvivalRegressionParams$class.getQuantilesCol(this);
    }

    @Override
    public boolean hasQuantilesCol() {
        return AFTSurvivalRegressionParams$class.hasQuantilesCol(this);
    }

    @Override
    public StructType validateAndTransformSchema(StructType schema, boolean fitting) {
        return AFTSurvivalRegressionParams$class.validateAndTransformSchema(this, schema, fitting);
    }

    @Override
    public final BooleanParam fitIntercept() {
        return this.fitIntercept;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasFitIntercept$_setter_$fitIntercept_$eq(BooleanParam x$1) {
        this.fitIntercept = x$1;
    }

    @Override
    public final boolean getFitIntercept() {
        return HasFitIntercept$class.getFitIntercept(this);
    }

    @Override
    public final DoubleParam tol() {
        return this.tol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasTol$_setter_$tol_$eq(DoubleParam x$1) {
        this.tol = x$1;
    }

    @Override
    public final double getTol() {
        return HasTol$class.getTol(this);
    }

    @Override
    public final IntParam maxIter() {
        return this.maxIter;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasMaxIter$_setter_$maxIter_$eq(IntParam x$1) {
        this.maxIter = x$1;
    }

    @Override
    public final int getMaxIter() {
        return HasMaxIter$class.getMaxIter(this);
    }

    @Override
    public final Param<String> predictionCol() {
        return this.predictionCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasPredictionCol$_setter_$predictionCol_$eq(Param x$1) {
        this.predictionCol = x$1;
    }

    @Override
    public final String getPredictionCol() {
        return HasPredictionCol$class.getPredictionCol(this);
    }

    @Override
    public final Param<String> labelCol() {
        return this.labelCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasLabelCol$_setter_$labelCol_$eq(Param x$1) {
        this.labelCol = x$1;
    }

    @Override
    public final String getLabelCol() {
        return HasLabelCol$class.getLabelCol(this);
    }

    @Override
    public final Param<String> featuresCol() {
        return this.featuresCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasFeaturesCol$_setter_$featuresCol_$eq(Param x$1) {
        this.featuresCol = x$1;
    }

    @Override
    public final String getFeaturesCol() {
        return HasFeaturesCol$class.getFeaturesCol(this);
    }

    @Override
    public String uid() {
        return this.uid;
    }

    public AFTSurvivalRegression setFeaturesCol(String value) {
        return (AFTSurvivalRegression)this.set(this.featuresCol(), value);
    }

    public AFTSurvivalRegression setLabelCol(String value) {
        return (AFTSurvivalRegression)this.set(this.labelCol(), value);
    }

    public AFTSurvivalRegression setCensorCol(String value) {
        return (AFTSurvivalRegression)this.set(this.censorCol(), value);
    }

    public AFTSurvivalRegression setPredictionCol(String value) {
        return (AFTSurvivalRegression)this.set(this.predictionCol(), value);
    }

    public AFTSurvivalRegression setQuantileProbabilities(double[] value) {
        return (AFTSurvivalRegression)this.set(this.quantileProbabilities(), value);
    }

    public AFTSurvivalRegression setQuantilesCol(String value) {
        return (AFTSurvivalRegression)this.set(this.quantilesCol(), value);
    }

    public AFTSurvivalRegression setFitIntercept(boolean value) {
        return (AFTSurvivalRegression)this.set(this.fitIntercept(), BoxesRunTime.boxToBoolean((boolean)value));
    }

    public AFTSurvivalRegression setMaxIter(int value) {
        return (AFTSurvivalRegression)this.set(this.maxIter(), BoxesRunTime.boxToInteger((int)value));
    }

    public AFTSurvivalRegression setTol(double value) {
        return (AFTSurvivalRegression)this.set(this.tol(), BoxesRunTime.boxToDouble((double)value));
    }

    public RDD<AFTPoint> extractAFTPoints(DataFrame dataset) {
        return dataset.select(this.$(this.featuresCol()), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.$(this.labelCol()), this.$(this.censorCol())})).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final AFTPoint apply(Row x0$1) {
                Row row = x0$1;
                Some some = Row$.MODULE$.unapplySeq(row);
                if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(3) == 0) {
                    Object features = ((SeqLike)some.get()).apply(0);
                    Object label = ((SeqLike)some.get()).apply(1);
                    Object censor = ((SeqLike)some.get()).apply(2);
                    if (features instanceof Vector) {
                        Vector vector = (Vector)features;
                        if (label instanceof Double) {
                            double d = BoxesRunTime.unboxToDouble((Object)label);
                            if (censor instanceof Double) {
                                double d2 = BoxesRunTime.unboxToDouble((Object)censor);
                                AFTPoint aFTPoint = new AFTPoint(vector, d, d2);
                                return aFTPoint;
                            }
                        }
                    }
                }
                throw new MatchError((Object)row);
            }
        }, ClassTag$.MODULE$.apply(AFTPoint.class));
    }

    @Override
    public AFTSurvivalRegressionModel fit(DataFrame dataset) {
        this.validateAndTransformSchema(dataset.schema(), true);
        RDD<AFTPoint> instances = this.extractAFTPoints(dataset);
        StorageLevel storageLevel = dataset.rdd().getStorageLevel();
        StorageLevel storageLevel2 = StorageLevel$.MODULE$.NONE();
        boolean handlePersistence = !(storageLevel != null ? !storageLevel.equals(storageLevel2) : storageLevel2 != null);
        Object object = handlePersistence ? instances.persist(StorageLevel$.MODULE$.MEMORY_AND_DISK()) : BoxedUnit.UNIT;
        AFTCostFun costFun = new AFTCostFun(instances, BoxesRunTime.unboxToBoolean((Object)this.$(this.fitIntercept())));
        LBFGS optimizer = new LBFGS(BoxesRunTime.unboxToInt((Object)this.$(this.maxIter())), 10, BoxesRunTime.unboxToDouble((Object)this.$(this.tol())), (MutableInnerProductModule)DenseVector$.MODULE$.space((Field)Field.fieldDouble$.MODULE$, ClassTag$.MODULE$.Double()));
        int numFeatures = ((Vector)dataset.select(this.$(this.featuresCol()), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).take(1)[0].getAs(0)).size();
        Vector initialParameters = Vectors$.MODULE$.zeros(numFeatures + 2);
        Iterator states = optimizer.iterations((StochasticDiffFunction)new CachedDiffFunction((DiffFunction)costFun, DenseVector$.MODULE$.canCopyDenseVector(ClassTag$.MODULE$.Double())), (Object)initialParameters.toBreeze().toDenseVector$mcD$sp(ClassTag$.MODULE$.Double()));
        ArrayBuilder arrayBuilder = ArrayBuilder$.MODULE$.make(ClassTag$.MODULE$.Double());
        FirstOrderMinimizer.State state = null;
        while (states.hasNext()) {
            state = (FirstOrderMinimizer.State)states.next();
            arrayBuilder.$plus$eq((Object)BoxesRunTime.boxToDouble((double)state.adjustedValue()));
        }
        if (state == null) {
            String msg = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " failed."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{optimizer.getClass().getName()}));
            throw new SparkException(msg);
        }
        double[] parameters = (double[])((DenseVector)state.x()).toArray$mcD$sp(ClassTag$.MODULE$.Double()).clone();
        Object object2 = handlePersistence ? instances.unpersist(instances.unpersist$default$1()) : BoxedUnit.UNIT;
        Vector coefficients = Vectors$.MODULE$.dense((double[])Predef$.MODULE$.doubleArrayOps(parameters).slice(2, parameters.length));
        double intercept = parameters[1];
        double scale = package$.MODULE$.exp(parameters[0]);
        AFTSurvivalRegressionModel model = new AFTSurvivalRegressionModel(this.uid(), coefficients, intercept, scale);
        return this.copyValues(model.setParent(this), this.copyValues$default$2());
    }

    @Override
    public StructType transformSchema(StructType schema) {
        return this.validateAndTransformSchema(schema, true);
    }

    @Override
    public AFTSurvivalRegression copy(ParamMap extra) {
        return (AFTSurvivalRegression)this.defaultCopy(extra);
    }

    public AFTSurvivalRegression(String uid) {
        this.uid = uid;
        HasFeaturesCol$class.$init$(this);
        HasLabelCol$class.$init$(this);
        HasPredictionCol$class.$init$(this);
        HasMaxIter$class.$init$(this);
        HasTol$class.$init$(this);
        HasFitIntercept$class.$init$(this);
        AFTSurvivalRegressionParams$class.$init$(this);
        MLWritable$class.$init$(this);
        DefaultParamsWritable$class.$init$(this);
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.fitIntercept().$minus$greater(BoxesRunTime.boxToBoolean((boolean)true))}));
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.maxIter().$minus$greater(BoxesRunTime.boxToInteger((int)100))}));
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.tol().$minus$greater(BoxesRunTime.boxToDouble((double)1.0E-6))}));
    }

    public AFTSurvivalRegression() {
        this(Identifiable$.MODULE$.randomUID("aftSurvReg"));
    }
}

