/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.tree;

import java.util.Map;
import org.apache.spark.Logging;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.mllib.tree.RandomForest;
import org.apache.spark.mllib.tree.configuration.Algo$;
import org.apache.spark.mllib.tree.configuration.QuantileStrategy$;
import org.apache.spark.mllib.tree.configuration.Strategy;
import org.apache.spark.mllib.tree.configuration.Strategy$;
import org.apache.spark.mllib.tree.impl.DecisionTreeMetadata;
import org.apache.spark.mllib.tree.impurity.Impurities$;
import org.apache.spark.mllib.tree.impurity.Impurity;
import org.apache.spark.mllib.tree.model.Node;
import org.apache.spark.mllib.tree.model.RandomForestModel;
import org.apache.spark.rdd.RDD;
import org.apache.spark.util.Utils$;
import org.apache.spark.util.random.SamplingUtils$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.Queue;
import scala.math.Numeric;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.util.Random;

public final class RandomForest$
implements Serializable,
Logging {
    public static final RandomForest$ MODULE$;
    private final String[] supportedFeatureSubsetStrategies;
    private transient Logger org$apache$spark$Logging$$log_;

    static {
        new RandomForest$();
    }

    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public RandomForestModel trainClassifier(RDD<LabeledPoint> input, Strategy strategy, int numTrees, String featureSubsetStrategy, int seed) {
        Enumeration.Value value = strategy.algo();
        Enumeration.Value value2 = Algo$.MODULE$.Classification();
        Predef$.MODULE$.require(!(value != null ? !value.equals(value2) : value2 != null), (Function0)new Serializable(strategy){
            public static final long serialVersionUID = 0L;
            private final Strategy strategy$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"RandomForest.trainClassifier given Strategy with invalid algo: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.strategy$1.algo()}));
            }
            {
                this.strategy$1 = strategy$1;
            }
        });
        RandomForest rf = new RandomForest(strategy, numTrees, featureSubsetStrategy, seed);
        return rf.run(input);
    }

    public RandomForestModel trainClassifier(RDD<LabeledPoint> input, int numClasses, scala.collection.immutable.Map<Object, Object> categoricalFeaturesInfo, int numTrees, String featureSubsetStrategy, String impurity, int maxDepth, int maxBins, int seed) {
        Impurity impurityType = Impurities$.MODULE$.fromString(impurity);
        Strategy strategy = new Strategy(Algo$.MODULE$.Classification(), impurityType, maxDepth, numClasses, maxBins, QuantileStrategy$.MODULE$.Sort(), categoricalFeaturesInfo, Strategy$.MODULE$.$lessinit$greater$default$8(), Strategy$.MODULE$.$lessinit$greater$default$9(), Strategy$.MODULE$.$lessinit$greater$default$10(), Strategy$.MODULE$.$lessinit$greater$default$11(), Strategy$.MODULE$.$lessinit$greater$default$12(), Strategy$.MODULE$.$lessinit$greater$default$13());
        return this.trainClassifier(input, strategy, numTrees, featureSubsetStrategy, seed);
    }

    public RandomForestModel trainClassifier(JavaRDD<LabeledPoint> input, int numClasses, Map<Integer, Integer> categoricalFeaturesInfo, int numTrees, String featureSubsetStrategy, String impurity, int maxDepth, int maxBins, int seed) {
        return this.trainClassifier((RDD<LabeledPoint>)input.rdd(), numClasses, (scala.collection.immutable.Map<Object, Object>)((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(categoricalFeaturesInfo).asScala()).toMap(Predef$.MODULE$.$conforms()), numTrees, featureSubsetStrategy, impurity, maxDepth, maxBins, seed);
    }

    public int trainClassifier$default$9() {
        return Utils$.MODULE$.random().nextInt();
    }

    public RandomForestModel trainRegressor(RDD<LabeledPoint> input, Strategy strategy, int numTrees, String featureSubsetStrategy, int seed) {
        Enumeration.Value value = strategy.algo();
        Enumeration.Value value2 = Algo$.MODULE$.Regression();
        Predef$.MODULE$.require(!(value != null ? !value.equals(value2) : value2 != null), (Function0)new Serializable(strategy){
            public static final long serialVersionUID = 0L;
            private final Strategy strategy$2;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"RandomForest.trainRegressor given Strategy with invalid algo: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.strategy$2.algo()}));
            }
            {
                this.strategy$2 = strategy$2;
            }
        });
        RandomForest rf = new RandomForest(strategy, numTrees, featureSubsetStrategy, seed);
        return rf.run(input);
    }

    public RandomForestModel trainRegressor(RDD<LabeledPoint> input, scala.collection.immutable.Map<Object, Object> categoricalFeaturesInfo, int numTrees, String featureSubsetStrategy, String impurity, int maxDepth, int maxBins, int seed) {
        Impurity impurityType = Impurities$.MODULE$.fromString(impurity);
        Strategy strategy = new Strategy(Algo$.MODULE$.Regression(), impurityType, maxDepth, 0, maxBins, QuantileStrategy$.MODULE$.Sort(), categoricalFeaturesInfo, Strategy$.MODULE$.$lessinit$greater$default$8(), Strategy$.MODULE$.$lessinit$greater$default$9(), Strategy$.MODULE$.$lessinit$greater$default$10(), Strategy$.MODULE$.$lessinit$greater$default$11(), Strategy$.MODULE$.$lessinit$greater$default$12(), Strategy$.MODULE$.$lessinit$greater$default$13());
        return this.trainRegressor(input, strategy, numTrees, featureSubsetStrategy, seed);
    }

    public RandomForestModel trainRegressor(JavaRDD<LabeledPoint> input, Map<Integer, Integer> categoricalFeaturesInfo, int numTrees, String featureSubsetStrategy, String impurity, int maxDepth, int maxBins, int seed) {
        return this.trainRegressor((RDD<LabeledPoint>)input.rdd(), (scala.collection.immutable.Map<Object, Object>)((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(categoricalFeaturesInfo).asScala()).toMap(Predef$.MODULE$.$conforms()), numTrees, featureSubsetStrategy, impurity, maxDepth, maxBins, seed);
    }

    public int trainRegressor$default$8() {
        return Utils$.MODULE$.random().nextInt();
    }

    public String[] supportedFeatureSubsetStrategies() {
        return this.supportedFeatureSubsetStrategies;
    }

    public Tuple2<scala.collection.immutable.Map<Object, Node[]>, scala.collection.immutable.Map<Object, scala.collection.immutable.Map<Object, RandomForest.NodeIndexInfo>>> selectNodesToSplit(Queue<Tuple2<Object, Node>> nodeQueue, long maxMemoryUsage, DecisionTreeMetadata metadata, Random rng) {
        long nodeMemUsage;
        HashMap mutableNodesForGroup = new HashMap();
        HashMap mutableTreeToNodeToIndexInfo = new HashMap();
        int numNodesInGroup = 0;
        for (long memUsage = 0L; nodeQueue.nonEmpty() && memUsage < maxMemoryUsage; memUsage += nodeMemUsage) {
            Tuple2 tuple2 = (Tuple2)nodeQueue.head();
            if (tuple2 != null) {
                Tuple2 tuple22;
                int treeIndex = tuple2._1$mcI$sp();
                Node node = (Node)tuple2._2();
                Tuple2 tuple23 = tuple22 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)treeIndex), (Object)node);
                int treeIndex2 = tuple23._1$mcI$sp();
                Node node2 = (Node)tuple23._2();
                Object featureSubset = metadata.subsamplingFeatures() ? new Some(SamplingUtils$.MODULE$.reservoirSampleAndCount(package$.MODULE$.Range().apply(0, metadata.numFeatures()).iterator(), metadata.numFeaturesPerNode(), rng.nextLong(), ClassTag$.MODULE$.Int())._1()) : None$.MODULE$;
                nodeMemUsage = this.aggregateSizeForNode(metadata, (Option<int[]>)featureSubset) * 8L;
                if (memUsage + nodeMemUsage <= maxMemoryUsage) {
                    nodeQueue.dequeue();
                    ((ArrayBuffer)mutableNodesForGroup.getOrElseUpdate((Object)BoxesRunTime.boxToInteger((int)treeIndex2), (Function0)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final ArrayBuffer<Node> apply() {
                            return new ArrayBuffer();
                        }
                    })).$plus$eq((Object)node2);
                    ((HashMap)mutableTreeToNodeToIndexInfo.getOrElseUpdate((Object)BoxesRunTime.boxToInteger((int)treeIndex2), (Function0)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final HashMap<Object, RandomForest.NodeIndexInfo> apply() {
                            return new HashMap();
                        }
                    })).update((Object)BoxesRunTime.boxToInteger((int)node2.id()), (Object)new RandomForest.NodeIndexInfo(numNodesInGroup, (Option<int[]>)featureSubset));
                }
                ++numNodesInGroup;
                continue;
            }
            throw new MatchError((Object)tuple2);
        }
        scala.collection.immutable.Map nodesForGroup = mutableNodesForGroup.mapValues((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Node[] apply(ArrayBuffer<Node> x$6) {
                return (Node[])x$6.toArray(ClassTag$.MODULE$.apply(Node.class));
            }
        }).toMap(Predef$.MODULE$.$conforms());
        scala.collection.immutable.Map treeToNodeToIndexInfo = mutableTreeToNodeToIndexInfo.mapValues((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final scala.collection.immutable.Map<Object, RandomForest.NodeIndexInfo> apply(HashMap<Object, RandomForest.NodeIndexInfo> x$7) {
                return x$7.toMap(Predef$.MODULE$.$conforms());
            }
        }).toMap(Predef$.MODULE$.$conforms());
        return new Tuple2((Object)nodesForGroup, (Object)treeToNodeToIndexInfo);
    }

    public long aggregateSizeForNode(DecisionTreeMetadata metadata, Option<int[]> featureSubset) {
        long totalBins = featureSubset.nonEmpty() ? BoxesRunTime.unboxToLong((Object)Predef$.MODULE$.longArrayOps((long[])Predef$.MODULE$.intArrayOps((int[])featureSubset.get()).map((Function1)new Serializable(metadata){
            public static final long serialVersionUID = 0L;
            private final DecisionTreeMetadata metadata$2;

            public final long apply(int featureIndex) {
                return this.apply$mcJI$sp(featureIndex);
            }

            public long apply$mcJI$sp(int featureIndex) {
                return this.metadata$2.numBins()[featureIndex];
            }
            {
                this.metadata$2 = metadata$2;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Long()))).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)) : BoxesRunTime.unboxToLong((Object)Predef$.MODULE$.longArrayOps((long[])Predef$.MODULE$.intArrayOps(metadata.numBins()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final long apply(int x$8) {
                return this.apply$mcJI$sp(x$8);
            }

            public long apply$mcJI$sp(int x$8) {
                return x$8;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Long()))).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
        return metadata.isClassification() ? (long)metadata.numClasses() * totalBins : 3L * totalBins;
    }

    private Object readResolve() {
        return MODULE$;
    }

    private RandomForest$() {
        MODULE$ = this;
        Logging.class.$init$((Logging)this);
        this.supportedFeatureSubsetStrategies = (String[])((Object[])new String[]{"auto", "all", "sqrt", "log2", "onethird"});
    }
}

