/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.linalg;

import breeze.linalg.SparseVector;
import breeze.storage.Zero;
import java.util.Arrays;
import org.apache.spark.mllib.linalg.DenseVector;
import org.apache.spark.mllib.linalg.SparseVector$;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vector$class;
import org.apache.spark.mllib.linalg.VectorUDT;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.sql.types.SQLUserDefinedType;
import org.json4s.JsonAST;
import org.json4s.JsonDSL$;
import org.json4s.jackson.JsonMethods$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Traversable;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;

@SQLUserDefinedType(udt=VectorUDT.class)
@ScalaSignature(bytes="\u0006\u0001\u0005%e\u0001B\u0001\u0003\u00015\u0011Ab\u00159beN,g+Z2u_JT!a\u0001\u0003\u0002\r1Lg.\u00197h\u0015\t)a!A\u0003nY2L'M\u0003\u0002\b\u0011\u0005)1\u000f]1sW*\u0011\u0011BC\u0001\u0007CB\f7\r[3\u000b\u0003-\t1a\u001c:h\u0007\u0001\u00192\u0001\u0001\b\u0015!\ty!#D\u0001\u0011\u0015\u0005\t\u0012!B:dC2\f\u0017BA\n\u0011\u0005\u0019\te.\u001f*fMB\u0011QCF\u0007\u0002\u0005%\u0011qC\u0001\u0002\u0007-\u0016\u001cGo\u001c:\t\u0011e\u0001!Q1A\u0005Bi\tAa]5{KV\t1\u0004\u0005\u0002\u00109%\u0011Q\u0004\u0005\u0002\u0004\u0013:$\bf\u0001\r KA\u0011\u0001eI\u0007\u0002C)\u0011!EB\u0001\u000bC:tw\u000e^1uS>t\u0017B\u0001\u0013\"\u0005\u0015\u0019\u0016N\\2fC\u00051\u0013!B\u0019/a9\u0002\u0004\u0002\u0003\u0015\u0001\u0005\u0003\u0005\u000b\u0011B\u000e\u0002\u000bML'0\u001a\u0011)\u0007\u001dzR\u0005\u0003\u0005,\u0001\t\u0015\r\u0011\"\u0001-\u0003\u001dIg\u000eZ5dKN,\u0012!\f\t\u0004\u001f9Z\u0012BA\u0018\u0011\u0005\u0015\t%O]1zQ\rQs$\n\u0005\te\u0001\u0011\t\u0011)A\u0005[\u0005A\u0011N\u001c3jG\u0016\u001c\b\u0005K\u00022?\u0015B\u0001\"\u000e\u0001\u0003\u0006\u0004%\tAN\u0001\u0007m\u0006dW/Z:\u0016\u0003]\u00022a\u0004\u00189!\ty\u0011(\u0003\u0002;!\t1Ai\\;cY\u0016D3\u0001N\u0010&\u0011!i\u0004A!A!\u0002\u00139\u0014a\u0002<bYV,7\u000f\t\u0015\u0004y})\u0003\"\u0002!\u0001\t\u0003\t\u0015A\u0002\u001fj]&$h\b\u0006\u0003C\u0007\u0016;\u0005CA\u000b\u0001\u0011\u0015Ir\b1\u0001\u001cQ\r\u0019u$\n\u0005\u0006W}\u0002\r!\f\u0015\u0004\u000b~)\u0003\"B\u001b@\u0001\u00049\u0004fA$ K!\u001aqhH\u0013\t\u000b-\u0003A\u0011\t'\u0002\u0011Q|7\u000b\u001e:j]\u001e$\u0012!\u0014\t\u0003\u001dFs!aD(\n\u0005A\u0003\u0012A\u0002)sK\u0012,g-\u0003\u0002S'\n11\u000b\u001e:j]\u001eT!\u0001\u0015\t\t\u000bU\u0003A\u0011\t\u001c\u0002\u000fQ|\u0017I\u001d:bs\"\u001aAkH\u0013\t\u000ba\u0003A\u0011I-\u0002\t\r|\u0007/_\u000b\u0002\u0005\"\u001aqkH.\"\u0003q\u000bQ!\r\u00182]ABaA\u0018\u0001\u0005B\u0019y\u0016\u0001\u0003;p\u0005J,WM_3\u0016\u0003\u0001\u00042!Y39\u001b\u0005\u0011'BA\u0002d\u0015\u0005!\u0017A\u00022sK\u0016TX-\u0003\u0002\u0018E\")q\r\u0001C!Q\u0006iam\u001c:fC\u000eD\u0017i\u0019;jm\u0016$\"!\u001b7\u0011\u0005=Q\u0017BA6\u0011\u0005\u0011)f.\u001b;\t\u000b54\u0007\u0019\u00018\u0002\u0003\u0019\u0004RaD8\u001cq%L!\u0001\u001d\t\u0003\u0013\u0019+hn\u0019;j_:\u0014\u0004f\u00014 e\u0006\n1/A\u00032]Yr\u0003\u0007C\u0003v\u0001\u0011\u0005c/\u0001\u0005iCND7i\u001c3f)\u0005Y\u0002\"\u0002=\u0001\t\u0003R\u0012A\u00038v[\u0006\u001bG/\u001b<fg\"\u001aqo\b>\"\u0003m\fQ!\r\u00185]ABQ! \u0001\u0005Bi\t1B\\;n\u001d>t'0\u001a:pg\"\u001aAp\b>\t\r\u0005\u0005\u0001\u0001\"\u0011Z\u0003!!xn\u00159beN,\u0007fA@ u\"1\u0011q\u0001\u0001\u0005Bi\ta!\u0019:h[\u0006D\b&BA\u0003?\u0005-\u0011EAA\u0007\u0003\u0015\td&\u000e\u00181\u0011!\t\t\u0002\u0001C\u0001\r\u0005M\u0011!B:mS\u000e,Gc\u0001\"\u0002\u0016!9\u0011qCA\b\u0001\u0004i\u0013aD:fY\u0016\u001cG/\u001a3J]\u0012L7-Z:\t\u000f\u0005m\u0001\u0001\"\u0011\u0002\u001e\u00051Ao\u001c&t_:,\u0012!\u0014\u0015\u0005\u00033y\"\u000fK\u0004\u0001\u0003G\t\u0019$!\u000e\u0011\t\u0005\u0015\u0012qF\u0007\u0003\u0003OQA!!\u000b\u0002,\u0005)A/\u001f9fg*\u0019\u0011Q\u0006\u0004\u0002\u0007M\fH.\u0003\u0003\u00022\u0005\u001d\"AE*R\u0019V\u001bXM\u001d#fM&tW\r\u001a+za\u0016\f1!\u001e3uG\t\t9\u0004E\u0002\u0016\u0003sI1!a\u000f\u0003\u0005%1Vm\u0019;peV#E\u000bK\u0002\u0001?\u0015:q!!\u0011\u0003\u0011\u0003\t\u0019%\u0001\u0007Ta\u0006\u00148/\u001a,fGR|'\u000fE\u0002\u0016\u0003\u000b2a!\u0001\u0002\t\u0002\u0005\u001d3#BA#\u001d\u0005%\u0003cA\b\u0002L%\u0019\u0011Q\n\t\u0003\u0019M+'/[1mSj\f'\r\\3\t\u000f\u0001\u000b)\u0005\"\u0001\u0002RQ\u0011\u00111\t\u0005\t\u0003+\n)\u0005\"\u0001\u0002X\u00059QO\\1qa2LH\u0003BA-\u0003K\u0002RaDA.\u0003?J1!!\u0018\u0011\u0005\u0019y\u0005\u000f^5p]B1q\"!\u0019\u001c[]J1!a\u0019\u0011\u0005\u0019!V\u000f\u001d7fg!9\u0011qMA*\u0001\u0004\u0011\u0015AA:wQ\u0015\t\u0019fHA6C\t\ti'A\u00032]Mr\u0003\u0007\u0003\u0006\u0002r\u0005\u0015\u0013\u0011!C\u0005\u0003g\n1B]3bIJ+7o\u001c7wKR\u0011\u0011Q\u000f\t\u0005\u0003o\n\t)\u0004\u0002\u0002z)!\u00111PA?\u0003\u0011a\u0017M\\4\u000b\u0005\u0005}\u0014\u0001\u00026bm\u0006LA!a!\u0002z\t1qJ\u00196fGRDS!!\u0012 \u0003WBS!a\u0010 \u0003W\u0002")
public class SparseVector
implements Vector {
    private final int size;
    private final int[] indices;
    private final double[] values;

    public static Option<Tuple3<Object, int[], double[]>> unapply(SparseVector sparseVector) {
        return SparseVector$.MODULE$.unapply(sparseVector);
    }

    @Override
    public boolean equals(Object other) {
        return Vector$class.equals(this, other);
    }

    @Override
    public double apply(int i) {
        return Vector$class.apply(this, i);
    }

    @Override
    public DenseVector toDense() {
        return Vector$class.toDense(this);
    }

    @Override
    public Vector compressed() {
        return Vector$class.compressed(this);
    }

    @Override
    public int size() {
        return this.size;
    }

    public int[] indices() {
        return this.indices;
    }

    public double[] values() {
        return this.values;
    }

    public String toString() {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(", ",", ",", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.size()), Predef$.MODULE$.intArrayOps(this.indices()).mkString("[", ",", "]"), Predef$.MODULE$.doubleArrayOps(this.values()).mkString("[", ",", "]")}));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public double[] toArray() {
        void var1_1;
        double[] data = new double[this.size()];
        int nnz = this.indices().length;
        for (int i = 0; i < nnz; ++i) {
            data[this.indices()[i]] = this.values()[i];
        }
        return var1_1;
    }

    @Override
    public SparseVector copy() {
        return new SparseVector(this.size(), (int[])this.indices().clone(), (double[])this.values().clone());
    }

    @Override
    public breeze.linalg.Vector<Object> toBreeze() {
        return new SparseVector.mcD.sp(this.indices(), this.values(), this.size(), (Zero)Zero.DoubleZero$.MODULE$);
    }

    @Override
    public void foreachActive(Function2<Object, Object, BoxedUnit> f) {
        int localValuesSize = this.values().length;
        int[] localIndices = this.indices();
        double[] localValues = this.values();
        for (int i = 0; i < localValuesSize; ++i) {
            f.apply$mcVID$sp(localIndices[i], localValues[i]);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int hashCode() {
        void var1_1;
        int result = 31 + this.size();
        int end = this.values().length;
        int nnz = 0;
        for (int k = 0; k < end && nnz < Vectors$.MODULE$.MAX_HASH_NNZ(); ++k) {
            double v = this.values()[k];
            if (v == 0.0) continue;
            int i = this.indices()[k];
            result = 31 * result + i;
            long bits = Double.doubleToLongBits(v);
            result = 31 * result + (int)(bits ^ bits >>> 32);
            ++nnz;
        }
        return (int)var1_1;
    }

    @Override
    public int numActives() {
        return this.values().length;
    }

    @Override
    public int numNonzeros() {
        IntRef nnz = IntRef.create((int)0);
        Predef$.MODULE$.doubleArrayOps(this.values()).foreach((Function1)new Serializable(this, nnz){
            public static final long serialVersionUID = 0L;
            private final IntRef nnz$3;

            public final void apply(double v) {
                this.apply$mcVD$sp(v);
            }

            public void apply$mcVD$sp(double v) {
                if (v != 0.0) {
                    ++this.nnz$3.elem;
                }
            }
            {
                this.nnz$3 = nnz$3;
            }
        });
        return nnz.elem;
    }

    @Override
    public SparseVector toSparse() {
        SparseVector sparseVector;
        int nnz = this.numNonzeros();
        if (nnz == this.numActives()) {
            sparseVector = this;
        } else {
            int[] ii = new int[nnz];
            double[] vv = new double[nnz];
            IntRef k = IntRef.create((int)0);
            this.foreachActive((Function2<Object, Object, BoxedUnit>)new Serializable(this, ii, vv, k){
                public static final long serialVersionUID = 0L;
                private final int[] ii$2;
                private final double[] vv$2;
                private final IntRef k$2;

                public final void apply(int i, double v) {
                    this.apply$mcVID$sp(i, v);
                }

                public void apply$mcVID$sp(int i, double v) {
                    if (v != 0.0) {
                        this.ii$2[this.k$2.elem] = i;
                        this.vv$2[this.k$2.elem] = v;
                        ++this.k$2.elem;
                    }
                }
                {
                    this.ii$2 = ii$2;
                    this.vv$2 = vv$2;
                    this.k$2 = k$2;
                }
            });
            sparseVector = new SparseVector(this.size(), ii, vv);
        }
        return sparseVector;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int argmax() {
        int n;
        if (this.size() == 0) {
            n = -1;
        } else {
            void var1_1;
            int maxIdx = this.indices()[0];
            double maxValue = this.values()[0];
            int maxJ = 0;
            int na = this.numActives();
            for (int j = 1; j < na; ++j) {
                double v = this.values()[j];
                if (!(v > maxValue)) continue;
                maxValue = v;
                maxIdx = this.indices()[j];
                maxJ = j;
            }
            if (maxValue <= 0.0 && na < this.size()) {
                if (maxValue == 0.0) {
                    if (maxJ < maxIdx) {
                        int k;
                        for (k = 0; k < maxJ && this.indices()[k] == k; ++k) {
                        }
                        maxIdx = k;
                    }
                } else {
                    int k;
                    for (k = 0; k < na && this.indices()[k] == k; ++k) {
                    }
                    maxIdx = k;
                }
            }
            n = var1_1;
        }
        return n;
    }

    public SparseVector slice(int[] selectedIndices) {
        IntRef currentIdx = IntRef.create((int)0);
        Tuple2 tuple2 = Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.intArrayOps(selectedIndices).flatMap((Function1)new Serializable(this, currentIdx){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SparseVector $outer;
            private final IntRef currentIdx$1;

            /*
             * WARNING - void declaration
             */
            public final Iterator<Tuple2<Object, Object>> apply(int origIdx) {
                void var3_3;
                int iIdx = Arrays.binarySearch(this.$outer.indices(), origIdx);
                Iterator i_v = iIdx >= 0 ? package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcID.sp(this.currentIdx$1.elem, this.$outer.values()[iIdx])})) : package$.MODULE$.Iterator().apply((Seq)Nil$.MODULE$);
                ++this.currentIdx$1.elem;
                return var3_3;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.currentIdx$1 = currentIdx$1;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).unzip((Function1)Predef$.MODULE$.$conforms(), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.Double());
        if (tuple2 != null) {
            Tuple2 tuple22;
            int[] sliceInds = (int[])tuple2._1();
            double[] sliceVals = (double[])tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)sliceInds, (Object)sliceVals);
            int[] sliceInds2 = (int[])tuple23._1();
            double[] sliceVals2 = (double[])tuple23._2();
            return new SparseVector(selectedIndices.length, (int[])Predef$.MODULE$.intArrayOps(sliceInds2).toArray(ClassTag$.MODULE$.Int()), (double[])Predef$.MODULE$.doubleArrayOps(sliceVals2).toArray(ClassTag$.MODULE$.Double()));
        }
        throw new MatchError((Object)tuple2);
    }

    @Override
    public String toJson() {
        JsonAST.JObject jValue = JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.pair2Assoc(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"type"), (Object)BoxesRunTime.boxToInteger((int)0)), (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final JsonAST.JValue apply(int x) {
                return JsonDSL$.MODULE$.int2jvalue(x);
            }
        }).$tilde(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"size"), (Object)BoxesRunTime.boxToInteger((int)this.size())), (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final JsonAST.JValue apply(int x) {
                return JsonDSL$.MODULE$.int2jvalue(x);
            }
        })).$tilde(JsonDSL$.MODULE$.pair2jvalue(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"indices"), (Object)Predef$.MODULE$.intArrayOps(this.indices()).toSeq()), (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final JsonAST.JArray apply(Traversable<Object> s) {
                return JsonDSL$.MODULE$.seq2jvalue(s, (Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final JsonAST.JValue apply(int x) {
                        return JsonDSL$.MODULE$.int2jvalue(x);
                    }
                });
            }
        }))).$tilde(JsonDSL$.MODULE$.pair2jvalue(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"values"), (Object)Predef$.MODULE$.doubleArrayOps(this.values()).toSeq()), (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final JsonAST.JArray apply(Traversable<Object> s) {
                return JsonDSL$.MODULE$.seq2jvalue(s, (Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final JsonAST.JValue apply(double x) {
                        return JsonDSL$.MODULE$.double2jvalue(x);
                    }
                });
            }
        }));
        return JsonMethods$.MODULE$.compact(JsonMethods$.MODULE$.render((JsonAST.JValue)jValue));
    }

    public SparseVector(int size, int[] indices, double[] values) {
        this.size = size;
        this.indices = indices;
        this.values = values;
        Vector$class.$init$(this);
        Predef$.MODULE$.require(indices.length == values.length, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SparseVector $outer;

            public final String apply() {
                return new StringBuilder().append((Object)"Sparse vectors require that the dimension of the").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" indices match the dimension of the values. You provided ", " indices and "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.indices().length)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" ", " values."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.values().length)}))).toString();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Predef$.MODULE$.require(indices.length <= size, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SparseVector $outer;

            public final String apply() {
                return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"You provided ", " indices and values, "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.indices().length)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"which exceeds the specified vector size ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.size())}))).toString();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }
}

