/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.stat.test;

import org.apache.commons.math3.distribution.NormalDistribution;
import org.apache.commons.math3.distribution.RealDistribution;
import org.apache.commons.math3.stat.inference.KolmogorovSmirnovTest;
import org.apache.spark.Logging;
import org.apache.spark.mllib.stat.test.KolmogorovSmirnovTest$NullHypothesis$;
import org.apache.spark.mllib.stat.test.KolmogorovSmirnovTestResult;
import org.apache.spark.rdd.RDD;
import org.slf4j.Logger;
import scala.Array$;
import scala.Double$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class KolmogorovSmirnovTest$
implements Logging {
    public static final KolmogorovSmirnovTest$ MODULE$;
    private transient Logger org$apache$spark$Logging$$log_;

    static {
        new KolmogorovSmirnovTest$();
    }

    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public KolmogorovSmirnovTestResult testOneSample(RDD<Object> data, String distName, double ... params2) {
        return this.testOneSample(data, distName, (Seq<Object>)Predef$.MODULE$.wrapDoubleArray(params2));
    }

    public KolmogorovSmirnovTestResult testOneSample(RDD<Object> data, Function1<Object, Object> cdf) {
        double n = data.count();
        RDD qual$1 = data.sortBy((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final double apply(double x) {
                return this.apply$mcDD$sp(x);
            }

            public double apply$mcDD$sp(double x) {
                return x;
            }
        }, data.sortBy$default$2(), data.sortBy$default$3(), (Ordering)Ordering.Double$.MODULE$, ClassTag$.MODULE$.Double());
        Serializable x$1 = new Serializable(cdf, n){
            public static final long serialVersionUID = 0L;
            private final Function1 cdf$1;
            private final double n$1;

            public final Iterator<Tuple3<Object, Object, Object>> apply(Iterator<Object> part) {
                Iterator<Tuple2<Object, Object>> partDiffs = KolmogorovSmirnovTest$.MODULE$.org$apache$spark$mllib$stat$test$KolmogorovSmirnovTest$$oneSampleDifferences(part, this.n$1, (Function1<Object, Object>)this.cdf$1);
                return KolmogorovSmirnovTest$.MODULE$.org$apache$spark$mllib$stat$test$KolmogorovSmirnovTest$$searchOneSampleCandidates(partDiffs);
            }
            {
                this.cdf$1 = cdf$1;
                this.n$1 = n$1;
            }
        };
        boolean x$2 = qual$1.mapPartitions$default$2();
        Tuple3[] localData = (Tuple3[])qual$1.mapPartitions((Function1)x$1, x$2, ClassTag$.MODULE$.apply(Tuple3.class)).collect();
        double ksStat = this.searchOneSampleStatistic(localData, n);
        return this.evalOneSampleP(ksStat, (long)n);
    }

    public KolmogorovSmirnovTestResult testOneSample(RDD<Object> data, RealDistribution distObj) {
        Serializable cdf = new Serializable(distObj){
            public static final long serialVersionUID = 0L;
            private final RealDistribution distObj$1;

            public final double apply(double x) {
                return this.apply$mcDD$sp(x);
            }

            public double apply$mcDD$sp(double x) {
                return this.distObj$1.cumulativeProbability(x);
            }
            {
                this.distObj$1 = distObj$1;
            }
        };
        return this.testOneSample(data, (Function1<Object, Object>)cdf);
    }

    public Iterator<Tuple2<Object, Object>> org$apache$spark$mllib$stat$test$KolmogorovSmirnovTest$$oneSampleDifferences(Iterator<Object> partData, double n, Function1<Object, Object> cdf) {
        return partData.zipWithIndex().map((Function1)new Serializable(n, cdf){
            public static final long serialVersionUID = 0L;
            private final double n$2;
            private final Function1 cdf$2;

            public final Tuple2<Object, Object> apply(Tuple2<Object, Object> x0$1) {
                Tuple2<Object, Object> tuple2 = x0$1;
                if (tuple2 != null) {
                    double v = tuple2._1$mcD$sp();
                    int ix = tuple2._2$mcI$sp();
                    double dp = (double)(ix + 1) / this.n$2;
                    double dl = (double)ix / this.n$2;
                    double cdfVal = this.cdf$2.apply$mcDD$sp(v);
                    Tuple2.mcDD.sp sp2 = new Tuple2.mcDD.sp(dl - cdfVal, dp - cdfVal);
                    return sp2;
                }
                throw new MatchError(tuple2);
            }
            {
                this.n$2 = n$2;
                this.cdf$2 = cdf$2;
            }
        });
    }

    public Iterator<Tuple3<Object, Object, Object>> org$apache$spark$mllib$stat$test$KolmogorovSmirnovTest$$searchOneSampleCandidates(Iterator<Tuple2<Object, Object>> partDiffs) {
        Tuple3 pResults;
        Tuple3 initAcc = new Tuple3((Object)BoxesRunTime.boxToDouble((double)Double.MAX_VALUE), (Object)BoxesRunTime.boxToDouble((double)Double$.MODULE$.MinValue()), (Object)BoxesRunTime.boxToDouble((double)0.0));
        Tuple3 tuple3 = pResults = (Tuple3)partDiffs.foldLeft((Object)initAcc, (Function2)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple3<Object, Object, Object> apply(Tuple3<Object, Object, Object> x0$2, Tuple2<Object, Object> x1$1) {
                Tuple2 tuple2 = new Tuple2(x0$2, x1$1);
                if (tuple2 != null) {
                    Tuple3 tuple3 = (Tuple3)tuple2._1();
                    Tuple2 tuple22 = (Tuple2)tuple2._2();
                    if (tuple3 != null) {
                        double pMin = BoxesRunTime.unboxToDouble((Object)tuple3._1());
                        double pMax = BoxesRunTime.unboxToDouble((Object)tuple3._2());
                        double pCt = BoxesRunTime.unboxToDouble((Object)tuple3._3());
                        if (tuple22 != null) {
                            double dl = tuple22._1$mcD$sp();
                            double dp = tuple22._2$mcD$sp();
                            Tuple3 tuple32 = new Tuple3((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.min(pMin, dl)), (Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.max(pMax, dp)), (Object)BoxesRunTime.boxToDouble((double)(pCt + 1.0)));
                            return tuple32;
                        }
                    }
                }
                throw new MatchError((Object)tuple2);
            }
        });
        Tuple3 tuple32 = initAcc;
        Tuple3[] results = !(tuple3 != null ? !tuple3.equals(tuple32) : tuple32 != null) ? (Tuple3[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(Tuple3.class)) : (Tuple3[])((Object[])new Tuple3[]{pResults});
        return Predef$.MODULE$.refArrayOps((Object[])results).iterator();
    }

    private double searchOneSampleStatistic(Tuple3<Object, Object, Object>[] localData, double n) {
        Tuple2.mcDD.sp initAcc = new Tuple2.mcDD.sp(Double$.MODULE$.MinValue(), 0.0);
        Tuple2 results = (Tuple2)Predef$.MODULE$.refArrayOps((Object[])localData).foldLeft((Object)initAcc, (Function2)new Serializable(n){
            public static final long serialVersionUID = 0L;
            private final double n$3;

            public final Tuple2<Object, Object> apply(Tuple2<Object, Object> x0$3, Tuple3<Object, Object, Object> x1$2) {
                Tuple2 tuple2 = new Tuple2(x0$3, x1$2);
                if (tuple2 != null) {
                    Tuple2 tuple22 = (Tuple2)tuple2._1();
                    Tuple3 tuple3 = (Tuple3)tuple2._2();
                    if (tuple22 != null) {
                        double prevMax = tuple22._1$mcD$sp();
                        double prevCt = tuple22._2$mcD$sp();
                        if (tuple3 != null) {
                            double minCand = BoxesRunTime.unboxToDouble((Object)tuple3._1());
                            double maxCand = BoxesRunTime.unboxToDouble((Object)tuple3._2());
                            double ct = BoxesRunTime.unboxToDouble((Object)tuple3._3());
                            double adjConst = prevCt / this.n$3;
                            double dist1 = package$.MODULE$.abs(minCand + adjConst);
                            double dist2 = package$.MODULE$.abs(maxCand + adjConst);
                            double maxVal = BoxesRunTime.unboxToDouble((Object)Predef$.MODULE$.doubleArrayOps(new double[]{prevMax, dist1, dist2}).max((Ordering)Ordering.Double$.MODULE$));
                            Tuple2.mcDD.sp sp2 = new Tuple2.mcDD.sp(maxVal, prevCt + ct);
                            return sp2;
                        }
                    }
                }
                throw new MatchError((Object)tuple2);
            }
            {
                this.n$3 = n$3;
            }
        });
        return results._1$mcD$sp();
    }

    public KolmogorovSmirnovTestResult testOneSample(RDD<Object> data, String distName, Seq<Object> params2) {
        String string = distName;
        if ("norm".equals(string)) {
            NormalDistribution normalDistribution;
            NormalDistribution normalDistribution2;
            if (params2.nonEmpty()) {
                Predef$.MODULE$.require(params2.length() == 2, (Function0)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "Normal distribution requires mean and standard deviation as parameters";
                    }
                });
                normalDistribution2 = new NormalDistribution(BoxesRunTime.unboxToDouble((Object)params2.apply(0)), BoxesRunTime.unboxToDouble((Object)params2.apply(1)));
            } else {
                this.logInfo((Function0<String>)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "No parameters specified for normal distribution,initialized to standard normal (i.e. N(0, 1))";
                    }
                });
                normalDistribution2 = new NormalDistribution(0.0, 1.0);
            }
            NormalDistribution distObj = normalDistribution = normalDistribution2;
            return this.testOneSample(data, (RealDistribution)distObj);
        }
        throw new UnsupportedOperationException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " not yet supported through"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{distName}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" convenience method. Current options are:['norm']."})).s((Seq)Nil$.MODULE$)).toString());
    }

    private KolmogorovSmirnovTestResult evalOneSampleP(double ksStat, long n) {
        double pval = 1.0 - new KolmogorovSmirnovTest().cdf(ksStat, (int)n);
        return new KolmogorovSmirnovTestResult(pval, ksStat, KolmogorovSmirnovTest$NullHypothesis$.MODULE$.OneSampleTwoSided().toString());
    }

    private KolmogorovSmirnovTest$() {
        MODULE$ = this;
        Logging.class.$init$((Logging)this);
    }
}

