/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.clustering;

import java.io.OutputStream;
import org.apache.spark.SparkContext;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.mllib.clustering.KMeans$;
import org.apache.spark.mllib.clustering.KMeansModel$;
import org.apache.spark.mllib.clustering.KMeansModel$SaveLoadV1_0$;
import org.apache.spark.mllib.clustering.VectorWithNorm;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.pmml.PMMLExportable;
import org.apache.spark.mllib.pmml.PMMLExportable$class;
import org.apache.spark.mllib.util.Saveable;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import scala.Array$;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.TraversableOnce;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0001\tEf\u0001B\u0001\u0003\u00015\u00111bS'fC:\u001cXj\u001c3fY*\u00111\u0001B\u0001\u000bG2,8\u000f^3sS:<'BA\u0003\u0007\u0003\u0015iG\u000e\\5c\u0015\t9\u0001\"A\u0003ta\u0006\u00148N\u0003\u0002\n\u0015\u00051\u0011\r]1dQ\u0016T\u0011aC\u0001\u0004_J<7\u0001A\n\u0006\u00019!\"$\b\t\u0003\u001fIi\u0011\u0001\u0005\u0006\u0002#\u0005)1oY1mC&\u00111\u0003\u0005\u0002\u0007\u0003:L(+\u001a4\u0011\u0005UAR\"\u0001\f\u000b\u0005]!\u0011\u0001B;uS2L!!\u0007\f\u0003\u0011M\u000bg/Z1cY\u0016\u0004\"aD\u000e\n\u0005q\u0001\"\u0001D*fe&\fG.\u001b>bE2,\u0007C\u0001\u0010\"\u001b\u0005y\"B\u0001\u0011\u0005\u0003\u0011\u0001X.\u001c7\n\u0005\tz\"A\u0004)N\u001b2+\u0005\u0010]8si\u0006\u0014G.\u001a\u0005\tI\u0001\u0011)\u0019!C\u0001K\u0005q1\r\\;ti\u0016\u00148)\u001a8uKJ\u001cX#\u0001\u0014\u0011\u0007=9\u0013&\u0003\u0002)!\t)\u0011I\u001d:bsB\u0011!&L\u0007\u0002W)\u0011A\u0006B\u0001\u0007Y&t\u0017\r\\4\n\u00059Z#A\u0002,fGR|'\u000fK\u0002$aY\u0002\"!\r\u001b\u000e\u0003IR!a\r\u0004\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u00026e\t)1+\u001b8dK\u0006\nq'A\u00032]Ar\u0003\u0007\u0003\u0005:\u0001\t\u0005\t\u0015!\u0003'\u0003=\u0019G.^:uKJ\u001cUM\u001c;feN\u0004\u0003f\u0001\u001d1m!)A\b\u0001C\u0001{\u00051A(\u001b8jiz\"\"A\u0010!\u0011\u0005}\u0002Q\"\u0001\u0002\t\u000b\u0011Z\u0004\u0019\u0001\u0014)\u0007\u0001\u0003d\u0007K\u0002<a\r\u000b\u0013\u0001R\u0001\u0006c9\nd\u0006\r\u0005\u0006y\u0001!\tA\u0012\u000b\u0003}\u001dCQ\u0001S#A\u0002%\u000bqaY3oi\u0016\u00148\u000fE\u0002K\u001f&j\u0011a\u0013\u0006\u0003\u00196\u000bA\u0001\\1oO*\ta*\u0001\u0003kCZ\f\u0017B\u0001)L\u0005!IE/\u001a:bE2,\u0007fA#1%\u0006\n1+A\u00032]Qr\u0003\u0007C\u0003V\u0001\u0011\u0005a+A\u0001l+\u00059\u0006CA\bY\u0013\tI\u0006CA\u0002J]RD3\u0001\u0016\u0019\\C\u0005a\u0016!\u0002\u0019/q9\u0002\u0004\"\u00020\u0001\t\u0003y\u0016a\u00029sK\u0012L7\r\u001e\u000b\u0003/\u0002DQ!Y/A\u0002%\nQ\u0001]8j]RD3!\u0018\u0019\\\u0011\u0015q\u0006\u0001\"\u0001e)\t)7\u000eE\u0002gS^k\u0011a\u001a\u0006\u0003Q\u001a\t1A\u001d3e\u0013\tQwMA\u0002S\t\u0012CQ\u0001\\2A\u00025\fa\u0001]8j]R\u001c\bc\u00014jS!\u001a1\r\r\u001c\t\u000by\u0003A\u0011\u00019\u0015\u0005E\\\bc\u0001:wq6\t1O\u0003\u0002Oi*\u0011QOB\u0001\u0004CBL\u0017BA<t\u0005\u001dQ\u0015M^1S\t\u0012\u0003\"AS=\n\u0005i\\%aB%oi\u0016<WM\u001d\u0005\u0006Y>\u0004\r\u0001 \t\u0004eZL\u0003fA81m!1q\u0010\u0001C\u0001\u0003\u0003\t1bY8naV$XmQ8tiR!\u00111AA\u0005!\ry\u0011QA\u0005\u0004\u0003\u000f\u0001\"A\u0002#pk\ndW\r\u0003\u0004\u0002\fy\u0004\r!\\\u0001\u0005I\u0006$\u0018\rK\u0002\u007famCq!!\u0005\u0001\t\u0013\t\u0019\"\u0001\fdYV\u001cH/\u001a:DK:$XM]:XSRDgj\u001c:n+\t\t)\u0002\u0005\u0004\u0002\u0018\u0005\u001d\u00121\u0006\b\u0005\u00033\t\u0019C\u0004\u0003\u0002\u001c\u0005\u0005RBAA\u000f\u0015\r\ty\u0002D\u0001\u0007yI|w\u000e\u001e \n\u0003EI1!!\n\u0011\u0003\u001d\u0001\u0018mY6bO\u0016L1\u0001UA\u0015\u0015\r\t)\u0003\u0005\t\u0004\u007f\u00055\u0012bAA\u0018\u0005\tqa+Z2u_J<\u0016\u000e\u001e5O_Jl\u0007bBA\u001a\u0001\u0011\u0005\u0013QG\u0001\u0005g\u00064X\r\u0006\u0004\u00028\u0005u\u0012\u0011\n\t\u0004\u001f\u0005e\u0012bAA\u001e!\t!QK\\5u\u0011!\ty$!\rA\u0002\u0005\u0005\u0013AA:d!\u0011\t\u0019%!\u0012\u000e\u0003\u0019I1!a\u0012\u0007\u00051\u0019\u0006/\u0019:l\u0007>tG/\u001a=u\u0011!\tY%!\rA\u0002\u00055\u0013\u0001\u00029bi\"\u0004B!a\u0014\u0002V9\u0019q\"!\u0015\n\u0007\u0005M\u0003#\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003/\nIF\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003'\u0002\u0002\u0006BA\u0019aICq!a\u0018\u0001\t#\n\t'A\u0007g_Jl\u0017\r\u001e,feNLwN\\\u000b\u0003\u0003\u001bB3\u0001\u0001\u0019\\\u000f\u001d\t9G\u0001E\u0001\u0003S\n1bS'fC:\u001cXj\u001c3fYB\u0019q(a\u001b\u0007\r\u0005\u0011\u0001\u0012AA7'\u0019\tYGDA85A!Q#!\u001d?\u0013\r\t\u0019H\u0006\u0002\u0007\u0019>\fG-\u001a:\t\u000fq\nY\u0007\"\u0001\u0002xQ\u0011\u0011\u0011\u000e\u0005\t\u0003w\nY\u0007\"\u0011\u0002~\u0005!An\\1e)\u0015q\u0014qPAA\u0011!\ty$!\u001fA\u0002\u0005\u0005\u0003\u0002CA&\u0003s\u0002\r!!\u0014)\t\u0005e\u0004G\u0015\u0004\b\u0003\u000f\u000bY\u0007RAE\u0005\u001d\u0019E.^:uKJ\u001cb!!\"\u000f\u0003\u0017S\u0002cA\b\u0002\u000e&\u0019\u0011q\u0012\t\u0003\u000fA\u0013x\u000eZ;di\"Q\u00111SAC\u0005+\u0007I\u0011\u0001,\u0002\u0005%$\u0007BCAL\u0003\u000b\u0013\t\u0012)A\u0005/\u0006\u0019\u0011\u000e\u001a\u0011\t\u0015\u0005\f)I!f\u0001\n\u0003\tY*F\u0001*\u0011)\ty*!\"\u0003\u0012\u0003\u0006I!K\u0001\u0007a>Lg\u000e\u001e\u0011\t\u000fq\n)\t\"\u0001\u0002$R1\u0011QUAU\u0003W\u0003B!a*\u0002\u00066\u0011\u00111\u000e\u0005\b\u0003'\u000b\t\u000b1\u0001X\u0011\u0019\t\u0017\u0011\u0015a\u0001S!Q\u0011qVAC\u0003\u0003%\t!!-\u0002\t\r|\u0007/\u001f\u000b\u0007\u0003K\u000b\u0019,!.\t\u0013\u0005M\u0015Q\u0016I\u0001\u0002\u00049\u0006\u0002C1\u0002.B\u0005\t\u0019A\u0015\t\u0015\u0005e\u0016QQI\u0001\n\u0003\tY,\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u0005u&fA,\u0002@.\u0012\u0011\u0011\u0019\t\u0005\u0003\u0007\fY-\u0004\u0002\u0002F*!\u0011qYAe\u0003%)hn\u00195fG.,GM\u0003\u00024!%!\u0011QZAc\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a\u0005\u000b\u0003#\f))%A\u0005\u0002\u0005M\u0017AD2paf$C-\u001a4bk2$HEM\u000b\u0003\u0003+T3!KA`\u0011)\tI.!\"\u0002\u0002\u0013\u0005\u00131\\\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\u0005u\u0007c\u0001&\u0002`&\u0019\u0011qK&\t\u0013\u0005\r\u0018QQA\u0001\n\u00031\u0016\u0001\u00049s_\u0012,8\r^!sSRL\bBCAt\u0003\u000b\u000b\t\u0011\"\u0001\u0002j\u0006q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003BAv\u0003c\u00042aDAw\u0013\r\ty\u000f\u0005\u0002\u0004\u0003:L\b\"CAz\u0003K\f\t\u00111\u0001X\u0003\rAH%\r\u0005\u000b\u0003o\f))!A\u0005B\u0005e\u0018a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u0005m\bCBA\u007f\u0005\u0007\tY/\u0004\u0002\u0002\u0000*\u0019!\u0011\u0001\t\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0003\u0006\u0005}(\u0001C%uKJ\fGo\u001c:\t\u0015\t%\u0011QQA\u0001\n\u0003\u0011Y!\u0001\u0005dC:,\u0015/^1m)\u0011\u0011iAa\u0005\u0011\u0007=\u0011y!C\u0002\u0003\u0012A\u0011qAQ8pY\u0016\fg\u000e\u0003\u0006\u0002t\n\u001d\u0011\u0011!a\u0001\u0003WD!Ba\u0006\u0002\u0006\u0006\u0005I\u0011\tB\r\u0003!A\u0017m\u001d5D_\u0012,G#A,\t\u0015\tu\u0011QQA\u0001\n\u0003\u0012y\"\u0001\u0005u_N#(/\u001b8h)\t\ti\u000e\u0003\u0006\u0003$\u0005\u0015\u0015\u0011!C!\u0005K\ta!Z9vC2\u001cH\u0003\u0002B\u0007\u0005OA!\"a=\u0003\"\u0005\u0005\t\u0019AAv\u000f!\u0011Y#a\u001b\t\n\t5\u0012aB\"mkN$XM\u001d\t\u0005\u0003O\u0013yC\u0002\u0005\u0002\b\u0006-\u0004\u0012\u0002B\u0019'\u0011\u0011yC\u0004\u000e\t\u000fq\u0012y\u0003\"\u0001\u00036Q\u0011!Q\u0006\u0005\t\u0005s\u0011y\u0003\"\u0001\u0003<\u0005)\u0011\r\u001d9msR!\u0011Q\u0015B\u001f\u0011!\u0011yDa\u000eA\u0002\t\u0005\u0013!\u0001:\u0011\t\t\r#\u0011J\u0007\u0003\u0005\u000bR1Aa\u0012\u0007\u0003\r\u0019\u0018\u000f\\\u0005\u0005\u0005\u0017\u0012)EA\u0002S_^D!B!\u000f\u00030\u0005\u0005I\u0011\u0011B()\u0019\t)K!\u0015\u0003T!9\u00111\u0013B'\u0001\u00049\u0006BB1\u0003N\u0001\u0007\u0011\u0006\u0003\u0006\u0003X\t=\u0012\u0011!CA\u00053\nq!\u001e8baBd\u0017\u0010\u0006\u0003\u0003\\\t\u001d\u0004#B\b\u0003^\t\u0005\u0014b\u0001B0!\t1q\n\u001d;j_:\u0004Ra\u0004B2/&J1A!\u001a\u0011\u0005\u0019!V\u000f\u001d7fe!Q!\u0011\u000eB+\u0003\u0003\u0005\r!!*\u0002\u0007a$\u0003\u0007\u0003\u0006\u0003n\t=\u0012\u0011!C\u0005\u0005_\n1B]3bIJ+7o\u001c7wKR\u0011!\u0011\u000f\t\u0004\u0015\nM\u0014b\u0001B;\u0017\n1qJ\u00196fGR<\u0011B!\u001f\u0002l!\u0005!Aa\u001f\u0002\u0019M\u000bg/\u001a'pC\u00124\u0016g\u0018\u0019\u0011\t\u0005\u001d&Q\u0010\u0004\n\u0005\u007f\nY\u0007#\u0001\u0003\u0005\u0003\u0013AbU1wK2{\u0017\r\u001a,2?B\u001a2A! \u000f\u0011\u001da$Q\u0010C\u0001\u0005\u000b#\"Aa\u001f\t\u0015\t%%Q\u0010b\u0001\n\u0013\tY.A\tuQ&\u001chi\u001c:nCR4VM]:j_:D\u0011B!$\u0003~\u0001\u0006I!!8\u0002%QD\u0017n\u001d$pe6\fGOV3sg&|g\u000e\t\u0005\f\u0005#\u0013iH1A\u0005\u0002\t\tY.A\u0007uQ&\u001c8\t\\1tg:\u000bW.\u001a\u0005\n\u0005+\u0013i\b)A\u0005\u0003;\fa\u0002\u001e5jg\u000ec\u0017m]:OC6,\u0007\u0005\u0003\u0005\u00024\tuD\u0011\u0001BM)!\t9Da'\u0003\u001e\n\u0005\u0006\u0002CA \u0005/\u0003\r!!\u0011\t\u000f\t}%q\u0013a\u0001}\u0005)Qn\u001c3fY\"A\u00111\nBL\u0001\u0004\ti\u0005\u0003\u0005\u0002|\tuD\u0011\u0001BS)\u0015q$q\u0015BU\u0011!\tyDa)A\u0002\u0005\u0005\u0003\u0002CA&\u0005G\u0003\r!!\u0014\t\u0015\t5\u00141NA\u0001\n\u0013\u0011y\u0007\u000b\u0003\u0002lA\u0012\u0006\u0006BA3aI\u0003")
public class KMeansModel
implements Saveable,
Serializable,
PMMLExportable {
    private final Vector[] clusterCenters;

    public static KMeansModel load(SparkContext sparkContext, String string) {
        return KMeansModel$.MODULE$.load(sparkContext, string);
    }

    @Override
    public void toPMML(String localPath) {
        PMMLExportable$class.toPMML((PMMLExportable)this, localPath);
    }

    @Override
    public void toPMML(SparkContext sc, String path) {
        PMMLExportable$class.toPMML(this, sc, path);
    }

    @Override
    public void toPMML(OutputStream outputStream) {
        PMMLExportable$class.toPMML((PMMLExportable)this, outputStream);
    }

    @Override
    public String toPMML() {
        return PMMLExportable$class.toPMML(this);
    }

    public Vector[] clusterCenters() {
        return this.clusterCenters;
    }

    public int k() {
        return this.clusterCenters().length;
    }

    public int predict(Vector point) {
        return KMeans$.MODULE$.findClosest((TraversableOnce<VectorWithNorm>)this.clusterCentersWithNorm(), new VectorWithNorm(point))._1$mcI$sp();
    }

    public RDD<Object> predict(RDD<Vector> points) {
        Iterable<VectorWithNorm> centersWithNorm = this.clusterCentersWithNorm();
        Broadcast bcCentersWithNorm = points.context().broadcast(centersWithNorm, ClassTag$.MODULE$.apply(Iterable.class));
        return points.map((Function1)new Serializable(this, bcCentersWithNorm){
            public static final long serialVersionUID = 0L;
            private final Broadcast bcCentersWithNorm$1;

            public final int apply(Vector p) {
                return KMeans$.MODULE$.findClosest((TraversableOnce<VectorWithNorm>)((TraversableOnce)this.bcCentersWithNorm$1.value()), new VectorWithNorm(p))._1$mcI$sp();
            }
            {
                this.bcCentersWithNorm$1 = bcCentersWithNorm$1;
            }
        }, ClassTag$.MODULE$.Int());
    }

    public JavaRDD<Integer> predict(JavaRDD<Vector> points) {
        return this.predict((RDD<Vector>)points.rdd()).toJavaRDD();
    }

    public double computeCost(RDD<Vector> data) {
        Iterable<VectorWithNorm> centersWithNorm = this.clusterCentersWithNorm();
        Broadcast bcCentersWithNorm = data.context().broadcast(centersWithNorm, ClassTag$.MODULE$.apply(Iterable.class));
        return RDD$.MODULE$.doubleRDDToDoubleRDDFunctions(data.map((Function1)new Serializable(this, bcCentersWithNorm){
            public static final long serialVersionUID = 0L;
            private final Broadcast bcCentersWithNorm$2;

            public final double apply(Vector p) {
                return KMeans$.MODULE$.pointCost((TraversableOnce<VectorWithNorm>)((TraversableOnce)this.bcCentersWithNorm$2.value()), new VectorWithNorm(p));
            }
            {
                this.bcCentersWithNorm$2 = bcCentersWithNorm$2;
            }
        }, ClassTag$.MODULE$.Double())).sum();
    }

    private Iterable<VectorWithNorm> clusterCentersWithNorm() {
        return (Iterable)Predef$.MODULE$.refArrayOps((Object[])this.clusterCenters()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final VectorWithNorm apply(Vector x$1) {
                return new VectorWithNorm(x$1);
            }
        }, Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()));
    }

    @Override
    public void save(SparkContext sc, String path) {
        KMeansModel$SaveLoadV1_0$.MODULE$.save(sc, this, path);
    }

    @Override
    public String formatVersion() {
        return "1.0";
    }

    public KMeansModel(Vector[] clusterCenters2) {
        this.clusterCenters = clusterCenters2;
        PMMLExportable$class.$init$(this);
    }

    public KMeansModel(java.lang.Iterable<Vector> centers) {
        this((Vector[])((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(centers).asScala()).toArray(ClassTag$.MODULE$.apply(Vector.class)));
    }

    public static class Cluster
    implements Product,
    Serializable {
        private final int id;
        private final Vector point;

        public int id() {
            return this.id;
        }

        public Vector point() {
            return this.point;
        }

        public Cluster copy(int id, Vector point) {
            return new Cluster(id, point);
        }

        public int copy$default$1() {
            return this.id();
        }

        public Vector copy$default$2() {
            return this.point();
        }

        public String productPrefix() {
            return "Cluster";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
                case 1: {
                    object = this.point();
                    break;
                }
                case 0: {
                    object = BoxesRunTime.boxToInteger((int)this.id());
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof Cluster;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.id());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.point()));
            return Statics.finalizeHash((int)n, (int)2);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof Cluster)) return false;
            boolean bl = true;
            if (!bl) return false;
            Cluster cluster = (Cluster)x$1;
            if (this.id() != cluster.id()) return false;
            Vector vector = this.point();
            Vector vector2 = cluster.point();
            if (vector == null) {
                if (vector2 != null) {
                    return false;
                }
            } else if (!((Object)vector).equals(vector2)) return false;
            if (!cluster.canEqual(this)) return false;
            return true;
        }

        public Cluster(int id, Vector point) {
            this.id = id;
            this.point = point;
            Product.class.$init$((Product)this);
        }
    }
}

