/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.extensions.markup.html.form.select;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.wicket.Component;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.extensions.markup.html.form.select.SelectOption;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.model.IModel;
import org.apache.wicket.util.lang.Objects;
import org.apache.wicket.util.string.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Select<T>
extends FormComponent<T> {
    private static final long serialVersionUID = 1L;

    public Select(String id) {
        super(id);
    }

    public Select(String id, IModel<T> model) {
        super(id, model);
    }

    protected void convertInput() {
        boolean supportsMultiple = this.getDefaultModelObject() instanceof Collection;
        String[] values = this.getInputAsArray();
        if (values == null || values.length == 0) {
            this.setConvertedInput(null);
            return;
        }
        if (!supportsMultiple && values.length > 1) {
            throw new WicketRuntimeException("The model of Select component [" + this.getPath() + "] is not of type java.util.Collection, but more then one SelectOption component has been selected. Either remove the multiple attribute from the select tag or make the model of the Select component a collection");
        }
        ArrayList<Object> converted = new ArrayList<Object>(values.length);
        for (int i = 0; i < values.length; ++i) {
            final String value = values[i];
            if (Strings.isEmpty((CharSequence)value)) continue;
            SelectOption option = (SelectOption)((Object)this.visitChildren(SelectOption.class, new Component.IVisitor<SelectOption<T>>(){

                public Object component(SelectOption<T> option) {
                    if (String.valueOf(option.getValue()).equals(value)) {
                        return option;
                    }
                    return CONTINUE_TRAVERSAL;
                }
            }));
            if (option == null) {
                throw new WicketRuntimeException("submitted http post value [" + Strings.join((String)",", (String[])values) + "] for SelectOption component [" + this.getPath() + "] contains an illegal value [" + value + "] which does not point to a SelectOption component. Due to this the Select component cannot resolve the selected SelectOption component pointed to by the illegal value. A possible reason is that component hierarchy changed between rendering and form submission.");
            }
            converted.add(option.getDefaultModelObject());
        }
        if (converted.isEmpty()) {
            this.setConvertedInput(null);
        } else if (!supportsMultiple) {
            this.setConvertedInput(converted.get(0));
        } else {
            this.setConvertedInput(converted);
        }
    }

    public void updateModel() {
        Object object = this.getModelObject();
        boolean supportsMultiple = object instanceof Collection;
        Object converted = this.getConvertedInput();
        if (supportsMultiple) {
            Collection modelCollection = (Collection)object;
            this.modelChanging();
            modelCollection.clear();
            if (converted != null) {
                modelCollection.addAll((Collection)converted);
            }
            this.modelChanged();
            this.setDefaultModelObject(modelCollection);
        } else {
            this.setDefaultModelObject(converted);
        }
    }

    boolean isSelected(SelectOption<?> option) {
        if (this.hasRawInput()) {
            String raw = this.getRawInput();
            if (!Strings.isEmpty((CharSequence)raw)) {
                String[] values = raw.split(VALUE_SEPARATOR);
                for (int i = 0; i < values.length; ++i) {
                    String value = values[i];
                    if (!value.equals(option.getValue())) continue;
                    return true;
                }
            }
            return false;
        }
        return this.compareModels(this.getDefaultModelObject(), option.getDefaultModelObject());
    }

    private boolean compareModels(Object selected, Object value) {
        if (selected != null && selected instanceof Collection) {
            if (value instanceof Collection) {
                return ((Collection)selected).containsAll((Collection)value);
            }
            return ((Collection)selected).contains(value);
        }
        return Objects.equal((Object)selected, (Object)value);
    }
}

