/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wss4j.dom.common;

import java.io.IOException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.apache.wss4j.common.crypto.Crypto;
import org.apache.wss4j.common.crypto.CryptoFactory;
import org.apache.wss4j.common.crypto.CryptoType;
import org.apache.wss4j.common.saml.SAMLCallback;
import org.apache.wss4j.common.saml.bean.KeyInfoBean;
import org.apache.wss4j.common.saml.bean.SubjectBean;
import org.apache.wss4j.dom.common.AbstractSAMLCallbackHandler;
import org.opensaml.common.SAMLVersion;

public class SAML2CallbackHandler
extends AbstractSAMLCallbackHandler {
    public SAML2CallbackHandler() throws Exception {
        if (this.certs == null) {
            Crypto crypto = CryptoFactory.getInstance((String)"wss40.properties");
            CryptoType cryptoType = new CryptoType(CryptoType.TYPE.ALIAS);
            cryptoType.setAlias("wss40");
            this.certs = crypto.getX509Certificates(cryptoType);
        }
        this.subjectName = "uid=joe,ou=people,ou=saml-demo,o=example.com";
        this.subjectQualifier = "www.example.com";
        this.confirmationMethod = "urn:oasis:names:tc:SAML:2.0:cm:sender-vouches";
    }

    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        for (int i = 0; i < callbacks.length; ++i) {
            SubjectBean subjectBean;
            SAMLCallback callback;
            if (callbacks[i] instanceof SAMLCallback) {
                callback = (SAMLCallback)callbacks[i];
                callback.setSamlVersion(SAMLVersion.VERSION_20);
                callback.setIssuer(this.issuer);
                if (this.conditions != null) {
                    callback.setConditions(this.conditions);
                }
                subjectBean = new SubjectBean(this.subjectName, this.subjectQualifier, this.confirmationMethod);
                if (this.subjectNameIDFormat != null) {
                    subjectBean.setSubjectNameIDFormat(this.subjectNameIDFormat);
                }
                subjectBean.setSubjectConfirmationData(this.subjectConfirmationData);
                if ("urn:oasis:names:tc:SAML:2.0:cm:holder-of-key".equals(this.confirmationMethod)) {
                    try {
                        KeyInfoBean keyInfo = this.createKeyInfo();
                        subjectBean.setKeyInfo(keyInfo);
                    }
                    catch (Exception ex) {
                        throw new IOException("Problem creating KeyInfo: " + ex.getMessage());
                    }
                }
            } else {
                throw new UnsupportedCallbackException(callbacks[i], "Unrecognized Callback");
            }
            callback.setSubject(subjectBean);
            this.createAndSetStatement(null, callback);
        }
    }
}

