/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wss4j.dom.common;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.apache.wss4j.common.ext.WSPasswordCallback;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.dom.util.WSSecurityUtil;
import org.apache.xml.security.utils.Base64;

public class SecretKeyCallbackHandler
implements CallbackHandler {
    private Map<String, byte[]> secrets = new HashMap<String, byte[]>();
    private byte[] outboundSecret = null;

    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        for (int i = 0; i < callbacks.length; ++i) {
            if (callbacks[i] instanceof WSPasswordCallback) {
                WSPasswordCallback pc = (WSPasswordCallback)callbacks[i];
                if (pc.getUsage() != 9 && pc.getUsage() != 6) continue;
                byte[] secret = this.secrets.get(pc.getIdentifier());
                if (secret == null) {
                    secret = this.outboundSecret;
                }
                pc.setKey(secret);
                break;
            }
            throw new UnsupportedCallbackException(callbacks[i], "Unrecognized Callback");
        }
    }

    public void addSecretKey(String identifier, byte[] secretKey) {
        this.secrets.put(identifier, secretKey);
    }

    public void setOutboundSecret(byte[] secret) throws WSSecurityException {
        this.outboundSecret = secret;
        byte[] encodedBytes = WSSecurityUtil.generateDigest((byte[])this.outboundSecret);
        String identifier = Base64.encode((byte[])encodedBytes);
        this.addSecretKey(identifier, this.outboundSecret);
    }
}

