/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wss4j.dom.components.crypto;

import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.List;
import javax.security.auth.callback.CallbackHandler;
import org.apache.wss4j.common.bsp.BSPRule;
import org.apache.wss4j.common.crypto.CertificateStore;
import org.apache.wss4j.common.crypto.Crypto;
import org.apache.wss4j.common.crypto.CryptoFactory;
import org.apache.wss4j.common.crypto.CryptoType;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.common.util.XMLUtils;
import org.apache.wss4j.dom.WSSConfig;
import org.apache.wss4j.dom.WSSecurityEngine;
import org.apache.wss4j.dom.WSSecurityEngineResult;
import org.apache.wss4j.dom.common.KeystoreCallbackHandler;
import org.apache.wss4j.dom.common.SOAPUtil;
import org.apache.wss4j.dom.common.SecurityTestUtil;
import org.apache.wss4j.dom.handler.RequestData;
import org.apache.wss4j.dom.message.WSSecHeader;
import org.apache.wss4j.dom.message.WSSecSignature;
import org.apache.wss4j.dom.util.WSSecurityUtil;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public class CertificateStoreTest
extends Assert {
    private static final Logger LOG = LoggerFactory.getLogger(CertificateStoreTest.class);
    private WSSecurityEngine secEngine = new WSSecurityEngine();
    private Crypto senderCrypto = CryptoFactory.getInstance((String)"wss40.properties");
    private Crypto receiverCrypto = null;
    private CallbackHandler keystoreCallbackHandler = new KeystoreCallbackHandler();

    @AfterClass
    public static void cleanup() throws Exception {
        SecurityTestUtil.cleanup();
    }

    public CertificateStoreTest() throws Exception {
        CryptoType cryptoType = new CryptoType(CryptoType.TYPE.ALIAS);
        cryptoType.setAlias("wss40");
        X509Certificate[] certs = this.senderCrypto.getX509Certificates(cryptoType);
        this.receiverCrypto = new CertificateStore(certs);
        WSSConfig.init();
    }

    @Test
    public void testSignatureDirectReference() throws Exception {
        List<WSSecurityEngineResult> results;
        WSSecurityEngineResult result;
        X509Certificate cert;
        WSSecSignature sign = new WSSecSignature();
        sign.setUserInfo("wss40", "security");
        sign.setKeyIdentifierType(1);
        Document doc = SOAPUtil.toSOAPPart("<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader();
        secHeader.insertSecurityHeader(doc);
        Document signedDoc = sign.build(doc, this.senderCrypto, secHeader);
        if (LOG.isDebugEnabled()) {
            String outputString = XMLUtils.PrettyDocumentToString((Document)signedDoc);
            LOG.debug(outputString);
        }
        CertificateStoreTest.assertTrue(((cert = (X509Certificate)(result = WSSecurityUtil.fetchActionResult(results = this.verify(signedDoc, this.receiverCrypto), (int)2)).get((Object)"x509-certificate")) != null ? 1 : 0) != 0);
    }

    @Test
    public void testSignatureX509() throws Exception {
        WSSecSignature sign = new WSSecSignature();
        sign.setUserInfo("wss40", "security");
        sign.setKeyIdentifierType(3);
        Document doc = SOAPUtil.toSOAPPart("<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader();
        secHeader.insertSecurityHeader(doc);
        Document signedDoc = sign.build(doc, this.senderCrypto, secHeader);
        if (LOG.isDebugEnabled()) {
            String outputString = XMLUtils.PrettyDocumentToString((Document)signedDoc);
            LOG.debug(outputString);
        }
        WSSecurityEngine newEngine = new WSSecurityEngine();
        RequestData data = new RequestData();
        data.setCallbackHandler(this.keystoreCallbackHandler);
        data.setSigVerCrypto(this.receiverCrypto);
        data.setIgnoredBSPRules(Collections.singletonList(BSPRule.R3063));
        List results = newEngine.processSecurityHeader(signedDoc, "", data);
        WSSecurityEngineResult result = WSSecurityUtil.fetchActionResult((List)results, (int)2);
        X509Certificate cert = (X509Certificate)result.get((Object)"x509-certificate");
        CertificateStoreTest.assertTrue((cert != null ? 1 : 0) != 0);
    }

    @Test
    public void testSignatureIssuerSerial() throws Exception {
        List<WSSecurityEngineResult> results;
        WSSecurityEngineResult result;
        X509Certificate cert;
        WSSecSignature sign = new WSSecSignature();
        sign.setUserInfo("wss40", "security");
        sign.setKeyIdentifierType(2);
        Document doc = SOAPUtil.toSOAPPart("<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader();
        secHeader.insertSecurityHeader(doc);
        Document signedDoc = sign.build(doc, this.senderCrypto, secHeader);
        if (LOG.isDebugEnabled()) {
            String outputString = XMLUtils.PrettyDocumentToString((Document)signedDoc);
            LOG.debug(outputString);
        }
        CertificateStoreTest.assertTrue(((cert = (X509Certificate)(result = WSSecurityUtil.fetchActionResult(results = this.verify(signedDoc, this.receiverCrypto), (int)2)).get((Object)"x509-certificate")) != null ? 1 : 0) != 0);
    }

    @Test
    public void testSignatureThumbprint() throws Exception {
        List<WSSecurityEngineResult> results;
        WSSecurityEngineResult result;
        X509Certificate cert;
        WSSecSignature sign = new WSSecSignature();
        sign.setUserInfo("wss40", "security");
        sign.setKeyIdentifierType(8);
        Document doc = SOAPUtil.toSOAPPart("<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader();
        secHeader.insertSecurityHeader(doc);
        Document signedDoc = sign.build(doc, this.senderCrypto, secHeader);
        if (LOG.isDebugEnabled()) {
            String outputString = XMLUtils.PrettyDocumentToString((Document)signedDoc);
            LOG.debug(outputString);
        }
        CertificateStoreTest.assertTrue(((cert = (X509Certificate)(result = WSSecurityUtil.fetchActionResult(results = this.verify(signedDoc, this.receiverCrypto), (int)2)).get((Object)"x509-certificate")) != null ? 1 : 0) != 0);
    }

    @Test
    public void testSignatureSKI() throws Exception {
        List<WSSecurityEngineResult> results;
        WSSecurityEngineResult result;
        X509Certificate cert;
        WSSecSignature sign = new WSSecSignature();
        sign.setUserInfo("wss40", "security");
        sign.setKeyIdentifierType(4);
        Document doc = SOAPUtil.toSOAPPart("<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader();
        secHeader.insertSecurityHeader(doc);
        Document signedDoc = sign.build(doc, this.senderCrypto, secHeader);
        if (LOG.isDebugEnabled()) {
            String outputString = XMLUtils.PrettyDocumentToString((Document)signedDoc);
            LOG.debug(outputString);
        }
        CertificateStoreTest.assertTrue(((cert = (X509Certificate)(result = WSSecurityUtil.fetchActionResult(results = this.verify(signedDoc, this.receiverCrypto), (int)2)).get((Object)"x509-certificate")) != null ? 1 : 0) != 0);
    }

    @Test
    public void testSignatureDirectReferenceUntrusted() throws Exception {
        WSSecSignature sign = new WSSecSignature();
        sign.setUserInfo("16c73ab6-b892-458f-abf5-2f875f74882e", "security");
        sign.setKeyIdentifierType(1);
        Document doc = SOAPUtil.toSOAPPart("<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader();
        secHeader.insertSecurityHeader(doc);
        Document signedDoc = sign.build(doc, CryptoFactory.getInstance(), secHeader);
        if (LOG.isDebugEnabled()) {
            String outputString = XMLUtils.PrettyDocumentToString((Document)signedDoc);
            LOG.debug(outputString);
        }
        try {
            this.verify(signedDoc, this.receiverCrypto);
            CertificateStoreTest.fail((String)"Failure expected on an unknown certificate");
        }
        catch (WSSecurityException ex) {
            // empty catch block
        }
    }

    private List<WSSecurityEngineResult> verify(Document doc, Crypto crypto) throws Exception {
        List results = this.secEngine.processSecurityHeader(doc, null, this.keystoreCallbackHandler, crypto);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Verfied and decrypted message:");
            String outputString = XMLUtils.PrettyDocumentToString((Document)doc);
            LOG.debug(outputString);
        }
        return results;
    }
}

