/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wss4j.dom.handler;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.wss4j.common.ext.WSPasswordCallback;
import org.apache.wss4j.common.util.XMLUtils;
import org.apache.wss4j.dom.WSSConfig;
import org.apache.wss4j.dom.WSSecurityEngine;
import org.apache.wss4j.dom.WSSecurityEngineResult;
import org.apache.wss4j.dom.common.CustomHandler;
import org.apache.wss4j.dom.common.SOAPUtil;
import org.apache.wss4j.dom.common.SecurityTestUtil;
import org.apache.wss4j.dom.handler.HandlerAction;
import org.apache.wss4j.dom.handler.RequestData;
import org.apache.wss4j.dom.message.WSSecTimestamp;
import org.apache.wss4j.dom.message.token.Timestamp;
import org.apache.wss4j.dom.util.WSSecurityUtil;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class CustomTokenTest
extends Assert {
    private static final Logger LOG = LoggerFactory.getLogger(CustomTokenTest.class);

    @AfterClass
    public static void cleanup() throws Exception {
        SecurityTestUtil.cleanup();
    }

    @Test
    public void testCustomTokenTimestamp() throws Exception {
        WSSecurityEngine secEngine;
        List wsResults;
        WSSecurityEngineResult actionResult;
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        Document timestampDoc = dbf.newDocumentBuilder().newDocument();
        WSSecTimestamp timestamp = new WSSecTimestamp();
        timestamp.setTimeToLive(300);
        timestamp.prepare(timestampDoc);
        Element timestampElement = timestamp.getElement();
        WSSConfig cfg = WSSConfig.getNewInstance();
        RequestData reqData = new RequestData();
        reqData.setWssConfig(cfg);
        TreeMap<String, CustomCallbackHandler> messageContext = new TreeMap<String, CustomCallbackHandler>();
        messageContext.put("passwordCallbackRef", new CustomCallbackHandler(timestampElement));
        reqData.setMsgContext(messageContext);
        Document doc = SOAPUtil.toSOAPPart("<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        CustomHandler handler = new CustomHandler();
        ArrayList<HandlerAction> actions = new ArrayList<HandlerAction>();
        actions.add(new HandlerAction(Integer.valueOf(16384), null));
        handler.send(doc, reqData, actions, true);
        if (LOG.isDebugEnabled()) {
            String outputString = XMLUtils.PrettyDocumentToString((Document)doc);
            LOG.debug(outputString);
        }
        CustomTokenTest.assertTrue(((actionResult = WSSecurityUtil.fetchActionResult((List)(wsResults = (secEngine = new WSSecurityEngine()).processSecurityHeader(doc, null, null, null)), (int)32)) != null ? 1 : 0) != 0);
        Timestamp receivedTimestamp = (Timestamp)actionResult.get((Object)"timestamp");
        CustomTokenTest.assertTrue((receivedTimestamp != null ? 1 : 0) != 0);
    }

    private static class CustomCallbackHandler
    implements CallbackHandler {
        private final Element customElement;

        public CustomCallbackHandler(Element customElement) {
            this.customElement = customElement;
        }

        @Override
        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            for (Callback callback : callbacks) {
                WSPasswordCallback passwordCallback;
                if (!(callback instanceof WSPasswordCallback) || (passwordCallback = (WSPasswordCallback)callback).getUsage() != 7) continue;
                passwordCallback.setCustomToken(this.customElement);
                return;
            }
        }
    }
}

