/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wss4j.dom.message;

import java.util.ArrayList;
import java.util.List;
import javax.security.auth.callback.CallbackHandler;
import javax.xml.namespace.QName;
import org.apache.wss4j.common.WSEncryptionPart;
import org.apache.wss4j.common.crypto.Crypto;
import org.apache.wss4j.common.crypto.CryptoFactory;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.common.util.XMLUtils;
import org.apache.wss4j.dom.SOAPConstants;
import org.apache.wss4j.dom.WSDataRef;
import org.apache.wss4j.dom.WSSConfig;
import org.apache.wss4j.dom.WSSecurityEngine;
import org.apache.wss4j.dom.WSSecurityEngineResult;
import org.apache.wss4j.dom.common.KeystoreCallbackHandler;
import org.apache.wss4j.dom.common.SOAPUtil;
import org.apache.wss4j.dom.common.SecurityTestUtil;
import org.apache.wss4j.dom.message.WSSecEncrypt;
import org.apache.wss4j.dom.message.WSSecHeader;
import org.apache.wss4j.dom.util.WSSecurityUtil;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EncryptionPartsTest
extends Assert {
    private static final Logger LOG = LoggerFactory.getLogger(EncryptionPartsTest.class);
    private static final String SOAPMSG = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><soapenv:Envelope xmlns:foo=\"urn:foo.bar\" xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">   <soapenv:Header>       <foo:bar1>baz1</foo:bar1>       <foo:foobar>baz</foo:foobar>       <foo:bar2>baz2</foo:bar2>   </soapenv:Header>   <soapenv:Body>      <ns1:testMethod xmlns:ns1=\"http://axis/service/security/test6/LogTestService8\"></ns1:testMethod>   </soapenv:Body></soapenv:Envelope>";
    private static final String SOAPMSG_MULTIPLE = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><soapenv:Envelope xmlns:foo=\"urn:foo.bar\" xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">   <soapenv:Header>       <foo:foobar>baz</foo:foobar>   </soapenv:Header>   <soapenv:Body>      <ns1:testMethod xmlns:ns1=\"http://axis/service/security/test6/LogTestService8\">asf1</ns1:testMethod>      <ns1:testMethod xmlns:ns1=\"http://axis/service/security/test6/LogTestService8\">asf2</ns1:testMethod>   </soapenv:Body></soapenv:Envelope>";
    private WSSecurityEngine secEngine = new WSSecurityEngine();
    private CallbackHandler callbackHandler = new KeystoreCallbackHandler();
    private Crypto crypto = CryptoFactory.getInstance();

    @AfterClass
    public static void cleanup() throws Exception {
        SecurityTestUtil.cleanup();
    }

    public EncryptionPartsTest() throws Exception {
        WSSConfig.init();
    }

    @Test
    public void testSOAPHeader() throws Exception {
        WSSecEncrypt encrypt = new WSSecEncrypt();
        encrypt.setUserInfo("16c73ab6-b892-458f-abf5-2f875f74882e", "security");
        encrypt.setKeyIdentifierType(2);
        Document doc = SOAPUtil.toSOAPPart(SOAPMSG);
        WSSecHeader secHeader = new WSSecHeader();
        secHeader.insertSecurityHeader(doc);
        ArrayList<WSEncryptionPart> parts = new ArrayList<WSEncryptionPart>();
        WSEncryptionPart encP = new WSEncryptionPart("foobar", "urn:foo.bar", "");
        parts.add(encP);
        encrypt.setParts(parts);
        Document encryptedDoc = encrypt.build(doc, this.crypto, secHeader);
        if (LOG.isDebugEnabled()) {
            String outputString = XMLUtils.PrettyDocumentToString((Document)encryptedDoc);
            LOG.debug(outputString);
        }
        List<WSSecurityEngineResult> results = this.verify(encryptedDoc);
        QName name = new QName("urn:foo.bar", "foobar");
        WSSecurityUtil.checkAllElementsProtected(results, (int)4, (QName[])new QName[]{name});
        try {
            name = new QName("urn:foo.bar", "foobar2");
            WSSecurityUtil.checkAllElementsProtected(results, (int)4, (QName[])new QName[]{name});
            EncryptionPartsTest.fail((String)"Failure expected on a wrong protected part");
        }
        catch (WSSecurityException ex) {
            // empty catch block
        }
        try {
            name = new QName("urn:foo.bar", "foobar");
            WSSecurityUtil.checkAllElementsProtected(results, (int)2, (QName[])new QName[]{name});
            EncryptionPartsTest.fail((String)"Failure expected on a wrong action");
        }
        catch (WSSecurityException ex) {
            // empty catch block
        }
        WSSecurityEngineResult actionResult = WSSecurityUtil.fetchActionResult(results, (int)4);
        EncryptionPartsTest.assertTrue((actionResult != null ? 1 : 0) != 0);
        EncryptionPartsTest.assertFalse((boolean)actionResult.isEmpty());
        List refs = (List)actionResult.get((Object)"data-ref-uris");
        EncryptionPartsTest.assertEquals((Object)"http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p", (Object)actionResult.get((Object)"encrypted-key-transport-method"));
        WSDataRef wsDataRef = (WSDataRef)refs.get(0);
        String xpath = wsDataRef.getXpath();
        EncryptionPartsTest.assertEquals((Object)"/soapenv:Envelope/soapenv:Header/foo:foobar", (Object)xpath);
        EncryptionPartsTest.assertEquals((Object)"http://www.w3.org/2001/04/xmlenc#aes128-cbc", (Object)wsDataRef.getAlgorithm());
    }

    @Test
    public void testOptionalSOAPHeaderPresent() throws Exception {
        WSSecEncrypt encrypt = new WSSecEncrypt();
        encrypt.setUserInfo("16c73ab6-b892-458f-abf5-2f875f74882e", "security");
        encrypt.setKeyIdentifierType(2);
        Document doc = SOAPUtil.toSOAPPart(SOAPMSG);
        WSSecHeader secHeader = new WSSecHeader();
        secHeader.insertSecurityHeader(doc);
        ArrayList<WSEncryptionPart> parts = new ArrayList<WSEncryptionPart>();
        WSEncryptionPart encP = new WSEncryptionPart("foobar", "urn:foo.bar", "");
        encP.setRequired(false);
        parts.add(encP);
        String soapNamespace = WSSecurityUtil.getSOAPNamespace((Element)doc.getDocumentElement());
        encP = new WSEncryptionPart("Body", soapNamespace, "Content");
        parts.add(encP);
        encrypt.setParts(parts);
        Document encryptedDoc = encrypt.build(doc, this.crypto, secHeader);
        if (LOG.isDebugEnabled()) {
            String outputString = XMLUtils.PrettyDocumentToString((Document)encryptedDoc);
            LOG.debug(outputString);
        }
        this.verify(encryptedDoc);
    }

    @Test
    public void testOptionalSOAPHeaderNotPresent() throws Exception {
        WSSecEncrypt encrypt = new WSSecEncrypt();
        encrypt.setUserInfo("16c73ab6-b892-458f-abf5-2f875f74882e", "security");
        encrypt.setKeyIdentifierType(2);
        Document doc = SOAPUtil.toSOAPPart("<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader();
        secHeader.insertSecurityHeader(doc);
        ArrayList<WSEncryptionPart> parts = new ArrayList<WSEncryptionPart>();
        WSEncryptionPart encP = new WSEncryptionPart("foobar", "urn:foo.bar", "");
        encP.setRequired(false);
        parts.add(encP);
        String soapNamespace = WSSecurityUtil.getSOAPNamespace((Element)doc.getDocumentElement());
        encP = new WSEncryptionPart("Body", soapNamespace, "Content");
        parts.add(encP);
        encrypt.setParts(parts);
        Document encryptedDoc = encrypt.build(doc, this.crypto, secHeader);
        if (LOG.isDebugEnabled()) {
            String outputString = XMLUtils.PrettyDocumentToString((Document)encryptedDoc);
            LOG.debug(outputString);
        }
        this.verify(encryptedDoc);
    }

    @Test
    public void testRequiredSOAPHeaderNotPresent() throws Exception {
        WSSecEncrypt encrypt = new WSSecEncrypt();
        encrypt.setUserInfo("16c73ab6-b892-458f-abf5-2f875f74882e", "security");
        encrypt.setKeyIdentifierType(2);
        Document doc = SOAPUtil.toSOAPPart("<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader();
        secHeader.insertSecurityHeader(doc);
        ArrayList<WSEncryptionPart> parts = new ArrayList<WSEncryptionPart>();
        WSEncryptionPart encP = new WSEncryptionPart("foobar", "urn:foo.bar", "");
        parts.add(encP);
        String soapNamespace = WSSecurityUtil.getSOAPNamespace((Element)doc.getDocumentElement());
        encP = new WSEncryptionPart("Body", soapNamespace, "Content");
        parts.add(encP);
        encrypt.setParts(parts);
        try {
            encrypt.build(doc, this.crypto, secHeader);
            EncryptionPartsTest.fail((String)"Failure expected on not encrypting a required element");
        }
        catch (WSSecurityException ex) {
            // empty catch block
        }
    }

    @Test
    public void testSOAPEncryptedHeader() throws Exception {
        WSSecEncrypt encrypt = new WSSecEncrypt();
        encrypt.setUserInfo("16c73ab6-b892-458f-abf5-2f875f74882e", "security");
        encrypt.setKeyIdentifierType(2);
        Document doc = SOAPUtil.toSOAPPart(SOAPMSG);
        WSSecHeader secHeader = new WSSecHeader();
        secHeader.insertSecurityHeader(doc);
        ArrayList<WSEncryptionPart> parts = new ArrayList<WSEncryptionPart>();
        WSEncryptionPart encP = new WSEncryptionPart("foobar", "urn:foo.bar", "Header");
        parts.add(encP);
        encrypt.setParts(parts);
        Document encryptedDoc = encrypt.build(doc, this.crypto, secHeader);
        String outputString = XMLUtils.PrettyDocumentToString((Document)encryptedDoc);
        if (LOG.isDebugEnabled()) {
            LOG.debug(outputString);
        }
        EncryptionPartsTest.assertTrue((boolean)outputString.contains("wsse11:EncryptedHeader"));
        EncryptionPartsTest.assertFalse((boolean)outputString.contains("foo:foobar"));
        List<WSSecurityEngineResult> results = this.verify(encryptedDoc);
        WSSecurityEngineResult actionResult = WSSecurityUtil.fetchActionResult(results, (int)4);
        EncryptionPartsTest.assertTrue((actionResult != null ? 1 : 0) != 0);
        EncryptionPartsTest.assertFalse((boolean)actionResult.isEmpty());
        List refs = (List)actionResult.get((Object)"data-ref-uris");
        EncryptionPartsTest.assertEquals((Object)"http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p", (Object)actionResult.get((Object)"encrypted-key-transport-method"));
        WSDataRef wsDataRef = (WSDataRef)refs.get(0);
        String xpath = wsDataRef.getXpath();
        EncryptionPartsTest.assertEquals((Object)"/soapenv:Envelope/soapenv:Header/foo:foobar", (Object)xpath);
    }

    @Test
    public void testBadLocalname() throws Exception {
        WSSecEncrypt encrypt = new WSSecEncrypt();
        encrypt.setUserInfo("16c73ab6-b892-458f-abf5-2f875f74882e", "security");
        encrypt.setKeyIdentifierType(2);
        Document doc = SOAPUtil.toSOAPPart(SOAPMSG);
        WSSecHeader secHeader = new WSSecHeader();
        secHeader.insertSecurityHeader(doc);
        ArrayList<WSEncryptionPart> parts = new ArrayList<WSEncryptionPart>();
        WSEncryptionPart encP = new WSEncryptionPart("foobar2", "urn:foo.bar", "");
        parts.add(encP);
        encrypt.setParts(parts);
        try {
            encrypt.build(doc, this.crypto, secHeader);
            EncryptionPartsTest.fail((String)"Failure expected on a bad localname");
        }
        catch (WSSecurityException ex) {
            // empty catch block
        }
    }

    @Test
    public void testBadNamespace() throws Exception {
        WSSecEncrypt encrypt = new WSSecEncrypt();
        encrypt.setUserInfo("16c73ab6-b892-458f-abf5-2f875f74882e", "security");
        encrypt.setKeyIdentifierType(2);
        Document doc = SOAPUtil.toSOAPPart(SOAPMSG);
        WSSecHeader secHeader = new WSSecHeader();
        secHeader.insertSecurityHeader(doc);
        ArrayList<WSEncryptionPart> parts = new ArrayList<WSEncryptionPart>();
        WSEncryptionPart encP = new WSEncryptionPart("foobar", "urn:foo.bar2", "");
        parts.add(encP);
        encrypt.setParts(parts);
        try {
            encrypt.build(doc, this.crypto, secHeader);
            EncryptionPartsTest.fail((String)"Failure expected on a bad namespace");
        }
        catch (WSSecurityException ex) {
            // empty catch block
        }
    }

    @Test
    public void testSOAPHeaderAndBody() throws Exception {
        Document doc = SOAPUtil.toSOAPPart(SOAPMSG);
        SOAPConstants soapConstants = WSSecurityUtil.getSOAPConstants((Element)doc.getDocumentElement());
        WSSecEncrypt encrypt = new WSSecEncrypt();
        encrypt.setUserInfo("16c73ab6-b892-458f-abf5-2f875f74882e", "security");
        encrypt.setKeyIdentifierType(2);
        WSSecHeader secHeader = new WSSecHeader();
        secHeader.insertSecurityHeader(doc);
        ArrayList<WSEncryptionPart> parts = new ArrayList<WSEncryptionPart>();
        WSEncryptionPart encP = new WSEncryptionPart(soapConstants.getBodyQName().getLocalPart(), soapConstants.getEnvelopeURI(), "");
        parts.add(encP);
        WSEncryptionPart encP2 = new WSEncryptionPart("foobar", "urn:foo.bar", "");
        parts.add(encP2);
        encrypt.setParts(parts);
        Document encryptedDoc = encrypt.build(doc, this.crypto, secHeader);
        if (LOG.isDebugEnabled()) {
            String outputString = XMLUtils.PrettyDocumentToString((Document)encryptedDoc);
            LOG.debug(outputString);
        }
        List<WSSecurityEngineResult> results = this.verify(encryptedDoc);
        QName fooName = new QName("urn:foo.bar", "foobar");
        QName bodyName = new QName(soapConstants.getEnvelopeURI(), "Body");
        WSSecurityUtil.checkAllElementsProtected(results, (int)4, (QName[])new QName[]{fooName});
        WSSecurityUtil.checkAllElementsProtected(results, (int)4, (QName[])new QName[]{bodyName});
        WSSecurityUtil.checkAllElementsProtected(results, (int)4, (QName[])new QName[]{bodyName, fooName});
        WSSecurityUtil.checkAllElementsProtected(results, (int)4, (QName[])new QName[]{fooName, bodyName});
        try {
            WSSecurityUtil.checkAllElementsProtected(results, (int)2, (QName[])new QName[]{fooName, bodyName});
            EncryptionPartsTest.fail((String)"Failure expected on a wrong action");
        }
        catch (WSSecurityException ex) {
            // empty catch block
        }
        try {
            QName headerName = new QName(soapConstants.getEnvelopeURI(), "Header");
            WSSecurityUtil.checkAllElementsProtected(results, (int)4, (QName[])new QName[]{fooName, bodyName, headerName});
            EncryptionPartsTest.fail((String)"Failure expected on an unsatisfied requirement");
        }
        catch (WSSecurityException ex) {
            // empty catch block
        }
    }

    @Test
    public void testEncryptionPartDOMElement() throws Exception {
        Document doc = SOAPUtil.toSOAPPart(SOAPMSG);
        SOAPConstants soapConstants = WSSecurityUtil.getSOAPConstants((Element)doc.getDocumentElement());
        WSSecEncrypt encrypt = new WSSecEncrypt();
        encrypt.setUserInfo("16c73ab6-b892-458f-abf5-2f875f74882e", "security");
        encrypt.setKeyIdentifierType(2);
        WSSecHeader secHeader = new WSSecHeader();
        secHeader.insertSecurityHeader(doc);
        ArrayList<WSEncryptionPart> parts = new ArrayList<WSEncryptionPart>();
        WSEncryptionPart encP = new WSEncryptionPart("Incorrect Localname", "Incorrect N/S", "");
        Element bodyElement = WSSecurityUtil.findBodyElement((Document)doc);
        EncryptionPartsTest.assertTrue((bodyElement != null && "Body".equals(bodyElement.getLocalName()) ? 1 : 0) != 0);
        encP.setElement(bodyElement);
        parts.add(encP);
        encrypt.setParts(parts);
        Document encryptedDoc = encrypt.build(doc, this.crypto, secHeader);
        String outputString = XMLUtils.PrettyDocumentToString((Document)encryptedDoc);
        if (LOG.isDebugEnabled()) {
            LOG.debug(outputString);
        }
        EncryptionPartsTest.assertTrue((!outputString.contains("testMethod") ? 1 : 0) != 0);
        List<WSSecurityEngineResult> results = this.verify(encryptedDoc);
        QName bodyName = new QName(soapConstants.getEnvelopeURI(), "Body");
        WSSecurityUtil.checkAllElementsProtected(results, (int)4, (QName[])new QName[]{bodyName});
    }

    @Test
    public void testMultipleElements() throws Exception {
        Document doc = SOAPUtil.toSOAPPart(SOAPMSG_MULTIPLE);
        WSSecEncrypt encrypt = new WSSecEncrypt();
        encrypt.setUserInfo("16c73ab6-b892-458f-abf5-2f875f74882e", "security");
        encrypt.setKeyIdentifierType(2);
        WSSecHeader secHeader = new WSSecHeader();
        secHeader.insertSecurityHeader(doc);
        ArrayList<WSEncryptionPart> parts = new ArrayList<WSEncryptionPart>();
        WSEncryptionPart encP = new WSEncryptionPart("testMethod", "http://axis/service/security/test6/LogTestService8", "");
        parts.add(encP);
        encrypt.setParts(parts);
        Document encryptedDoc = encrypt.build(doc, this.crypto, secHeader);
        String outputString = XMLUtils.PrettyDocumentToString((Document)encryptedDoc);
        if (LOG.isDebugEnabled()) {
            LOG.debug(outputString);
        }
        EncryptionPartsTest.assertFalse((boolean)outputString.contains("testMethod"));
        this.verify(encryptedDoc);
        outputString = XMLUtils.PrettyDocumentToString((Document)encryptedDoc);
        EncryptionPartsTest.assertTrue((boolean)outputString.contains("asf1"));
        EncryptionPartsTest.assertTrue((boolean)outputString.contains("asf2"));
    }

    private List<WSSecurityEngineResult> verify(Document doc) throws Exception {
        List results = this.secEngine.processSecurityHeader(doc, null, this.callbackHandler, null, this.crypto);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Verified and decrypted message:");
            String outputString = XMLUtils.PrettyDocumentToString((Document)doc);
            LOG.debug(outputString);
        }
        return results;
    }
}

