/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wss4j.dom.message;

import java.text.MessageFormat;
import java.util.List;
import java.util.ResourceBundle;
import java.util.TreeMap;
import javax.security.auth.callback.CallbackHandler;
import org.apache.wss4j.common.crypto.Crypto;
import org.apache.wss4j.common.crypto.CryptoFactory;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.common.util.XMLUtils;
import org.apache.wss4j.dom.WSSConfig;
import org.apache.wss4j.dom.WSSecurityEngine;
import org.apache.wss4j.dom.WSSecurityEngineResult;
import org.apache.wss4j.dom.common.CustomHandler;
import org.apache.wss4j.dom.common.KeystoreCallbackHandler;
import org.apache.wss4j.dom.common.SOAPUtil;
import org.apache.wss4j.dom.common.SecurityTestUtil;
import org.apache.wss4j.dom.handler.RequestData;
import org.apache.wss4j.dom.message.TestMessageTransformer;
import org.apache.wss4j.dom.message.WSSecEncrypt;
import org.apache.wss4j.dom.message.WSSecHeader;
import org.apache.wss4j.dom.message.WSSecSignature;
import org.apache.wss4j.dom.util.WSSecurityUtil;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class RequireSignedEncryptedDataElementsTest
extends Assert {
    private static final Logger LOG = LoggerFactory.getLogger(RequireSignedEncryptedDataElementsTest.class);
    private static ResourceBundle resources = ResourceBundle.getBundle("messages.wss4j_errors");
    private static final String SOAPMSG = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"http://blah.com\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>";
    private WSSecurityEngine secEngine = new WSSecurityEngine();
    private CallbackHandler callbackHandler = new KeystoreCallbackHandler();
    private Crypto crypto = CryptoFactory.getInstance();

    @AfterClass
    public static void cleanup() throws Exception {
        SecurityTestUtil.cleanup();
    }

    public RequireSignedEncryptedDataElementsTest() throws Exception {
        WSSConfig.init();
    }

    @Test
    public void testEncryptedKeyRefAndDuplicatedEncDataInWsseHeader() throws Exception {
        Document encryptedSignedDoc = this.getRequestDocument();
        RequestData reqData = this.getRequestData(true);
        this.verify(encryptedSignedDoc, reqData);
        encryptedSignedDoc = this.getRequestDocument();
        reqData = this.getRequestData(false);
        TestMessageTransformer.duplicateEncryptedDataInWsseHeader(encryptedSignedDoc.getDocumentElement(), false);
        this.verify(encryptedSignedDoc, reqData);
        encryptedSignedDoc = this.getRequestDocument();
        reqData = this.getRequestData(true);
        Element newEncData = TestMessageTransformer.duplicateEncryptedDataInWsseHeader(encryptedSignedDoc.getDocumentElement(), false);
        try {
            this.verify(encryptedSignedDoc, reqData);
            RequireSignedEncryptedDataElementsTest.fail((String)"WSSecurityException expected");
        }
        catch (WSSecurityException e) {
            RequireSignedEncryptedDataElementsTest.checkFailure(newEncData, e);
        }
    }

    @Test
    public void testEncryptedKeyRefAndDuplicatedEncDataInWsseWrapperHeader() throws Exception {
        Document encryptedSignedDoc = this.getRequestDocument();
        RequestData reqData = this.getRequestData(true);
        this.verify(encryptedSignedDoc, reqData);
        encryptedSignedDoc = this.getRequestDocument();
        reqData = this.getRequestData(false);
        TestMessageTransformer.duplicateEncryptedDataInWsseWrapperHeader(encryptedSignedDoc.getDocumentElement(), false);
        this.verify(encryptedSignedDoc, reqData);
        encryptedSignedDoc = this.getRequestDocument();
        reqData = this.getRequestData(true);
        Element newEncData = TestMessageTransformer.duplicateEncryptedDataInWsseWrapperHeader(encryptedSignedDoc.getDocumentElement(), false);
        try {
            this.verify(encryptedSignedDoc, reqData);
            RequireSignedEncryptedDataElementsTest.fail((String)"WSSecurityException expected");
        }
        catch (WSSecurityException e) {
            RequireSignedEncryptedDataElementsTest.checkFailure(newEncData, e);
        }
    }

    @Test
    public void testEncryptedKeyRefAndDuplicatedEncDataInExternalWrapperElement() throws Exception {
        Document encryptedSignedDoc = this.getRequestDocument();
        RequestData reqData = this.getRequestData(true);
        this.verify(encryptedSignedDoc, reqData);
        encryptedSignedDoc = this.getRequestDocument();
        reqData = this.getRequestData(false);
        TestMessageTransformer.duplicateEncryptedDataInExternalWrapperElement(encryptedSignedDoc.getDocumentElement(), false);
        this.verify(encryptedSignedDoc, reqData);
        encryptedSignedDoc = this.getRequestDocument();
        reqData = this.getRequestData(true);
        Element newEncData = TestMessageTransformer.duplicateEncryptedDataInExternalWrapperElement(encryptedSignedDoc.getDocumentElement(), false);
        try {
            this.verify(encryptedSignedDoc, reqData);
            RequireSignedEncryptedDataElementsTest.fail((String)"WSSecurityException expected");
        }
        catch (WSSecurityException e) {
            RequireSignedEncryptedDataElementsTest.checkFailure(newEncData, e);
        }
    }

    @Test
    public void testReferenceListAndDuplicatedEncDataInWsseHeader() throws Exception {
        Document encryptedSignedDoc = this.getRequestDocument();
        RequestData reqData = this.getRequestData(true);
        this.verify(encryptedSignedDoc, reqData);
        encryptedSignedDoc = this.getRequestDocument();
        reqData = this.getRequestData(false);
        TestMessageTransformer.duplicateEncryptedDataInWsseHeader(encryptedSignedDoc.getDocumentElement(), true);
        this.verify(encryptedSignedDoc, reqData);
        encryptedSignedDoc = this.getRequestDocument();
        reqData = this.getRequestData(true);
        Element newEncData = TestMessageTransformer.duplicateEncryptedDataInWsseHeader(encryptedSignedDoc.getDocumentElement(), true);
        try {
            this.verify(encryptedSignedDoc, reqData);
            RequireSignedEncryptedDataElementsTest.fail((String)"WSSecurityException expected");
        }
        catch (WSSecurityException e) {
            RequireSignedEncryptedDataElementsTest.checkFailure(newEncData, e);
        }
    }

    @Test
    public void testReferenceListAndDuplicatedEncDataInWsseWrapperHeader() throws Exception {
        Document encryptedSignedDoc = this.getRequestDocument();
        RequestData reqData = this.getRequestData(true);
        this.verify(encryptedSignedDoc, reqData);
        encryptedSignedDoc = this.getRequestDocument();
        reqData = this.getRequestData(false);
        TestMessageTransformer.duplicateEncryptedDataInWsseWrapperHeader(encryptedSignedDoc.getDocumentElement(), true);
        this.verify(encryptedSignedDoc, reqData);
        encryptedSignedDoc = this.getRequestDocument();
        reqData = this.getRequestData(true);
        Element newEncData = TestMessageTransformer.duplicateEncryptedDataInWsseWrapperHeader(encryptedSignedDoc.getDocumentElement(), true);
        try {
            this.verify(encryptedSignedDoc, reqData);
            RequireSignedEncryptedDataElementsTest.fail((String)"WSSecurityException expected");
        }
        catch (WSSecurityException e) {
            RequireSignedEncryptedDataElementsTest.checkFailure(newEncData, e);
        }
    }

    @Test
    public void testReferenceListAndDuplicatedEncDataInExternalWrapperElement() throws Exception {
        Document encryptedSignedDoc = this.getRequestDocument();
        RequestData reqData = this.getRequestData(true);
        this.verify(encryptedSignedDoc, reqData);
        encryptedSignedDoc = this.getRequestDocument();
        reqData = this.getRequestData(false);
        TestMessageTransformer.duplicateEncryptedDataInExternalWrapperElement(encryptedSignedDoc.getDocumentElement(), true);
        this.verify(encryptedSignedDoc, reqData);
        encryptedSignedDoc = this.getRequestDocument();
        reqData = this.getRequestData(true);
        Element newEncData = TestMessageTransformer.duplicateEncryptedDataInExternalWrapperElement(encryptedSignedDoc.getDocumentElement(), true);
        try {
            this.verify(encryptedSignedDoc, reqData);
            RequireSignedEncryptedDataElementsTest.fail((String)"WSSecurityException expected");
        }
        catch (WSSecurityException e) {
            RequireSignedEncryptedDataElementsTest.checkFailure(newEncData, e);
        }
    }

    @Test
    public void testAdditionalEncryptedDataWithEmbeddedEncryptedKeyInWsseHeader() throws Exception {
        Document encryptedSignedDoc = this.getRequestDocument();
        RequestData reqData = this.getRequestData(true);
        this.verify(encryptedSignedDoc, reqData);
        encryptedSignedDoc = this.getRequestDocument();
        reqData = this.getRequestData(true);
        Element newEncData = TestMessageTransformer.addEncryptedDataWithEmbeddedEncryptedKeyInWsseHeader(encryptedSignedDoc.getDocumentElement());
        try {
            this.verify(encryptedSignedDoc, reqData);
            RequireSignedEncryptedDataElementsTest.fail((String)"WSSecurityException expected");
        }
        catch (WSSecurityException e) {
            RequireSignedEncryptedDataElementsTest.checkFailure(newEncData, e);
        }
    }

    private static void checkFailure(Element attackElement, WSSecurityException e) {
        String mex = MessageFormat.format(resources.getString("requiredElementNotSigned"), attackElement);
        RequireSignedEncryptedDataElementsTest.assertTrue((boolean)e.getMessage().contains(mex));
        RequireSignedEncryptedDataElementsTest.assertEquals((Object)WSSecurityException.ErrorCode.FAILED_CHECK, (Object)e.getErrorCode());
    }

    private RequestData getRequestData(boolean reqSignedEncData) throws WSSecurityException {
        RequestData reqData = new RequestData();
        TreeMap<String, String> messageContext = new TreeMap<String, String>();
        messageContext = new TreeMap();
        messageContext.put("requireSignedEncryptedDataElements", Boolean.toString(reqSignedEncData));
        reqData.setMsgContext(messageContext);
        CustomHandler handler = new CustomHandler();
        handler.receive(WSSecurityUtil.decodeAction((String)"Encrypt Signature"), reqData);
        reqData.setCallbackHandler(this.callbackHandler);
        reqData.setSigVerCrypto(this.crypto);
        reqData.setDecCrypto(this.crypto);
        return reqData;
    }

    private Document getRequestDocument() throws Exception {
        WSSecEncrypt encrypt = new WSSecEncrypt();
        WSSecSignature sign = new WSSecSignature();
        encrypt.setUserInfo("16c73ab6-b892-458f-abf5-2f875f74882e");
        sign.setUserInfo("16c73ab6-b892-458f-abf5-2f875f74882e", "security");
        LOG.info("Before Encryption....");
        Document doc = SOAPUtil.toSOAPPart(SOAPMSG);
        WSSecHeader secHeader = new WSSecHeader();
        secHeader.insertSecurityHeader(doc);
        Document encryptedDoc = encrypt.build(doc, this.crypto, secHeader);
        if (LOG.isDebugEnabled()) {
            LOG.debug("After Encryption....");
            String outputString = XMLUtils.PrettyDocumentToString((Document)encryptedDoc);
            LOG.debug(outputString);
        }
        Document encryptedSignedDoc = sign.build(encryptedDoc, this.crypto, secHeader);
        if (LOG.isDebugEnabled()) {
            LOG.debug("After Signing....");
            String outputString = XMLUtils.PrettyDocumentToString((Document)encryptedSignedDoc);
            LOG.debug(outputString);
        }
        return encryptedSignedDoc;
    }

    private List<WSSecurityEngineResult> verify(Document doc, RequestData reqData) throws Exception {
        Element elem = WSSecurityUtil.getSecurityHeader((Document)doc, null);
        List resultList = this.secEngine.processSecurityHeader(elem, reqData);
        if (LOG.isDebugEnabled()) {
            String outputString = XMLUtils.PrettyDocumentToString((Document)doc);
            LOG.debug(outputString);
        }
        return resultList;
    }
}

