/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wss4j.dom.message;

import java.util.ArrayList;
import java.util.List;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.security.auth.callback.CallbackHandler;
import org.apache.wss4j.common.SignatureActionToken;
import org.apache.wss4j.common.bsp.BSPRule;
import org.apache.wss4j.common.crypto.AlgorithmSuite;
import org.apache.wss4j.common.crypto.Crypto;
import org.apache.wss4j.common.crypto.CryptoFactory;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.common.util.XMLUtils;
import org.apache.wss4j.dom.WSSConfig;
import org.apache.wss4j.dom.WSSecurityEngine;
import org.apache.wss4j.dom.WSSecurityEngineResult;
import org.apache.wss4j.dom.common.SOAPUtil;
import org.apache.wss4j.dom.common.SecretKeyCallbackHandler;
import org.apache.wss4j.dom.common.SecurityTestUtil;
import org.apache.wss4j.dom.handler.RequestData;
import org.apache.wss4j.dom.message.WSSecHeader;
import org.apache.wss4j.dom.message.WSSecSignature;
import org.apache.wss4j.dom.util.WSSecurityUtil;
import org.apache.xml.security.utils.Base64;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SignatureAlgorithmSuiteTest
extends Assert {
    private static final Logger LOG = LoggerFactory.getLogger(SignatureAlgorithmSuiteTest.class);
    private Crypto crypto = null;

    @AfterClass
    public static void cleanup() throws Exception {
        SecurityTestUtil.cleanup();
    }

    public SignatureAlgorithmSuiteTest() throws Exception {
        WSSConfig.init();
        this.crypto = CryptoFactory.getInstance();
    }

    @Test
    public void testSignature() throws Exception {
        WSSecSignature builder = new WSSecSignature();
        builder.setUserInfo("16c73ab6-b892-458f-abf5-2f875f74882e", "security");
        builder.setKeyIdentifierType(2);
        builder.setSignatureAlgorithm("http://www.w3.org/2000/09/xmldsig#rsa-sha1");
        Document doc = SOAPUtil.toSOAPPart("<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader();
        secHeader.insertSecurityHeader(doc);
        Document signedDoc = builder.build(doc, this.crypto, secHeader);
        if (LOG.isDebugEnabled()) {
            String outputString = XMLUtils.PrettyDocumentToString((Document)signedDoc);
            LOG.debug(outputString);
        }
        Element securityHeader = WSSecurityUtil.getSecurityHeader((Document)signedDoc, null);
        AlgorithmSuite algorithmSuite = this.createAlgorithmSuite();
        this.verify(securityHeader, algorithmSuite, this.crypto);
        algorithmSuite.setMinimumAsymmetricKeyLength(1024);
        try {
            this.verify(securityHeader, algorithmSuite, this.crypto);
            SignatureAlgorithmSuiteTest.fail((String)"Expected failure as 512-bit keys are not allowed");
        }
        catch (WSSecurityException ex) {
            // empty catch block
        }
    }

    @Test
    public void testSignatureMethodDSA() throws Exception {
        Crypto dsaCrypto = CryptoFactory.getInstance((String)"wss40.properties");
        WSSecSignature builder = new WSSecSignature();
        builder.setUserInfo("wss40DSA", "security");
        builder.setKeyIdentifierType(2);
        builder.setSignatureAlgorithm("http://www.w3.org/2000/09/xmldsig#dsa-sha1");
        Document doc = SOAPUtil.toSOAPPart("<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader();
        secHeader.insertSecurityHeader(doc);
        Document signedDoc = builder.build(doc, dsaCrypto, secHeader);
        if (LOG.isDebugEnabled()) {
            String outputString = XMLUtils.PrettyDocumentToString((Document)signedDoc);
            LOG.debug(outputString);
        }
        Element securityHeader = WSSecurityUtil.getSecurityHeader((Document)signedDoc, null);
        AlgorithmSuite algorithmSuite = this.createAlgorithmSuite();
        try {
            this.verify(securityHeader, algorithmSuite, dsaCrypto);
            SignatureAlgorithmSuiteTest.fail((String)"Expected failure as DSA is not allowed");
        }
        catch (WSSecurityException ex) {
            // empty catch block
        }
        algorithmSuite.addSignatureMethod("http://www.w3.org/2000/09/xmldsig#dsa-sha1");
        this.verify(securityHeader, algorithmSuite, dsaCrypto);
    }

    @Test
    public void testSymmetricKey() throws Exception {
        KeyGenerator keyGen = KeyGenerator.getInstance("AES");
        keyGen.init(128);
        SecretKey key = keyGen.generateKey();
        byte[] keyData = key.getEncoded();
        WSSecSignature builder = new WSSecSignature();
        builder.setKeyIdentifierType(10);
        builder.setSecretKey(keyData);
        builder.setSignatureAlgorithm("http://www.w3.org/2000/09/xmldsig#hmac-sha1");
        Document doc = SOAPUtil.toSOAPPart("<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader();
        secHeader.insertSecurityHeader(doc);
        Document signedDoc = builder.build(doc, this.crypto, secHeader);
        if (LOG.isDebugEnabled()) {
            String outputString = XMLUtils.PrettyDocumentToString((Document)signedDoc);
            LOG.debug(outputString);
        }
        byte[] encodedBytes = WSSecurityUtil.generateDigest((byte[])keyData);
        String identifier = Base64.encode((byte[])encodedBytes);
        SecretKeyCallbackHandler secretKeyCallbackHandler = new SecretKeyCallbackHandler();
        secretKeyCallbackHandler.addSecretKey(identifier, keyData);
        Element securityHeader = WSSecurityUtil.getSecurityHeader((Document)signedDoc, null);
        AlgorithmSuite algorithmSuite = this.createAlgorithmSuite();
        WSSecurityEngine secEngine = new WSSecurityEngine();
        RequestData data = new RequestData();
        SignatureActionToken actionToken = new SignatureActionToken();
        actionToken.setCrypto(this.crypto);
        data.setSignatureToken(actionToken);
        data.setCallbackHandler((CallbackHandler)secretKeyCallbackHandler);
        data.setAlgorithmSuite(algorithmSuite);
        try {
            secEngine.processSecurityHeader(securityHeader, data);
            SignatureAlgorithmSuiteTest.fail((String)"Expected failure as HMAC-SHA1 is not allowed");
        }
        catch (WSSecurityException ex) {
            // empty catch block
        }
        algorithmSuite.addSignatureMethod("http://www.w3.org/2000/09/xmldsig#hmac-sha1");
        secEngine.processSecurityHeader(securityHeader, data);
        algorithmSuite.setMinimumSymmetricKeyLength(256);
        try {
            secEngine.processSecurityHeader(securityHeader, data);
            SignatureAlgorithmSuiteTest.fail((String)"Expected failure as a 128 bit key is not allowed");
        }
        catch (WSSecurityException ex) {
            // empty catch block
        }
        algorithmSuite.setMinimumSymmetricKeyLength(64);
        algorithmSuite.setMaximumSymmetricKeyLength(120);
        try {
            secEngine.processSecurityHeader(securityHeader, data);
            SignatureAlgorithmSuiteTest.fail((String)"Expected failure as a 128 bit key is not allowed");
        }
        catch (WSSecurityException ex) {
            // empty catch block
        }
    }

    @Test
    public void testC14nMethod() throws Exception {
        WSSecSignature builder = new WSSecSignature();
        builder.setUserInfo("16c73ab6-b892-458f-abf5-2f875f74882e", "security");
        builder.setKeyIdentifierType(2);
        builder.setSignatureAlgorithm("http://www.w3.org/2000/09/xmldsig#rsa-sha1");
        builder.setSigCanonicalization("http://www.w3.org/2001/10/xml-exc-c14n#WithComments");
        Document doc = SOAPUtil.toSOAPPart("<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader();
        secHeader.insertSecurityHeader(doc);
        Document signedDoc = builder.build(doc, this.crypto, secHeader);
        if (LOG.isDebugEnabled()) {
            String outputString = XMLUtils.PrettyDocumentToString((Document)signedDoc);
            LOG.debug(outputString);
        }
        Element securityHeader = WSSecurityUtil.getSecurityHeader((Document)signedDoc, null);
        AlgorithmSuite algorithmSuite = this.createAlgorithmSuite();
        try {
            this.verify(securityHeader, algorithmSuite, this.crypto);
            SignatureAlgorithmSuiteTest.fail((String)"Expected failure as C14n algorithm is not allowed");
        }
        catch (WSSecurityException ex) {
            // empty catch block
        }
        algorithmSuite.addC14nAlgorithm("http://www.w3.org/2001/10/xml-exc-c14n#WithComments");
        this.verify(securityHeader, algorithmSuite, this.crypto);
    }

    @Test
    public void testDigestMethod() throws Exception {
        WSSecSignature builder = new WSSecSignature();
        builder.setUserInfo("16c73ab6-b892-458f-abf5-2f875f74882e", "security");
        builder.setKeyIdentifierType(2);
        builder.setSignatureAlgorithm("http://www.w3.org/2000/09/xmldsig#rsa-sha1");
        builder.setDigestAlgo("http://www.w3.org/2001/04/xmlenc#sha256");
        Document doc = SOAPUtil.toSOAPPart("<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader();
        secHeader.insertSecurityHeader(doc);
        Document signedDoc = builder.build(doc, this.crypto, secHeader);
        if (LOG.isDebugEnabled()) {
            String outputString = XMLUtils.PrettyDocumentToString((Document)signedDoc);
            LOG.debug(outputString);
        }
        Element securityHeader = WSSecurityUtil.getSecurityHeader((Document)signedDoc, null);
        AlgorithmSuite algorithmSuite = this.createAlgorithmSuite();
        try {
            this.verify(securityHeader, algorithmSuite, this.crypto);
            SignatureAlgorithmSuiteTest.fail((String)"Expected failure as Digest algorithm is not allowed");
        }
        catch (WSSecurityException ex) {
            // empty catch block
        }
        algorithmSuite.addDigestAlgorithm("http://www.w3.org/2001/04/xmlenc#sha256");
        this.verify(securityHeader, algorithmSuite, this.crypto);
    }

    private AlgorithmSuite createAlgorithmSuite() {
        AlgorithmSuite algorithmSuite = new AlgorithmSuite();
        algorithmSuite.addSignatureMethod("http://www.w3.org/2000/09/xmldsig#rsa-sha1");
        algorithmSuite.setMinimumAsymmetricKeyLength(512);
        algorithmSuite.addC14nAlgorithm("http://www.w3.org/2001/10/xml-exc-c14n#");
        algorithmSuite.addDigestAlgorithm("http://www.w3.org/2000/09/xmldsig#sha1");
        return algorithmSuite;
    }

    private List<WSSecurityEngineResult> verify(Element securityHeader, AlgorithmSuite algorithmSuite, Crypto sigVerCrypto) throws Exception {
        WSSecurityEngine secEngine = new WSSecurityEngine();
        RequestData data = new RequestData();
        data.setSigVerCrypto(sigVerCrypto);
        data.setAlgorithmSuite(algorithmSuite);
        ArrayList<BSPRule> ignoredRules = new ArrayList<BSPRule>();
        ignoredRules.add(BSPRule.R5404);
        ignoredRules.add(BSPRule.R5406);
        data.setIgnoredBSPRules(ignoredRules);
        return secEngine.processSecurityHeader(securityHeader, data);
    }
}

