/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wss4j.dom.message;

import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.List;
import java.util.TreeMap;
import org.apache.wss4j.common.crypto.Crypto;
import org.apache.wss4j.common.crypto.CryptoFactory;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.common.util.XMLUtils;
import org.apache.wss4j.dom.WSSConfig;
import org.apache.wss4j.dom.WSSecurityEngine;
import org.apache.wss4j.dom.WSSecurityEngineResult;
import org.apache.wss4j.dom.common.CustomHandler;
import org.apache.wss4j.dom.common.SOAPUtil;
import org.apache.wss4j.dom.common.SecurityTestUtil;
import org.apache.wss4j.dom.handler.HandlerAction;
import org.apache.wss4j.dom.handler.RequestData;
import org.apache.wss4j.dom.message.WSSecHeader;
import org.apache.wss4j.dom.message.WSSecSignature;
import org.apache.wss4j.dom.util.WSSecurityUtil;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public class SignatureCertTest
extends Assert {
    private static final Logger LOG = LoggerFactory.getLogger(SignatureCertTest.class);
    private WSSecurityEngine secEngine = new WSSecurityEngine();
    private Crypto crypto = null;
    private Crypto cryptoCA = null;

    @AfterClass
    public static void cleanup() throws Exception {
        SecurityTestUtil.cleanup();
    }

    public SignatureCertTest() throws Exception {
        WSSConfig.init();
        this.crypto = CryptoFactory.getInstance((String)"wss40.properties");
        this.cryptoCA = CryptoFactory.getInstance((String)"wss40CA.properties");
    }

    @Test
    public void testSignatureDirectReference() throws Exception {
        List<WSSecurityEngineResult> results;
        WSSecurityEngineResult result;
        X509Certificate cert;
        WSSecSignature sign = new WSSecSignature();
        sign.setUserInfo("wss40", "security");
        sign.setKeyIdentifierType(1);
        Document doc = SOAPUtil.toSOAPPart("<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader();
        secHeader.insertSecurityHeader(doc);
        Document signedDoc = sign.build(doc, this.crypto, secHeader);
        if (LOG.isDebugEnabled()) {
            String outputString = XMLUtils.PrettyDocumentToString((Document)signedDoc);
            LOG.debug(outputString);
        }
        SignatureCertTest.assertTrue(((cert = (X509Certificate)(result = WSSecurityUtil.fetchActionResult(results = this.verify(signedDoc, this.cryptoCA), (int)2)).get((Object)"x509-certificate")) != null ? 1 : 0) != 0);
    }

    @Test
    @Ignore
    public void testBSTCertChain() throws Exception {
        Crypto serverCrypto;
        List<WSSecurityEngineResult> results;
        WSSecurityEngineResult result;
        X509Certificate cert;
        if ("IBM Corporation".equals(System.getProperty("java.vendor"))) {
            return;
        }
        Crypto clientCrypto = CryptoFactory.getInstance((String)"wss40_client.properties");
        WSSecSignature sign = new WSSecSignature();
        sign.setUserInfo("Client_CertChain", "password");
        sign.setKeyIdentifierType(1);
        sign.setUseSingleCertificate(false);
        Document doc = SOAPUtil.toSOAPPart("<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader();
        secHeader.insertSecurityHeader(doc);
        Document signedDoc = sign.build(doc, clientCrypto, secHeader);
        if (LOG.isDebugEnabled()) {
            String outputString = XMLUtils.PrettyDocumentToString((Document)signedDoc);
            LOG.debug("BST CA Cert");
            LOG.debug(outputString);
        }
        SignatureCertTest.assertTrue(((cert = (X509Certificate)(result = WSSecurityUtil.fetchActionResult(results = this.verify(signedDoc, serverCrypto = CryptoFactory.getInstance((String)"wss40_server.properties")), (int)2)).get((Object)"x509-certificate")) != null ? 1 : 0) != 0);
        X509Certificate[] certs = (X509Certificate[])result.get((Object)"x509-certificates");
        SignatureCertTest.assertTrue((certs != null && certs.length == 2 ? 1 : 0) != 0);
    }

    @Test
    public void testSignatureDirectReferenceCACert() throws Exception {
        List<WSSecurityEngineResult> results;
        WSSecurityEngineResult result;
        X509Certificate cert;
        WSSecSignature sign = new WSSecSignature();
        sign.setUserInfo("wss40", "security");
        sign.setKeyIdentifierType(1);
        sign.setUseSingleCertificate(false);
        Document doc = SOAPUtil.toSOAPPart("<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader();
        secHeader.insertSecurityHeader(doc);
        Document signedDoc = sign.build(doc, this.crypto, secHeader);
        if (LOG.isDebugEnabled()) {
            String outputString = XMLUtils.PrettyDocumentToString((Document)signedDoc);
            LOG.debug("BST CA Cert");
            LOG.debug(outputString);
        }
        SignatureCertTest.assertTrue(((cert = (X509Certificate)(result = WSSecurityUtil.fetchActionResult(results = this.verify(signedDoc, this.cryptoCA), (int)2)).get((Object)"x509-certificate")) != null ? 1 : 0) != 0);
        X509Certificate[] certs = (X509Certificate[])result.get((Object)"x509-certificates");
        SignatureCertTest.assertTrue((certs != null && certs.length == 2 ? 1 : 0) != 0);
    }

    @Test
    public void testSignatureIssuerSerial() throws Exception {
        WSSecSignature sign = new WSSecSignature();
        sign.setUserInfo("wss40", "security");
        sign.setKeyIdentifierType(2);
        Document doc = SOAPUtil.toSOAPPart("<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader();
        secHeader.insertSecurityHeader(doc);
        Document signedDoc = sign.build(doc, this.crypto, secHeader);
        if (LOG.isDebugEnabled()) {
            String outputString = XMLUtils.PrettyDocumentToString((Document)signedDoc);
            LOG.debug(outputString);
        }
        try {
            this.verify(signedDoc, this.cryptoCA);
            SignatureCertTest.fail((String)"Failure expected on issuer serial");
        }
        catch (WSSecurityException ex) {
            SignatureCertTest.assertTrue((ex.getErrorCode() == WSSecurityException.ErrorCode.FAILED_CHECK ? 1 : 0) != 0);
        }
    }

    @Test
    public void testSignatureBadCACert() throws Exception {
        WSSecSignature sign = new WSSecSignature();
        sign.setUserInfo("wss4jcertdsa", "security");
        sign.setKeyIdentifierType(1);
        Document doc = SOAPUtil.toSOAPPart("<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader();
        secHeader.insertSecurityHeader(doc);
        Document signedDoc = sign.build(doc, CryptoFactory.getInstance((String)"wss40badca.properties"), secHeader);
        if (LOG.isDebugEnabled()) {
            String outputString = XMLUtils.PrettyDocumentToString((Document)signedDoc);
            LOG.debug(outputString);
        }
        try {
            this.verify(signedDoc, CryptoFactory.getInstance((String)"wss40badcatrust.properties"));
            SignatureCertTest.fail((String)"Failure expected on bad CA cert!");
        }
        catch (WSSecurityException ex) {
            // empty catch block
        }
    }

    @Test
    public void testMultipleCertsWSHandler() throws Exception {
        WSSConfig cfg = WSSConfig.getNewInstance();
        RequestData reqData = new RequestData();
        reqData.setWssConfig(cfg);
        reqData.setUsername("wss40");
        TreeMap<String, String> config = new TreeMap<String, String>();
        config.put("signaturePropFile", "wss40.properties");
        config.put("password", "security");
        config.put("signatureKeyIdentifier", "DirectReference");
        config.put("useSingleCertificate", "false");
        reqData.setMsgContext(config);
        Document doc = SOAPUtil.toSOAPPart("<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        CustomHandler handler = new CustomHandler();
        HandlerAction action = new HandlerAction(Integer.valueOf(2));
        handler.send(doc, reqData, Collections.singletonList(action), true);
        List<WSSecurityEngineResult> results = this.verify(doc, this.cryptoCA);
        WSSecurityEngineResult result = WSSecurityUtil.fetchActionResult(results, (int)2);
        X509Certificate cert = (X509Certificate)result.get((Object)"x509-certificate");
        SignatureCertTest.assertTrue((cert != null ? 1 : 0) != 0);
        X509Certificate[] certs = (X509Certificate[])result.get((Object)"x509-certificates");
        SignatureCertTest.assertTrue((certs != null && certs.length == 2 ? 1 : 0) != 0);
    }

    private List<WSSecurityEngineResult> verify(Document doc, Crypto crypto) throws Exception {
        List results = this.secEngine.processSecurityHeader(doc, null, null, crypto);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Verfied and decrypted message:");
            String outputString = XMLUtils.PrettyDocumentToString((Document)doc);
            LOG.debug(outputString);
        }
        return results;
    }
}

