/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wss4j.dom.message;

import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.TreeMap;
import org.apache.wss4j.common.WSEncryptionPart;
import org.apache.wss4j.common.crypto.Crypto;
import org.apache.wss4j.common.crypto.CryptoFactory;
import org.apache.wss4j.common.crypto.CryptoType;
import org.apache.wss4j.common.util.XMLUtils;
import org.apache.wss4j.dom.WSSConfig;
import org.apache.wss4j.dom.WSSecurityEngine;
import org.apache.wss4j.dom.WSSecurityEngineResult;
import org.apache.wss4j.dom.common.CustomHandler;
import org.apache.wss4j.dom.common.SOAPUtil;
import org.apache.wss4j.dom.common.SecurityTestUtil;
import org.apache.wss4j.dom.handler.HandlerAction;
import org.apache.wss4j.dom.handler.RequestData;
import org.apache.wss4j.dom.message.WSSecHeader;
import org.apache.wss4j.dom.message.WSSecSignature;
import org.apache.wss4j.dom.message.token.X509Security;
import org.apache.wss4j.dom.util.WSSecurityUtil;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SignedBSTTest
extends Assert {
    private static final Logger LOG = LoggerFactory.getLogger(SignedBSTTest.class);
    private WSSecurityEngine secEngine = new WSSecurityEngine();
    private Crypto crypto = null;

    @AfterClass
    public static void cleanup() throws Exception {
        SecurityTestUtil.cleanup();
    }

    public SignedBSTTest() throws Exception {
        WSSConfig.init();
        this.crypto = CryptoFactory.getInstance((String)"wss40.properties");
    }

    @Test
    public void testSignedBST() throws Exception {
        Document doc = SOAPUtil.toSOAPPart("<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader();
        secHeader.insertSecurityHeader(doc);
        CryptoType cryptoType = new CryptoType(CryptoType.TYPE.ALIAS);
        cryptoType.setAlias("wss40");
        X509Certificate[] certs = this.crypto.getX509Certificates(cryptoType);
        SignedBSTTest.assertNotNull((Object)certs);
        X509Security bst = new X509Security(doc);
        String certUri = WSSConfig.getNewInstance().getIdAllocator().createSecureId("X509-", (Object)certs[0]);
        bst.setX509Certificate(certs[0]);
        bst.setID(certUri);
        WSSecurityUtil.prependChildElement((Element)secHeader.getSecurityHeader(), (Element)bst.getElement());
        WSSecSignature sign = new WSSecSignature();
        sign.setUserInfo("wss40", "security");
        sign.setSignatureAlgorithm("http://www.w3.org/2000/09/xmldsig#rsa-sha1");
        sign.setKeyIdentifierType(9);
        sign.setX509Certificate(certs[0]);
        ArrayList<WSEncryptionPart> parts = new ArrayList<WSEncryptionPart>();
        String soapNamespace = WSSecurityUtil.getSOAPNamespace((Element)doc.getDocumentElement());
        WSEncryptionPart encP = new WSEncryptionPart("Body", soapNamespace, "Content");
        parts.add(encP);
        encP = new WSEncryptionPart("BinarySecurityToken", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "Element");
        encP.setElement(bst.getElement());
        parts.add(encP);
        sign.setParts(parts);
        sign.setCustomTokenId(bst.getID());
        sign.setCustomTokenValueType(bst.getValueType());
        sign.prepare(doc, this.crypto, secHeader);
        List referenceList = sign.addReferencesToSign(parts, secHeader);
        sign.computeSignature(referenceList, false, null);
        if (LOG.isDebugEnabled()) {
            String outputString = XMLUtils.PrettyDocumentToString((Document)doc);
            LOG.debug(outputString);
        }
        this.verify(doc);
    }

    @Test
    public void testSignedBSTAction() throws Exception {
        WSSConfig cfg = WSSConfig.getNewInstance();
        RequestData reqData = new RequestData();
        reqData.setWssConfig(cfg);
        reqData.setUsername("wss40");
        TreeMap<String, String> config = new TreeMap<String, String>();
        config.put("signaturePropFile", "wss40.properties");
        config.put("password", "security");
        config.put("signatureKeyIdentifier", "DirectReference");
        config.put("signatureParts", "{}{http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd}BinarySecurityToken");
        reqData.setMsgContext(config);
        Document doc = SOAPUtil.toSOAPPart("<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        CustomHandler handler = new CustomHandler();
        HandlerAction action = new HandlerAction(Integer.valueOf(2));
        handler.send(doc, reqData, Collections.singletonList(action), true);
        String outputString = XMLUtils.PrettyDocumentToString((Document)doc);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Signed message:");
            LOG.debug(outputString);
        }
        List<WSSecurityEngineResult> results = this.verify(doc);
        SignedBSTTest.assertTrue((boolean)handler.checkResults(results, Collections.singletonList(2)));
    }

    private List<WSSecurityEngineResult> verify(Document doc) throws Exception {
        List results = this.secEngine.processSecurityHeader(doc, null, null, this.crypto);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Verfied and decrypted message:");
            String outputString = XMLUtils.PrettyDocumentToString((Document)doc);
            LOG.debug(outputString);
        }
        return results;
    }
}

