/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wss4j.dom.message;

import java.security.Principal;
import java.util.Collections;
import java.util.List;
import java.util.TreeMap;
import javax.security.auth.callback.CallbackHandler;
import org.apache.wss4j.common.crypto.Crypto;
import org.apache.wss4j.common.crypto.CryptoFactory;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.common.util.XMLUtils;
import org.apache.wss4j.dom.WSSConfig;
import org.apache.wss4j.dom.WSSecurityEngine;
import org.apache.wss4j.dom.WSSecurityEngineResult;
import org.apache.wss4j.dom.common.CustomHandler;
import org.apache.wss4j.dom.common.SOAPUtil;
import org.apache.wss4j.dom.common.SecurityTestUtil;
import org.apache.wss4j.dom.common.UsernamePasswordCallbackHandler;
import org.apache.wss4j.dom.handler.HandlerAction;
import org.apache.wss4j.dom.handler.RequestData;
import org.apache.wss4j.dom.message.WSSecHeader;
import org.apache.wss4j.dom.message.WSSecSignature;
import org.apache.wss4j.dom.message.WSSecUsernameToken;
import org.apache.wss4j.dom.util.WSSecurityUtil;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public class UTSignatureTest
extends Assert {
    private static final Logger LOG = LoggerFactory.getLogger(UTSignatureTest.class);
    private CallbackHandler callbackHandler = new UsernamePasswordCallbackHandler();
    private Crypto crypto = CryptoFactory.getInstance();

    @AfterClass
    public static void cleanup() throws Exception {
        SecurityTestUtil.cleanup();
    }

    @Test
    public void testSignature() throws Exception {
        Document doc = SOAPUtil.toSOAPPart("<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader();
        secHeader.insertSecurityHeader(doc);
        WSSecUsernameToken builder = new WSSecUsernameToken();
        builder.setUserInfo("bob", "security");
        builder.addDerivedKey(true, null, 1000);
        builder.prepare(doc);
        WSSecSignature sign = new WSSecSignature();
        sign.setCustomTokenValueType("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#UsernameToken");
        sign.setCustomTokenId(builder.getId());
        sign.setSecretKey(builder.getDerivedKey());
        sign.setKeyIdentifierType(9);
        sign.setSignatureAlgorithm("http://www.w3.org/2000/09/xmldsig#hmac-sha1");
        Document signedDoc = sign.build(doc, null, secHeader);
        builder.prependToHeader(secHeader);
        String outputString = XMLUtils.PrettyDocumentToString((Document)signedDoc);
        UTSignatureTest.assertTrue((boolean)outputString.contains("wsse:Username"));
        UTSignatureTest.assertFalse((boolean)outputString.contains("wsse:Password"));
        UTSignatureTest.assertTrue((boolean)outputString.contains("wsse11:Salt"));
        UTSignatureTest.assertTrue((boolean)outputString.contains("wsse11:Iteration"));
        if (LOG.isDebugEnabled()) {
            LOG.debug(outputString);
        }
        List<WSSecurityEngineResult> results = this.verify(signedDoc);
        WSSecurityEngineResult actionResult = WSSecurityUtil.fetchActionResult(results, (int)64);
        Principal principal = (Principal)actionResult.get((Object)"principal");
        UTSignatureTest.assertTrue((boolean)principal.getName().contains("bob"));
        try {
            this.verify(signedDoc, false);
            UTSignatureTest.fail((String)"Failure expected on deriving keys from a UsernameToken not allowed");
        }
        catch (WSSecurityException ex) {
            // empty catch block
        }
    }

    @Test
    public void testBadUserSignature() throws Exception {
        Document doc = SOAPUtil.toSOAPPart("<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader();
        secHeader.insertSecurityHeader(doc);
        WSSecUsernameToken builder = new WSSecUsernameToken();
        builder.setUserInfo("colm", "security");
        builder.addDerivedKey(true, null, 1000);
        builder.prepare(doc);
        WSSecSignature sign = new WSSecSignature();
        sign.setCustomTokenValueType("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#UsernameToken");
        sign.setCustomTokenId(builder.getId());
        sign.setSecretKey(builder.getDerivedKey());
        sign.setKeyIdentifierType(9);
        sign.setSignatureAlgorithm("http://www.w3.org/2000/09/xmldsig#hmac-sha1");
        Document signedDoc = sign.build(doc, null, secHeader);
        builder.prependToHeader(secHeader);
        String outputString = XMLUtils.PrettyDocumentToString((Document)signedDoc);
        if (LOG.isDebugEnabled()) {
            LOG.debug(outputString);
        }
        try {
            this.verify(signedDoc);
            UTSignatureTest.fail((String)"Failure expected on a bad derived signature");
        }
        catch (WSSecurityException ex) {
            UTSignatureTest.assertTrue((ex.getErrorCode() == WSSecurityException.ErrorCode.FAILED_AUTHENTICATION ? 1 : 0) != 0);
        }
    }

    @Test
    public void testHandlerSignature() throws Exception {
        WSSConfig cfg = WSSConfig.getNewInstance();
        RequestData reqData = new RequestData();
        reqData.setWssConfig(cfg);
        TreeMap<String, CallbackHandler> messageContext = new TreeMap<String, CallbackHandler>();
        messageContext.put("passwordCallbackRef", this.callbackHandler);
        reqData.setMsgContext(messageContext);
        reqData.setUsername("bob");
        Document doc = SOAPUtil.toSOAPPart("<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        CustomHandler handler = new CustomHandler();
        HandlerAction action = new HandlerAction(Integer.valueOf(64));
        handler.send(doc, reqData, Collections.singletonList(action), true);
        String outputString = XMLUtils.PrettyDocumentToString((Document)doc);
        UTSignatureTest.assertTrue((boolean)outputString.contains("wsse:Username"));
        UTSignatureTest.assertFalse((boolean)outputString.contains("wsse:Password"));
        UTSignatureTest.assertTrue((boolean)outputString.contains("wsse11:Salt"));
        UTSignatureTest.assertTrue((boolean)outputString.contains("wsse11:Iteration"));
        if (LOG.isDebugEnabled()) {
            LOG.debug(outputString);
        }
        List<WSSecurityEngineResult> results = this.verify(doc);
        WSSecurityEngineResult actionResult = WSSecurityUtil.fetchActionResult(results, (int)64);
        Principal principal = (Principal)actionResult.get((Object)"principal");
        UTSignatureTest.assertTrue((boolean)principal.getName().contains("bob"));
    }

    @Test
    public void testHandlerSignatureIterations() throws Exception {
        WSSConfig cfg = WSSConfig.getNewInstance();
        RequestData reqData = new RequestData();
        reqData.setWssConfig(cfg);
        TreeMap<String, Object> messageContext = new TreeMap<String, Object>();
        messageContext.put("passwordCallbackRef", this.callbackHandler);
        messageContext.put("derivedKeyIterations", "1234");
        reqData.setMsgContext(messageContext);
        reqData.setUsername("bob");
        Document doc = SOAPUtil.toSOAPPart("<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        CustomHandler handler = new CustomHandler();
        HandlerAction action = new HandlerAction(Integer.valueOf(64));
        handler.send(doc, reqData, Collections.singletonList(action), true);
        String outputString = XMLUtils.PrettyDocumentToString((Document)doc);
        UTSignatureTest.assertTrue((boolean)outputString.contains("wsse:Username"));
        UTSignatureTest.assertFalse((boolean)outputString.contains("wsse:Password"));
        UTSignatureTest.assertTrue((boolean)outputString.contains("wsse11:Salt"));
        UTSignatureTest.assertTrue((boolean)outputString.contains("wsse11:Iteration"));
        UTSignatureTest.assertTrue((boolean)outputString.contains("1234"));
        if (LOG.isDebugEnabled()) {
            LOG.debug(outputString);
        }
        List<WSSecurityEngineResult> results = this.verify(doc);
        WSSecurityEngineResult actionResult = WSSecurityUtil.fetchActionResult(results, (int)64);
        Principal principal = (Principal)actionResult.get((Object)"principal");
        UTSignatureTest.assertTrue((boolean)principal.getName().contains("bob"));
    }

    private List<WSSecurityEngineResult> verify(Document doc) throws Exception {
        return this.verify(doc, true);
    }

    private List<WSSecurityEngineResult> verify(Document doc, boolean allowUsernameTokenDerivedKeys) throws Exception {
        WSSecurityEngine secEngine = new WSSecurityEngine();
        WSSConfig config = WSSConfig.getNewInstance();
        config.setAllowUsernameTokenNoPassword(allowUsernameTokenDerivedKeys);
        secEngine.setWssConfig(config);
        return secEngine.processSecurityHeader(doc, null, this.callbackHandler, this.crypto);
    }
}

