/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wss4j.dom.saml;

import java.util.List;
import javax.security.auth.callback.CallbackHandler;
import org.apache.wss4j.common.crypto.AlgorithmSuite;
import org.apache.wss4j.common.crypto.Crypto;
import org.apache.wss4j.common.crypto.CryptoFactory;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.common.saml.SAMLCallback;
import org.apache.wss4j.common.saml.SAMLUtil;
import org.apache.wss4j.common.saml.SamlAssertionWrapper;
import org.apache.wss4j.common.util.XMLUtils;
import org.apache.wss4j.dom.WSSConfig;
import org.apache.wss4j.dom.WSSecurityEngine;
import org.apache.wss4j.dom.WSSecurityEngineResult;
import org.apache.wss4j.dom.common.AbstractSAMLCallbackHandler;
import org.apache.wss4j.dom.common.SAML1CallbackHandler;
import org.apache.wss4j.dom.common.SOAPUtil;
import org.apache.wss4j.dom.common.SecurityTestUtil;
import org.apache.wss4j.dom.handler.RequestData;
import org.apache.wss4j.dom.message.WSSecHeader;
import org.apache.wss4j.dom.message.WSSecSAMLToken;
import org.apache.wss4j.dom.util.WSSecurityUtil;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SamlAlgorithmSuiteTest
extends Assert {
    private static final Logger LOG = LoggerFactory.getLogger(SamlAlgorithmSuiteTest.class);
    private Crypto crypto = null;

    @AfterClass
    public static void cleanup() throws Exception {
        SecurityTestUtil.cleanup();
    }

    public SamlAlgorithmSuiteTest() throws Exception {
        WSSConfig.init();
        this.crypto = CryptoFactory.getInstance((String)"crypto.properties");
    }

    @Test
    public void testSignedSAML11Assertion() throws Exception {
        SAML1CallbackHandler callbackHandler = new SAML1CallbackHandler();
        callbackHandler.setStatement(AbstractSAMLCallbackHandler.Statement.AUTHN);
        callbackHandler.setConfirmationMethod("urn:oasis:names:tc:SAML:1.0:cm:holder-of-key");
        callbackHandler.setIssuer("www.example.com");
        SAMLCallback samlCallback = new SAMLCallback();
        SAMLUtil.doSAMLCallback((CallbackHandler)callbackHandler, (SAMLCallback)samlCallback);
        SamlAssertionWrapper samlAssertion = new SamlAssertionWrapper(samlCallback);
        samlAssertion.signAssertion("16c73ab6-b892-458f-abf5-2f875f74882e", "security", this.crypto, false);
        WSSecSAMLToken wsSign = new WSSecSAMLToken();
        Document doc = SOAPUtil.toSOAPPart("<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader();
        secHeader.insertSecurityHeader(doc);
        Document signedDoc = wsSign.build(doc, samlAssertion, secHeader);
        if (LOG.isDebugEnabled()) {
            String outputString = XMLUtils.PrettyDocumentToString((Document)signedDoc);
            LOG.debug(outputString);
        }
        Element securityHeader = WSSecurityUtil.getSecurityHeader((Document)signedDoc, null);
        AlgorithmSuite algorithmSuite = this.createAlgorithmSuite();
        this.verify(securityHeader, algorithmSuite, this.crypto, false);
        algorithmSuite.setMinimumAsymmetricKeyLength(1024);
        try {
            this.verify(securityHeader, algorithmSuite, this.crypto, false);
            SamlAlgorithmSuiteTest.fail((String)"Expected failure as 512-bit keys are not allowed");
        }
        catch (WSSecurityException ex) {
            // empty catch block
        }
    }

    @Test
    public void testDSASignedSAML11Assertion() throws Exception {
        Crypto dsaCrypto = CryptoFactory.getInstance((String)"wss40.properties");
        SAML1CallbackHandler callbackHandler = new SAML1CallbackHandler();
        callbackHandler.setStatement(AbstractSAMLCallbackHandler.Statement.AUTHN);
        callbackHandler.setConfirmationMethod("urn:oasis:names:tc:SAML:1.0:cm:holder-of-key");
        callbackHandler.setIssuer("www.example.com");
        SAMLCallback samlCallback = new SAMLCallback();
        SAMLUtil.doSAMLCallback((CallbackHandler)callbackHandler, (SAMLCallback)samlCallback);
        SamlAssertionWrapper samlAssertion = new SamlAssertionWrapper(samlCallback);
        samlAssertion.signAssertion("wss40DSA", "security", dsaCrypto, false);
        WSSecSAMLToken wsSign = new WSSecSAMLToken();
        Document doc = SOAPUtil.toSOAPPart("<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader();
        secHeader.insertSecurityHeader(doc);
        Document signedDoc = wsSign.build(doc, samlAssertion, secHeader);
        if (LOG.isDebugEnabled()) {
            String outputString = XMLUtils.PrettyDocumentToString((Document)signedDoc);
            LOG.debug(outputString);
        }
        Element securityHeader = WSSecurityUtil.getSecurityHeader((Document)signedDoc, null);
        AlgorithmSuite algorithmSuite = this.createAlgorithmSuite();
        try {
            this.verify(securityHeader, algorithmSuite, dsaCrypto, false);
            SamlAlgorithmSuiteTest.fail((String)"Expected failure as DSA is not allowed");
        }
        catch (WSSecurityException ex) {
            // empty catch block
        }
        algorithmSuite.addSignatureMethod("http://www.w3.org/2000/09/xmldsig#dsa-sha1");
        this.verify(securityHeader, algorithmSuite, dsaCrypto, false);
    }

    @Test
    public void testC14nMethod() throws Exception {
        SAML1CallbackHandler callbackHandler = new SAML1CallbackHandler();
        callbackHandler.setStatement(AbstractSAMLCallbackHandler.Statement.AUTHN);
        callbackHandler.setConfirmationMethod("urn:oasis:names:tc:SAML:1.0:cm:holder-of-key");
        callbackHandler.setIssuer("www.example.com");
        SAMLCallback samlCallback = new SAMLCallback();
        SAMLUtil.doSAMLCallback((CallbackHandler)callbackHandler, (SAMLCallback)samlCallback);
        SamlAssertionWrapper samlAssertion = new SamlAssertionWrapper(samlCallback);
        samlAssertion.signAssertion("16c73ab6-b892-458f-abf5-2f875f74882e", "security", this.crypto, false, "http://www.w3.org/2001/10/xml-exc-c14n#WithComments", "http://www.w3.org/2000/09/xmldsig#rsa-sha1");
        WSSecSAMLToken wsSign = new WSSecSAMLToken();
        Document doc = SOAPUtil.toSOAPPart("<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader();
        secHeader.insertSecurityHeader(doc);
        Document signedDoc = wsSign.build(doc, samlAssertion, secHeader);
        if (LOG.isDebugEnabled()) {
            String outputString = XMLUtils.PrettyDocumentToString((Document)signedDoc);
            LOG.debug(outputString);
        }
        Element securityHeader = WSSecurityUtil.getSecurityHeader((Document)signedDoc, null);
        AlgorithmSuite algorithmSuite = this.createAlgorithmSuite();
        try {
            this.verify(securityHeader, algorithmSuite, this.crypto, false);
            SamlAlgorithmSuiteTest.fail((String)"Expected failure as C14n algorithm is not allowed");
        }
        catch (WSSecurityException ex) {
            // empty catch block
        }
        algorithmSuite.addC14nAlgorithm("http://www.w3.org/2001/10/xml-exc-c14n#WithComments");
        this.verify(securityHeader, algorithmSuite, this.crypto, false);
    }

    private AlgorithmSuite createAlgorithmSuite() {
        AlgorithmSuite algorithmSuite = new AlgorithmSuite();
        algorithmSuite.addSignatureMethod("http://www.w3.org/2000/09/xmldsig#rsa-sha1");
        algorithmSuite.setMinimumAsymmetricKeyLength(512);
        algorithmSuite.addC14nAlgorithm("http://www.w3.org/2001/10/xml-exc-c14n#");
        algorithmSuite.addDigestAlgorithm("http://www.w3.org/2000/09/xmldsig#sha1");
        return algorithmSuite;
    }

    private List<WSSecurityEngineResult> verify(Element securityHeader, AlgorithmSuite algorithmSuite, Crypto sigVerCrypto, boolean saml2) throws Exception {
        WSSecurityEngine secEngine = new WSSecurityEngine();
        WSSConfig config = WSSConfig.getNewInstance();
        config.setValidateSamlSubjectConfirmation(false);
        secEngine.setWssConfig(config);
        RequestData data = new RequestData();
        data.setSigVerCrypto(sigVerCrypto);
        data.setSamlAlgorithmSuite(algorithmSuite);
        return secEngine.processSecurityHeader(securityHeader, data);
    }
}

