/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wss4j.dom.saml;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.security.auth.callback.CallbackHandler;
import org.apache.wss4j.common.crypto.Crypto;
import org.apache.wss4j.common.crypto.CryptoFactory;
import org.apache.wss4j.common.saml.SAMLCallback;
import org.apache.wss4j.common.saml.SAMLUtil;
import org.apache.wss4j.common.saml.SamlAssertionWrapper;
import org.apache.wss4j.common.util.XMLUtils;
import org.apache.wss4j.dom.WSDataRef;
import org.apache.wss4j.dom.WSSConfig;
import org.apache.wss4j.dom.WSSecurityEngine;
import org.apache.wss4j.dom.WSSecurityEngineResult;
import org.apache.wss4j.dom.common.AbstractSAMLCallbackHandler;
import org.apache.wss4j.dom.common.CustomHandler;
import org.apache.wss4j.dom.common.KeystoreCallbackHandler;
import org.apache.wss4j.dom.common.SAML1CallbackHandler;
import org.apache.wss4j.dom.common.SAML2CallbackHandler;
import org.apache.wss4j.dom.common.SOAPUtil;
import org.apache.wss4j.dom.common.SecurityTestUtil;
import org.apache.wss4j.dom.handler.RequestData;
import org.apache.wss4j.dom.message.WSSecHeader;
import org.apache.wss4j.dom.saml.WSSecSignatureSAML;
import org.apache.wss4j.dom.util.WSSecurityUtil;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public class SamlTokenSVTest
extends Assert {
    private static final Logger LOG = LoggerFactory.getLogger(SamlTokenSVTest.class);
    private WSSecurityEngine secEngine = new WSSecurityEngine();
    private CallbackHandler callbackHandler = new KeystoreCallbackHandler();
    private Crypto crypto = null;

    @AfterClass
    public static void cleanup() throws Exception {
        SecurityTestUtil.cleanup();
    }

    public SamlTokenSVTest() throws Exception {
        WSSConfig.init();
        this.crypto = CryptoFactory.getInstance((String)"crypto.properties");
    }

    @Test
    public void testSAML1AuthnAssertion() throws Exception {
        List<WSSecurityEngineResult> results;
        WSSecurityEngineResult actionResult;
        SamlAssertionWrapper receivedSamlAssertion;
        SAML1CallbackHandler callbackHandler = new SAML1CallbackHandler();
        callbackHandler.setStatement(AbstractSAMLCallbackHandler.Statement.AUTHN);
        callbackHandler.setConfirmationMethod("urn:oasis:names:tc:SAML:1.0:cm:sender-vouches");
        callbackHandler.setIssuer("www.example.com");
        SAMLCallback samlCallback = new SAMLCallback();
        SAMLUtil.doSAMLCallback((CallbackHandler)callbackHandler, (SAMLCallback)samlCallback);
        SamlAssertionWrapper samlAssertion = new SamlAssertionWrapper(samlCallback);
        WSSecSignatureSAML wsSign = new WSSecSignatureSAML();
        wsSign.setKeyIdentifierType(1);
        Document doc = SOAPUtil.toSOAPPart("<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader();
        secHeader.insertSecurityHeader(doc);
        Document signedDoc = wsSign.build(doc, null, samlAssertion, this.crypto, "16c73ab6-b892-458f-abf5-2f875f74882e", "security", secHeader);
        if (LOG.isDebugEnabled()) {
            LOG.debug("SAML 1.1 Authn Assertion (sender vouches):");
            String outputString = XMLUtils.PrettyDocumentToString((Document)signedDoc);
            LOG.debug(outputString);
        }
        SamlTokenSVTest.assertTrue(((receivedSamlAssertion = (SamlAssertionWrapper)(actionResult = WSSecurityUtil.fetchActionResult(results = this.verify(signedDoc), (int)8)).get((Object)"saml-assertion")) != null ? 1 : 0) != 0);
        actionResult = WSSecurityUtil.fetchActionResult(results, (int)2);
        SamlTokenSVTest.assertTrue((actionResult != null ? 1 : 0) != 0);
        SamlTokenSVTest.assertFalse((boolean)actionResult.isEmpty());
        List refs = (List)actionResult.get((Object)"data-ref-uris");
        SamlTokenSVTest.assertTrue((refs.size() == 2 ? 1 : 0) != 0);
        WSDataRef wsDataRef = (WSDataRef)refs.get(0);
        String xpath = wsDataRef.getXpath();
        SamlTokenSVTest.assertEquals((Object)"/SOAP-ENV:Envelope/SOAP-ENV:Body", (Object)xpath);
        wsDataRef = (WSDataRef)refs.get(1);
        xpath = wsDataRef.getXpath();
        SamlTokenSVTest.assertEquals((Object)"/SOAP-ENV:Envelope/SOAP-ENV:Header/wsse:Security/saml1:Assertion", (Object)xpath);
    }

    @Test
    public void testSAML1AttrAssertion() throws Exception {
        List<WSSecurityEngineResult> results;
        WSSecurityEngineResult actionResult;
        SamlAssertionWrapper receivedSamlAssertion;
        SAML1CallbackHandler callbackHandler = new SAML1CallbackHandler();
        callbackHandler.setStatement(AbstractSAMLCallbackHandler.Statement.ATTR);
        callbackHandler.setConfirmationMethod("urn:oasis:names:tc:SAML:1.0:cm:sender-vouches");
        callbackHandler.setIssuer("www.example.com");
        SAMLCallback samlCallback = new SAMLCallback();
        SAMLUtil.doSAMLCallback((CallbackHandler)callbackHandler, (SAMLCallback)samlCallback);
        SamlAssertionWrapper samlAssertion = new SamlAssertionWrapper(samlCallback);
        WSSecSignatureSAML wsSign = new WSSecSignatureSAML();
        wsSign.setKeyIdentifierType(1);
        Document doc = SOAPUtil.toSOAPPart("<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader();
        secHeader.insertSecurityHeader(doc);
        Document signedDoc = wsSign.build(doc, null, samlAssertion, this.crypto, "16c73ab6-b892-458f-abf5-2f875f74882e", "security", secHeader);
        if (LOG.isDebugEnabled()) {
            LOG.debug("SAML 1.1 Attr Assertion (sender vouches):");
            String outputString = XMLUtils.PrettyDocumentToString((Document)signedDoc);
            LOG.debug(outputString);
        }
        SamlTokenSVTest.assertTrue(((receivedSamlAssertion = (SamlAssertionWrapper)(actionResult = WSSecurityUtil.fetchActionResult(results = this.verify(signedDoc), (int)8)).get((Object)"saml-assertion")) != null ? 1 : 0) != 0);
        actionResult = WSSecurityUtil.fetchActionResult(results, (int)2);
        SamlTokenSVTest.assertTrue((actionResult != null ? 1 : 0) != 0);
        SamlTokenSVTest.assertFalse((boolean)actionResult.isEmpty());
        List refs = (List)actionResult.get((Object)"data-ref-uris");
        SamlTokenSVTest.assertTrue((refs.size() == 2 ? 1 : 0) != 0);
        WSDataRef wsDataRef = (WSDataRef)refs.get(0);
        String xpath = wsDataRef.getXpath();
        SamlTokenSVTest.assertEquals((Object)"/SOAP-ENV:Envelope/SOAP-ENV:Body", (Object)xpath);
        wsDataRef = (WSDataRef)refs.get(1);
        xpath = wsDataRef.getXpath();
        SamlTokenSVTest.assertEquals((Object)"/SOAP-ENV:Envelope/SOAP-ENV:Header/wsse:Security/saml1:Assertion", (Object)xpath);
    }

    @Test
    public void testSAML2AuthnAssertion() throws Exception {
        List<WSSecurityEngineResult> results;
        WSSecurityEngineResult actionResult;
        SamlAssertionWrapper receivedSamlAssertion;
        SAML2CallbackHandler callbackHandler = new SAML2CallbackHandler();
        callbackHandler.setStatement(AbstractSAMLCallbackHandler.Statement.AUTHN);
        callbackHandler.setConfirmationMethod("urn:oasis:names:tc:SAML:2.0:cm:sender-vouches");
        callbackHandler.setIssuer("www.example.com");
        SAMLCallback samlCallback = new SAMLCallback();
        SAMLUtil.doSAMLCallback((CallbackHandler)callbackHandler, (SAMLCallback)samlCallback);
        SamlAssertionWrapper samlAssertion = new SamlAssertionWrapper(samlCallback);
        WSSecSignatureSAML wsSign = new WSSecSignatureSAML();
        wsSign.setKeyIdentifierType(1);
        Document doc = SOAPUtil.toSOAPPart("<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader();
        secHeader.insertSecurityHeader(doc);
        Document signedDoc = wsSign.build(doc, null, samlAssertion, this.crypto, "16c73ab6-b892-458f-abf5-2f875f74882e", "security", secHeader);
        if (LOG.isDebugEnabled()) {
            LOG.debug("SAML 2 Authn Assertion (sender vouches):");
            String outputString = XMLUtils.PrettyDocumentToString((Document)signedDoc);
            LOG.debug(outputString);
        }
        SamlTokenSVTest.assertTrue(((receivedSamlAssertion = (SamlAssertionWrapper)(actionResult = WSSecurityUtil.fetchActionResult(results = this.verify(signedDoc), (int)8)).get((Object)"saml-assertion")) != null ? 1 : 0) != 0);
        actionResult = WSSecurityUtil.fetchActionResult(results, (int)2);
        SamlTokenSVTest.assertTrue((actionResult != null ? 1 : 0) != 0);
        SamlTokenSVTest.assertFalse((boolean)actionResult.isEmpty());
        List refs = (List)actionResult.get((Object)"data-ref-uris");
        SamlTokenSVTest.assertTrue((refs.size() == 2 ? 1 : 0) != 0);
        WSDataRef wsDataRef = (WSDataRef)refs.get(0);
        String xpath = wsDataRef.getXpath();
        SamlTokenSVTest.assertEquals((Object)"/SOAP-ENV:Envelope/SOAP-ENV:Body", (Object)xpath);
        wsDataRef = (WSDataRef)refs.get(1);
        xpath = wsDataRef.getXpath();
        SamlTokenSVTest.assertEquals((Object)"/SOAP-ENV:Envelope/SOAP-ENV:Header/wsse:Security/saml2:Assertion", (Object)xpath);
    }

    @Test
    public void testSAML2AttrAssertion() throws Exception {
        List<WSSecurityEngineResult> results;
        WSSecurityEngineResult actionResult;
        SamlAssertionWrapper receivedSamlAssertion;
        SAML2CallbackHandler callbackHandler = new SAML2CallbackHandler();
        callbackHandler.setStatement(AbstractSAMLCallbackHandler.Statement.ATTR);
        callbackHandler.setConfirmationMethod("urn:oasis:names:tc:SAML:2.0:cm:sender-vouches");
        callbackHandler.setIssuer("www.example.com");
        SAMLCallback samlCallback = new SAMLCallback();
        SAMLUtil.doSAMLCallback((CallbackHandler)callbackHandler, (SAMLCallback)samlCallback);
        SamlAssertionWrapper samlAssertion = new SamlAssertionWrapper(samlCallback);
        WSSecSignatureSAML wsSign = new WSSecSignatureSAML();
        wsSign.setKeyIdentifierType(1);
        Document doc = SOAPUtil.toSOAPPart("<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader();
        secHeader.insertSecurityHeader(doc);
        Document signedDoc = wsSign.build(doc, null, samlAssertion, this.crypto, "16c73ab6-b892-458f-abf5-2f875f74882e", "security", secHeader);
        if (LOG.isDebugEnabled()) {
            LOG.debug("SAML 2 Attr Assertion (sender vouches):");
            String outputString = XMLUtils.PrettyDocumentToString((Document)signedDoc);
            LOG.debug(outputString);
        }
        SamlTokenSVTest.assertTrue(((receivedSamlAssertion = (SamlAssertionWrapper)(actionResult = WSSecurityUtil.fetchActionResult(results = this.verify(signedDoc), (int)8)).get((Object)"saml-assertion")) != null ? 1 : 0) != 0);
        actionResult = WSSecurityUtil.fetchActionResult(results, (int)2);
        SamlTokenSVTest.assertTrue((actionResult != null ? 1 : 0) != 0);
        SamlTokenSVTest.assertFalse((boolean)actionResult.isEmpty());
        List refs = (List)actionResult.get((Object)"data-ref-uris");
        SamlTokenSVTest.assertTrue((refs.size() == 2 ? 1 : 0) != 0);
        WSDataRef wsDataRef = (WSDataRef)refs.get(0);
        String xpath = wsDataRef.getXpath();
        SamlTokenSVTest.assertEquals((Object)"/SOAP-ENV:Envelope/SOAP-ENV:Body", (Object)xpath);
        wsDataRef = (WSDataRef)refs.get(1);
        xpath = wsDataRef.getXpath();
        SamlTokenSVTest.assertEquals((Object)"/SOAP-ENV:Envelope/SOAP-ENV:Header/wsse:Security/saml2:Assertion", (Object)xpath);
    }

    @Test
    public void testWSS62() throws Exception {
        SAML2CallbackHandler callbackHandler = new SAML2CallbackHandler();
        callbackHandler.setStatement(AbstractSAMLCallbackHandler.Statement.ATTR);
        callbackHandler.setConfirmationMethod("urn:oasis:names:tc:SAML:2.0:cm:sender-vouches");
        callbackHandler.setIssuer("www.example.com");
        SAMLCallback samlCallback = new SAMLCallback();
        SAMLUtil.doSAMLCallback((CallbackHandler)callbackHandler, (SAMLCallback)samlCallback);
        SamlAssertionWrapper samlAssertion = new SamlAssertionWrapper(samlCallback);
        WSSecSignatureSAML wsSign = new WSSecSignatureSAML();
        wsSign.setKeyIdentifierType(1);
        Document doc = SOAPUtil.toSOAPPart("<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader();
        secHeader.insertSecurityHeader(doc);
        Document signedDoc = wsSign.build(doc, null, samlAssertion, this.crypto, "16c73ab6-b892-458f-abf5-2f875f74882e", "security", secHeader);
        WSSConfig cfg = WSSConfig.getNewInstance();
        RequestData reqData = new RequestData();
        reqData.setWssConfig(cfg);
        HashMap<String, String> msgContext = new HashMap<String, String>();
        msgContext.put("signatureVerificationPropFile", "crypto.properties");
        reqData.setMsgContext(msgContext);
        CustomHandler handler = new CustomHandler();
        handler.receive(Collections.singletonList(16), reqData);
        this.secEngine.processSecurityHeader(signedDoc, null, (CallbackHandler)callbackHandler, reqData.getSigVerCrypto(), reqData.getDecCrypto());
    }

    private List<WSSecurityEngineResult> verify(Document doc) throws Exception {
        List results = this.secEngine.processSecurityHeader(doc, null, this.callbackHandler, this.crypto);
        String outputString = XMLUtils.PrettyDocumentToString((Document)doc);
        SamlTokenSVTest.assertTrue((outputString.indexOf("counter_port_type") > 0 ? 1 : 0) != 0);
        return results;
    }
}

