/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wss4j.dom;

import java.io.Serializable;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.Provider;
import java.security.Security;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.namespace.QName;
import org.apache.wss4j.common.crypto.WSProviderConfig;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.common.util.WSCurrentTimeSource;
import org.apache.wss4j.common.util.WSTimeSource;
import org.apache.wss4j.dom.WSSecurityEngine;
import org.apache.wss4j.dom.WsuIdAllocator;
import org.apache.wss4j.dom.action.Action;
import org.apache.wss4j.dom.action.CustomTokenAction;
import org.apache.wss4j.dom.action.EncryptionAction;
import org.apache.wss4j.dom.action.SAMLTokenSignedAction;
import org.apache.wss4j.dom.action.SAMLTokenUnsignedAction;
import org.apache.wss4j.dom.action.SignatureAction;
import org.apache.wss4j.dom.action.SignatureConfirmationAction;
import org.apache.wss4j.dom.action.TimestampAction;
import org.apache.wss4j.dom.action.UsernameTokenAction;
import org.apache.wss4j.dom.action.UsernameTokenSignedAction;
import org.apache.wss4j.dom.processor.BinarySecurityTokenProcessor;
import org.apache.wss4j.dom.processor.DerivedKeyTokenProcessor;
import org.apache.wss4j.dom.processor.EncryptedDataProcessor;
import org.apache.wss4j.dom.processor.EncryptedKeyProcessor;
import org.apache.wss4j.dom.processor.Processor;
import org.apache.wss4j.dom.processor.ReferenceListProcessor;
import org.apache.wss4j.dom.processor.SAMLTokenProcessor;
import org.apache.wss4j.dom.processor.SecurityContextTokenProcessor;
import org.apache.wss4j.dom.processor.SignatureConfirmationProcessor;
import org.apache.wss4j.dom.processor.SignatureProcessor;
import org.apache.wss4j.dom.processor.TimestampProcessor;
import org.apache.wss4j.dom.processor.UsernameTokenProcessor;
import org.apache.wss4j.dom.resolvers.ResolverAttachment;
import org.apache.wss4j.dom.transform.AttachmentCiphertextTransform;
import org.apache.wss4j.dom.transform.AttachmentCompleteSignatureTransformProvider;
import org.apache.wss4j.dom.transform.AttachmentContentSignatureTransformProvider;
import org.apache.wss4j.dom.transform.STRTransformProvider;
import org.apache.wss4j.dom.validate.SamlAssertionValidator;
import org.apache.wss4j.dom.validate.SignatureTrustValidator;
import org.apache.wss4j.dom.validate.TimestampValidator;
import org.apache.wss4j.dom.validate.UsernameTokenValidator;
import org.apache.wss4j.dom.validate.Validator;
import org.apache.xml.security.stax.impl.util.IDGenerator;
import org.apache.xml.security.transforms.Transform;
import org.apache.xml.security.utils.resolver.ResourceResolver;
import org.apache.xml.security.utils.resolver.ResourceResolverSpi;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WSSConfig {
    public static final DatatypeFactory datatypeFactory;
    private static final Logger LOG;
    private static final Map<Integer, Class<?>> DEFAULT_ACTIONS;
    private static final Map<QName, Class<?>> DEFAULT_PROCESSORS;
    private static final Map<QName, Class<?>> DEFAULT_VALIDATORS;
    private boolean addInclusivePrefixes = true;
    private boolean precisionInMilliSeconds = true;
    private boolean enableSignatureConfirmation;
    private boolean timeStampStrict = true;
    private String requiredPasswordType;
    private boolean allowUsernameTokenNoPassword;
    private int timeStampTTL = 300;
    private int timeStampFutureTTL = 60;
    private int utTTL = 300;
    private int utFutureTTL = 60;
    private boolean handleCustomPasswordTypes;
    private boolean allowNamespaceQualifiedPasswordTypes;
    private boolean passwordsAreEncoded;
    private boolean validateSamlSubjectConfirmation = true;
    private WSTimeSource currentTime;
    public static final WsuIdAllocator DEFAULT_ID_ALLOCATOR;
    protected WsuIdAllocator idAllocator = DEFAULT_ID_ALLOCATOR;
    private final Map<Integer, Object> actionMap = new HashMap(DEFAULT_ACTIONS);
    private final Map<QName, Object> processorMap = new HashMap(DEFAULT_PROCESSORS);
    private final Map<QName, Object> validatorMap = new HashMap(DEFAULT_VALIDATORS);

    private WSSConfig() {
    }

    public static synchronized void init() {
        WSProviderConfig.init();
    }

    public static WSSConfig getNewInstance() {
        WSSConfig.init();
        return new WSSConfig();
    }

    public boolean isPrecisionInMilliSeconds() {
        return this.precisionInMilliSeconds;
    }

    public void setPrecisionInMilliSeconds(boolean precisionInMilliSeconds) {
        this.precisionInMilliSeconds = precisionInMilliSeconds;
    }

    public boolean isEnableSignatureConfirmation() {
        return this.enableSignatureConfirmation;
    }

    public void setEnableSignatureConfirmation(boolean enableSignatureConfirmation) {
        this.enableSignatureConfirmation = enableSignatureConfirmation;
    }

    public void setHandleCustomPasswordTypes(boolean handleCustomTypes) {
        this.handleCustomPasswordTypes = handleCustomTypes;
    }

    public boolean getHandleCustomPasswordTypes() {
        return this.handleCustomPasswordTypes;
    }

    public void setAllowNamespaceQualifiedPasswordTypes(boolean allowNamespaceQualifiedTypes) {
        this.allowNamespaceQualifiedPasswordTypes = allowNamespaceQualifiedTypes;
    }

    public boolean getAllowNamespaceQualifiedPasswordTypes() {
        return this.allowNamespaceQualifiedPasswordTypes;
    }

    public boolean isTimeStampStrict() {
        return this.timeStampStrict;
    }

    public void setTimeStampStrict(boolean timeStampStrict) {
        this.timeStampStrict = timeStampStrict;
    }

    public String getRequiredPasswordType() {
        return this.requiredPasswordType;
    }

    public void setRequiredPasswordType(String requiredPasswordType) {
        this.requiredPasswordType = requiredPasswordType;
    }

    public int getTimeStampTTL() {
        return this.timeStampTTL;
    }

    public void setTimeStampTTL(int timeStampTTL) {
        this.timeStampTTL = timeStampTTL;
    }

    public int getTimeStampFutureTTL() {
        return this.timeStampFutureTTL;
    }

    public void setTimeStampFutureTTL(int timeStampFutureTTL) {
        this.timeStampFutureTTL = timeStampFutureTTL;
    }

    public void setPasswordsAreEncoded(boolean passwordsAreEncoded) {
        this.passwordsAreEncoded = passwordsAreEncoded;
    }

    public boolean getPasswordsAreEncoded() {
        return this.passwordsAreEncoded;
    }

    public WsuIdAllocator getIdAllocator() {
        return this.idAllocator;
    }

    public void setIdAllocator(WsuIdAllocator idAllocator) {
        this.idAllocator = idAllocator;
    }

    public Class<?> setAction(int code, Action action) {
        Object result = this.actionMap.put(code, action);
        if (result instanceof Class) {
            return (Class)result;
        }
        if (result instanceof Action) {
            return result.getClass();
        }
        return null;
    }

    public Class<?> setAction(int code, Class<?> clazz) {
        Class<?> result = this.actionMap.put(code, clazz);
        if (result instanceof Class) {
            return result;
        }
        if (result instanceof Action) {
            return result.getClass();
        }
        return null;
    }

    public Action getAction(int action) throws WSSecurityException {
        Object actionObject = this.actionMap.get(action);
        if (actionObject instanceof Class) {
            try {
                return (Action)((Class)actionObject).newInstance();
            }
            catch (Throwable t) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug(t.getMessage(), t);
                }
                throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, "unableToLoadClass", new Object[]{t, ((Class)actionObject).getName()});
            }
        }
        if (actionObject instanceof Action) {
            return (Action)actionObject;
        }
        return null;
    }

    public Class<?> setProcessor(QName el, Processor processor) {
        Object result = this.processorMap.put(el, processor);
        if (result instanceof Class) {
            return (Class)result;
        }
        if (result instanceof Processor) {
            return result.getClass();
        }
        return null;
    }

    public Class<?> setProcessor(QName el, Class<?> clazz) {
        Class<?> result = this.processorMap.put(el, clazz);
        if (result instanceof Class) {
            return result;
        }
        if (result instanceof Processor) {
            return result.getClass();
        }
        return null;
    }

    public Class<?> setValidator(QName el, Validator validator) {
        Object result = this.validatorMap.put(el, validator);
        if (result instanceof Class) {
            return (Class)result;
        }
        if (result instanceof Validator) {
            return result.getClass();
        }
        return null;
    }

    public Class<?> setValidator(QName el, Class<?> clazz) {
        Class<?> result = this.validatorMap.put(el, clazz);
        if (result instanceof Class) {
            return result;
        }
        if (result instanceof Validator) {
            return result.getClass();
        }
        return null;
    }

    public Validator getValidator(QName el) throws WSSecurityException {
        Object validatorObject = this.validatorMap.get(el);
        if (validatorObject instanceof Class) {
            try {
                return (Validator)((Class)validatorObject).newInstance();
            }
            catch (Throwable t) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug(t.getMessage(), t);
                }
                throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, "unableToLoadClass", new Object[]{t, ((Class)validatorObject).getName()});
            }
        }
        if (validatorObject instanceof Validator) {
            return (Validator)validatorObject;
        }
        return null;
    }

    public Processor getProcessor(QName el) throws WSSecurityException {
        Object processorObject = this.processorMap.get(el);
        if (processorObject instanceof Class) {
            try {
                return (Processor)((Class)processorObject).newInstance();
            }
            catch (Throwable t) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug(t.getMessage(), t);
                }
                throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, "unableToLoadClass", new Object[]{t, ((Class)processorObject).getName()});
            }
        }
        if (processorObject instanceof Processor) {
            return (Processor)processorObject;
        }
        return null;
    }

    public boolean isAddInclusivePrefixes() {
        return this.addInclusivePrefixes;
    }

    public void setAddInclusivePrefixes(boolean addInclusivePrefixes) {
        this.addInclusivePrefixes = addInclusivePrefixes;
    }

    public boolean isAllowUsernameTokenNoPassword() {
        return this.allowUsernameTokenNoPassword;
    }

    public void setAllowUsernameTokenNoPassword(boolean allowUsernameTokenNoPassword) {
        this.allowUsernameTokenNoPassword = allowUsernameTokenNoPassword;
    }

    public int getUtTTL() {
        return this.utTTL;
    }

    public void setUtTTL(int utTTL) {
        this.utTTL = utTTL;
    }

    public int getUtFutureTTL() {
        return this.utFutureTTL;
    }

    public void setUtFutureTTL(int utFutureTTL) {
        this.utFutureTTL = utFutureTTL;
    }

    public boolean isValidateSamlSubjectConfirmation() {
        return this.validateSamlSubjectConfirmation;
    }

    public void setValidateSamlSubjectConfirmation(boolean validateSamlSubjectConfirmation) {
        this.validateSamlSubjectConfirmation = validateSamlSubjectConfirmation;
    }

    public WSTimeSource getCurrentTime() {
        if (this.currentTime != null) {
            return this.currentTime;
        }
        return new WSCurrentTimeSource();
    }

    public void setCurrentTime(WSTimeSource currentTime) {
        this.currentTime = currentTime;
    }

    static {
        block13: {
            HashMap<Serializable, Class> tmp;
            block12: {
                block11: {
                    block10: {
                        try {
                            datatypeFactory = DatatypeFactory.newInstance();
                        }
                        catch (DatatypeConfigurationException e) {
                            throw new RuntimeException(e);
                        }
                        LOG = LoggerFactory.getLogger(WSSConfig.class);
                        tmp = new HashMap<Serializable, Class>();
                        try {
                            tmp.put(Integer.valueOf(1), UsernameTokenAction.class);
                            tmp.put(Integer.valueOf(4), EncryptionAction.class);
                            tmp.put(Integer.valueOf(2), SignatureAction.class);
                            tmp.put(Integer.valueOf(16), SAMLTokenSignedAction.class);
                            tmp.put(Integer.valueOf(8), SAMLTokenUnsignedAction.class);
                            tmp.put(Integer.valueOf(32), TimestampAction.class);
                            tmp.put(Integer.valueOf(64), UsernameTokenSignedAction.class);
                            tmp.put(Integer.valueOf(128), SignatureConfirmationAction.class);
                            tmp.put(Integer.valueOf(16384), CustomTokenAction.class);
                        }
                        catch (Exception ex) {
                            if (!LOG.isDebugEnabled()) break block10;
                            LOG.debug(ex.getMessage(), (Throwable)ex);
                        }
                    }
                    DEFAULT_ACTIONS = Collections.unmodifiableMap(tmp);
                    tmp = new HashMap();
                    try {
                        tmp.put(WSSecurityEngine.SAML_TOKEN, SAMLTokenProcessor.class);
                        tmp.put(WSSecurityEngine.SAML2_TOKEN, SAMLTokenProcessor.class);
                        tmp.put(WSSecurityEngine.ENCRYPTED_KEY, EncryptedKeyProcessor.class);
                        tmp.put(WSSecurityEngine.SIGNATURE, SignatureProcessor.class);
                        tmp.put(WSSecurityEngine.TIMESTAMP, TimestampProcessor.class);
                        tmp.put(WSSecurityEngine.USERNAME_TOKEN, UsernameTokenProcessor.class);
                        tmp.put(WSSecurityEngine.REFERENCE_LIST, ReferenceListProcessor.class);
                        tmp.put(WSSecurityEngine.SIGNATURE_CONFIRMATION, SignatureConfirmationProcessor.class);
                        tmp.put(WSSecurityEngine.DERIVED_KEY_TOKEN_05_02, DerivedKeyTokenProcessor.class);
                        tmp.put(WSSecurityEngine.DERIVED_KEY_TOKEN_05_12, (Class)tmp.get(WSSecurityEngine.DERIVED_KEY_TOKEN_05_02));
                        tmp.put(WSSecurityEngine.SECURITY_CONTEXT_TOKEN_05_02, SecurityContextTokenProcessor.class);
                        tmp.put(WSSecurityEngine.SECURITY_CONTEXT_TOKEN_05_12, (Class)tmp.get(WSSecurityEngine.SECURITY_CONTEXT_TOKEN_05_02));
                        tmp.put(WSSecurityEngine.BINARY_TOKEN, BinarySecurityTokenProcessor.class);
                        tmp.put(WSSecurityEngine.ENCRYPTED_DATA, EncryptedDataProcessor.class);
                    }
                    catch (Exception ex) {
                        if (!LOG.isDebugEnabled()) break block11;
                        LOG.debug(ex.getMessage(), (Throwable)ex);
                    }
                }
                DEFAULT_PROCESSORS = Collections.unmodifiableMap(tmp);
                tmp = new HashMap();
                try {
                    tmp.put(WSSecurityEngine.SAML_TOKEN, SamlAssertionValidator.class);
                    tmp.put(WSSecurityEngine.SAML2_TOKEN, SamlAssertionValidator.class);
                    tmp.put(WSSecurityEngine.SIGNATURE, SignatureTrustValidator.class);
                    tmp.put(WSSecurityEngine.TIMESTAMP, TimestampValidator.class);
                    tmp.put(WSSecurityEngine.USERNAME_TOKEN, UsernameTokenValidator.class);
                }
                catch (Exception ex) {
                    if (!LOG.isDebugEnabled()) break block12;
                    LOG.debug(ex.getMessage(), (Throwable)ex);
                }
            }
            DEFAULT_VALIDATORS = Collections.unmodifiableMap(tmp);
            DEFAULT_ID_ALLOCATOR = new WsuIdAllocator(){

                @Override
                public String createId(String prefix, Object o) {
                    if (prefix == null) {
                        return IDGenerator.generateID((String)"_");
                    }
                    return IDGenerator.generateID((String)prefix);
                }

                @Override
                public String createSecureId(String prefix, Object o) {
                    return IDGenerator.generateID((String)prefix);
                }
            };
            AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

                @Override
                public Boolean run() {
                    Security.removeProvider("STRTransform");
                    WSProviderConfig.appendJceProvider((String)"STRTransform", (Provider)new STRTransformProvider());
                    Security.removeProvider("AttachmentContentSignatureTransform");
                    WSProviderConfig.appendJceProvider((String)"AttachmentContentSignatureTransform", (Provider)new AttachmentContentSignatureTransformProvider());
                    Security.removeProvider("AttachmentCompleteSignatureTransform");
                    WSProviderConfig.appendJceProvider((String)"AttachmentCompleteSignatureTransform", (Provider)new AttachmentCompleteSignatureTransformProvider());
                    return true;
                }
            });
            try {
                Transform.register((String)"http://docs.oasis-open.org/wss/oasis-wss-SwAProfile-1.1#Attachment-Ciphertext-Transform", AttachmentCiphertextTransform.class);
            }
            catch (Exception e) {
                if (!LOG.isDebugEnabled()) break block13;
                LOG.debug(e.getMessage(), (Throwable)e);
            }
        }
        ResourceResolver.register((ResourceResolverSpi)new ResolverAttachment(), (boolean)false);
    }
}

