/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wss4j.dom.message;

import java.util.ArrayList;
import java.util.List;
import javax.crypto.SecretKey;
import org.apache.wss4j.common.WSEncryptionPart;
import org.apache.wss4j.common.derivedKey.ConversationConstants;
import org.apache.wss4j.common.derivedKey.ConversationException;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.common.util.KeyUtils;
import org.apache.wss4j.dom.WSSConfig;
import org.apache.wss4j.dom.message.WSSecDerivedKeyBase;
import org.apache.wss4j.dom.message.WSSecEncrypt;
import org.apache.wss4j.dom.message.WSSecHeader;
import org.apache.wss4j.dom.message.token.Reference;
import org.apache.wss4j.dom.message.token.SecurityTokenReference;
import org.apache.wss4j.dom.util.WSSecurityUtil;
import org.apache.xml.security.keys.KeyInfo;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class WSSecDKEncrypt
extends WSSecDerivedKeyBase {
    private String symEncAlgo = "http://www.w3.org/2001/04/xmlenc#aes128-cbc";

    public WSSecDKEncrypt() {
    }

    public WSSecDKEncrypt(WSSConfig config) {
        super(config);
    }

    public Document build(Document doc, WSSecHeader secHeader) throws WSSecurityException, ConversationException {
        this.prepare(doc);
        this.envelope = doc.getDocumentElement();
        this.prependDKElementToHeader(secHeader);
        String soapNamespace = WSSecurityUtil.getSOAPNamespace(this.envelope);
        if (this.parts == null) {
            this.parts = new ArrayList(1);
            WSEncryptionPart encP = new WSEncryptionPart("Body", soapNamespace, "Content");
            this.parts.add(encP);
        }
        Element externRefList = this.encryptForExternalRef(null, this.parts);
        this.addExternalRefElement(externRefList, secHeader);
        return doc;
    }

    public Element encryptForExternalRef(Element dataRef, List<WSEncryptionPart> references) throws WSSecurityException {
        KeyInfo keyInfo = this.createKeyInfo();
        SecretKey key = KeyUtils.prepareSecretKey((String)this.symEncAlgo, (byte[])this.derivedKeyBytes);
        List<String> encDataRefs = WSSecEncrypt.doEncryption(this.document, this.getWsConfig(), keyInfo, key, this.symEncAlgo, references, this.callbackLookup);
        if (dataRef == null) {
            dataRef = this.document.createElementNS("http://www.w3.org/2001/04/xmlenc#", "xenc:ReferenceList");
        }
        return WSSecEncrypt.createDataRefList(this.document, dataRef, encDataRefs);
    }

    private KeyInfo createKeyInfo() throws WSSecurityException {
        KeyInfo keyInfo = new KeyInfo(this.document);
        SecurityTokenReference secToken = new SecurityTokenReference(this.document);
        secToken.addWSSENamespace();
        Reference ref = new Reference(this.document);
        ref.setURI("#" + this.dktId);
        String ns = ConversationConstants.getWSCNs((int)this.getWscVersion()) + "/dk";
        ref.setValueType(ns);
        secToken.setReference(ref);
        keyInfo.addUnknownElement(secToken.getElement());
        Element keyInfoElement = keyInfo.getElement();
        keyInfoElement.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:ds", "http://www.w3.org/2000/09/xmldsig#");
        return keyInfo;
    }

    public void addExternalRefElement(Element referenceList, WSSecHeader secHeader) {
        Node node = this.dkt.getElement().getNextSibling();
        if (node != null && 1 == node.getNodeType()) {
            secHeader.getSecurityHeader().insertBefore(referenceList, node);
        } else {
            secHeader.getSecurityHeader().appendChild(referenceList);
        }
    }

    public void setSymmetricEncAlgorithm(String algo) {
        this.symEncAlgo = algo;
    }

    @Override
    protected int getDerivedKeyLength() throws WSSecurityException {
        return this.derivedKeyLength > 0 ? this.derivedKeyLength : KeyUtils.getKeyLength((String)this.symEncAlgo);
    }
}

