/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wss4j.dom.validate;

import java.security.Principal;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.common.kerberos.KerberosServiceAction;
import org.apache.wss4j.common.kerberos.KerberosTokenDecoder;
import org.apache.wss4j.common.kerberos.KerberosTokenDecoderException;
import org.apache.wss4j.common.kerberos.KerberosTokenDecoderImpl;
import org.apache.wss4j.dom.handler.RequestData;
import org.apache.wss4j.dom.message.token.BinarySecurity;
import org.apache.wss4j.dom.message.token.KerberosSecurity;
import org.apache.wss4j.dom.validate.Credential;
import org.apache.wss4j.dom.validate.Validator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KerberosTokenValidator
implements Validator {
    private static final Logger LOG = LoggerFactory.getLogger(KerberosTokenValidator.class);
    private String serviceName;
    private CallbackHandler callbackHandler;
    private String contextName;
    private KerberosTokenDecoder kerberosTokenDecoder;

    public String getContextName() {
        return this.contextName;
    }

    public void setContextName(String contextName) {
        this.contextName = contextName;
    }

    public CallbackHandler getCallbackHandler() {
        return this.callbackHandler;
    }

    public void setCallbackHandler(CallbackHandler callbackHandler) {
        this.callbackHandler = callbackHandler;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public KerberosTokenDecoder getKerberosTokenDecoder() {
        return this.kerberosTokenDecoder;
    }

    public void setKerberosTokenDecoder(KerberosTokenDecoder kerberosTokenDecoder) {
        this.kerberosTokenDecoder = kerberosTokenDecoder;
    }

    @Override
    public Credential validate(Credential credential, RequestData data) throws WSSecurityException {
        KerberosServiceAction action;
        Principal principal;
        if (credential == null || credential.getBinarySecurityToken() == null) {
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, "noCredential", new Object[0]);
        }
        BinarySecurity binarySecurity = credential.getBinarySecurityToken();
        if (!(binarySecurity instanceof KerberosSecurity)) {
            return credential;
        }
        if (LOG.isDebugEnabled()) {
            try {
                String jaasAuth = System.getProperty("java.security.auth.login.config");
                String krbConf = System.getProperty("java.security.krb5.conf");
                LOG.debug("KerberosTokenValidator - Using JAAS auth login file: " + jaasAuth);
                LOG.debug("KerberosTokenValidator - Using KRB conf file: " + krbConf);
            }
            catch (SecurityException ex) {
                LOG.debug(ex.getMessage(), (Throwable)ex);
            }
        }
        LoginContext loginContext = null;
        try {
            loginContext = this.callbackHandler != null ? new LoginContext(this.getContextName(), this.callbackHandler) : (data.getCallbackHandler() != null ? new LoginContext(this.getContextName(), data.getCallbackHandler()) : new LoginContext(this.getContextName()));
            loginContext.login();
        }
        catch (LoginException ex) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(ex.getMessage(), (Throwable)ex);
            }
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, "kerberosLoginError", (Exception)ex, new Object[]{ex.getMessage()});
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Successfully authenticated to the TGT");
        }
        byte[] token = binarySecurity.getToken();
        Subject subject = loginContext.getSubject();
        String service = this.serviceName;
        if (service == null) {
            Set<Principal> principals = subject.getPrincipals();
            if (principals.isEmpty()) {
                throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, "kerberosLoginError", new Object[]{"No Client principals found after login"});
            }
            service = principals.iterator().next().getName();
        }
        if ((principal = (Principal)Subject.doAs(subject, action = new KerberosServiceAction(token, service))) == null) {
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, "kerberosTicketValidationError", new Object[0]);
        }
        credential.setPrincipal(principal);
        credential.setSubject(subject);
        KerberosTokenDecoder kerberosTokenDecoder = this.kerberosTokenDecoder;
        if (kerberosTokenDecoder == null) {
            kerberosTokenDecoder = new KerberosTokenDecoderImpl();
        }
        kerberosTokenDecoder.clear();
        kerberosTokenDecoder.setToken(token);
        kerberosTokenDecoder.setSubject(subject);
        try {
            byte[] sessionKey = kerberosTokenDecoder.getSessionKey();
            credential.setSecretKey(sessionKey);
        }
        catch (KerberosTokenDecoderException e) {
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, (Exception)((Object)e));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Successfully validated a ticket");
        }
        return credential;
    }
}

