/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wss4j.dom.validate;

import java.security.PublicKey;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.wss4j.common.crypto.Crypto;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.dom.handler.RequestData;
import org.apache.wss4j.dom.validate.Credential;
import org.apache.wss4j.dom.validate.Validator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignatureTrustValidator
implements Validator {
    private static final Logger LOG = LoggerFactory.getLogger(SignatureTrustValidator.class);

    @Override
    public Credential validate(Credential credential, RequestData data) throws WSSecurityException {
        if (credential == null) {
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, "noCredential", new Object[0]);
        }
        X509Certificate[] certs = credential.getCertificates();
        PublicKey publicKey = credential.getPublicKey();
        Crypto crypto = this.getCrypto(data);
        if (crypto == null) {
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, "noSigCryptoFile", new Object[0]);
        }
        if (certs != null && certs.length > 0) {
            this.validateCertificates(certs);
            this.verifyTrustInCerts(certs, crypto, data, data.isRevocationEnabled());
            return credential;
        }
        if (publicKey != null) {
            this.validatePublicKey(publicKey, crypto);
            return credential;
        }
        throw new WSSecurityException(WSSecurityException.ErrorCode.FAILED_AUTHENTICATION);
    }

    protected Crypto getCrypto(RequestData data) {
        return data.getSigVerCrypto();
    }

    protected void validateCertificates(X509Certificate[] certificates) throws WSSecurityException {
        try {
            for (int i = 0; i < certificates.length; ++i) {
                certificates[i].checkValidity();
            }
        }
        catch (CertificateExpiredException e) {
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILED_CHECK, "invalidCert", (Exception)e);
        }
        catch (CertificateNotYetValidException e) {
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILED_CHECK, "invalidCert", (Exception)e);
        }
    }

    protected void verifyTrustInCerts(X509Certificate[] certificates, Crypto crypto, RequestData data, boolean enableRevocation) throws WSSecurityException {
        Collection<Pattern> subjectCertConstraints;
        String subjectString = certificates[0].getSubjectX500Principal().getName();
        crypto.verifyTrust(certificates, enableRevocation);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Certificate path has been verified for certificate with subject " + subjectString);
        }
        if (!this.matches(certificates[0], subjectCertConstraints = data.getSubjectCertConstraints())) {
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILED_AUTHENTICATION);
        }
    }

    protected void validatePublicKey(PublicKey publicKey, Crypto crypto) throws WSSecurityException {
        crypto.verifyTrust(publicKey);
    }

    protected boolean matches(X509Certificate cert, Collection<Pattern> subjectDNPatterns) {
        if (subjectDNPatterns.isEmpty()) {
            LOG.warn("No Subject DN Certificate Constraints were defined. This could be a security issue");
        }
        if (!subjectDNPatterns.isEmpty()) {
            if (cert == null) {
                LOG.debug("The certificate is null so no constraints matching was possible");
                return false;
            }
            String subjectName = cert.getSubjectX500Principal().getName();
            boolean subjectMatch = false;
            for (Pattern subjectDNPattern : subjectDNPatterns) {
                Matcher matcher = subjectDNPattern.matcher(subjectName);
                if (!matcher.matches()) continue;
                LOG.debug("Subject DN " + subjectName + " matches with pattern " + subjectDNPattern);
                subjectMatch = true;
                break;
            }
            if (!subjectMatch) {
                return false;
            }
        }
        return true;
    }
}

